/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import java.util.concurrent.TimeUnit;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.TextureAtlasConfig;
import org.mini2Dx.core.graphics.TextureAtlasRegion;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.gdx.utils.ObjectMap;

public class TextureAtlas
implements Disposable {
    public static final long MAX_ATLAS_LOAD_TIME_NANOS = TimeUnit.MILLISECONDS.toNanos(2L);
    private final TextureAtlasConfig config;
    private final ObjectMap<String, TextureAtlasRegion> firstRegionsCache = new ObjectMap();
    private Array<TextureAtlasRegion> atlasRegions;
    private int loadedAtlasRegions;

    public TextureAtlas(FileHandle packFile, FileHandle imagesDir) {
        this.config = new TextureAtlasConfig(packFile, imagesDir);
        for (String texturePath : this.config.getDependencies()) {
            this.config.textures.replace(texturePath, Mdx.graphics.newTexture(Mdx.files.internal(texturePath)));
        }
        this.initFromConfig(this.config, true);
    }

    public TextureAtlas(TextureAtlasConfig config) {
        this(config, true);
    }

    public TextureAtlas(TextureAtlasConfig config, boolean loadAtlasRegions) {
        this.config = config;
        this.initFromConfig(config, loadAtlasRegions);
    }

    private void initFromConfig(TextureAtlasConfig config, boolean loadAtlasRegions) {
        this.atlasRegions = config.atlasRegions;
        if (!loadAtlasRegions) {
            return;
        }
        while (!this.loadAtlasRegionTextures()) {
        }
    }

    public boolean loadAtlasRegionTextures() {
        long startTime = System.nanoTime();
        while (this.loadedAtlasRegions < this.atlasRegions.size) {
            TextureAtlasRegion region = (TextureAtlasRegion)this.atlasRegions.get(this.loadedAtlasRegions);
            region.setTexture(this.config.textures.get(region.getTexturePath()));
            if (System.nanoTime() - startTime >= MAX_ATLAS_LOAD_TIME_NANOS) {
                return false;
            }
            ++this.loadedAtlasRegions;
        }
        return true;
    }

    public Array<TextureAtlasRegion> getRegions() {
        return this.atlasRegions;
    }

    public TextureAtlasRegion findRegion(String name) {
        if (this.firstRegionsCache.containsKey((Object)name)) {
            return (TextureAtlasRegion)this.firstRegionsCache.get((Object)name);
        }
        for (int i = 0; i < this.atlasRegions.size; ++i) {
            TextureAtlasRegion region = (TextureAtlasRegion)this.atlasRegions.get(i);
            if (!region.getName().equals(name)) continue;
            this.firstRegionsCache.put((Object)name, (Object)region);
            return region;
        }
        return null;
    }

    public TextureAtlasRegion findRegion(String name, int index) {
        for (int i = 0; i < this.atlasRegions.size; ++i) {
            TextureAtlasRegion region = (TextureAtlasRegion)this.atlasRegions.get(i);
            if (!region.getName().equals(name) || region.getIndex() != index) continue;
            return region;
        }
        return null;
    }

    public Array<TextureAtlasRegion> findRegions(String name) {
        Array result = new Array();
        for (int i = 0; i < this.atlasRegions.size; ++i) {
            TextureAtlasRegion textureAtlasRegion = (TextureAtlasRegion)this.atlasRegions.get(i);
            if (!textureAtlasRegion.getName().equals(name)) continue;
            result.add((Object)textureAtlasRegion);
        }
        return result;
    }

    public void dispose() {
        this.atlasRegions.clear();
    }
}

