/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import java.io.IOException;
import java.util.HashMap;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureAtlasRegion;
import org.mini2Dx.gdx.utils.Array;

public class TextureAtlasConfig {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public HashMap<String, Texture> textures = new HashMap();
    public Array<TextureAtlasRegion> atlasRegions = new Array();

    public TextureAtlasConfig(FileHandle packFile) {
        this(packFile, packFile.parent());
    }

    public TextureAtlasConfig(FileHandle packFile, FileHandle imagesDir) {
        String[] lines;
        try {
            lines = packFile.readAllLines();
        }
        catch (IOException e) {
            throw new MdxException(e.toString());
        }
        int[] xyTuple = new int[2];
        int[] whTuple = new int[2];
        int[] originalWhTuple = new int[2];
        int[] offsetTuple = new int[2];
        for (int i = 1; i < lines.length; ++i) {
            String texturePath = imagesDir.child(lines[i]).path();
            this.textures.put(texturePath, null);
            i += 5;
            while (i < lines.length && !lines[i].isEmpty()) {
                String name = lines[i];
                boolean rotate = Boolean.parseBoolean(lines[i + 1].split(":")[1].trim());
                TextureAtlasConfig.readTuple(xyTuple, lines[i + 2]);
                int x = xyTuple[0];
                int y = xyTuple[1];
                TextureAtlasConfig.readTuple(whTuple, lines[i + 3]);
                int width = whTuple[0];
                int height = whTuple[1];
                TextureAtlasConfig.readTuple(originalWhTuple, lines[i + 4]);
                int originalWidth = originalWhTuple[0];
                int originalHeight = originalWhTuple[1];
                TextureAtlasConfig.readTuple(offsetTuple, lines[i + 5]);
                int offsetX = offsetTuple[0];
                int offsetY = offsetTuple[1];
                int index = Integer.parseInt(lines[i + 6].split(":")[1].trim());
                this.atlasRegions.add((Object)Mdx.graphics.newTextureAtlasRegion(texturePath, name, index, x, y, width, height, rotate, originalWidth, originalHeight, offsetX, offsetY));
                i += 7;
            }
        }
    }

    private static void readTuple(int[] result, String s) {
        String[] tuple = s.split(":")[1].split(",");
        result[0] = Integer.parseInt(tuple[0].trim());
        result[1] = Integer.parseInt(tuple[1].trim());
    }

    public String[] getDependencies() {
        return this.textures.keySet().toArray(EMPTY_STRING_ARRAY);
    }
}

