/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.TextureRegion;

public class TilingDrawable {
    private TextureRegion drawable;
    private TextureRegion sharedRegion;

    public TilingDrawable(TextureRegion region) {
        this.drawable = region;
        this.sharedRegion = Mdx.graphics.newTextureRegion(this.drawable);
    }

    public void draw(Graphics g, float x, float y, float width, float height) {
        int i;
        int xCount = (int)(width / (float)this.drawable.getRegionWidth());
        int yCount = (int)(height / (float)this.drawable.getRegionHeight());
        int xRemainder = (int)(width - (float)(xCount * this.drawable.getRegionWidth()));
        int yRemainder = (int)(height - (float)(yCount * this.drawable.getRegionHeight()));
        for (i = 0; i < xCount; ++i) {
            for (int j = 0; j < yCount; ++j) {
                g.drawTextureRegion(this.drawable, x + (float)(this.drawable.getRegionWidth() * i), y + (float)(j * this.drawable.getRegionHeight()));
            }
        }
        if (xRemainder != 0) {
            this.sharedRegion.setRegionWidth(xRemainder);
            this.sharedRegion.setRegionHeight(this.drawable.getRegionHeight());
            for (i = 0; i < yCount; ++i) {
                g.drawTextureRegion(this.sharedRegion, x + (float)(xCount * this.drawable.getRegionWidth()), y + (float)(i * this.drawable.getRegionHeight()));
            }
        }
        if (yRemainder != 0) {
            this.sharedRegion.setRegionWidth(this.drawable.getRegionWidth());
            this.sharedRegion.setRegionHeight(yRemainder);
            for (i = 0; i < xCount; ++i) {
                g.drawTextureRegion(this.sharedRegion, x + (float)(i * this.drawable.getRegionWidth()), y + (float)(yCount * this.drawable.getRegionHeight()));
            }
        }
        if (xRemainder != 0 && yRemainder != 0) {
            this.sharedRegion.setRegionWidth(xRemainder);
            this.sharedRegion.setRegionHeight(yRemainder);
            g.drawTextureRegion(this.sharedRegion, x + (float)(xCount * this.drawable.getRegionWidth()), y + (float)(yCount * this.drawable.getRegionHeight()));
        }
    }

    public void set(TextureRegion textureRegion) {
        this.drawable = textureRegion;
        this.sharedRegion.setRegion(textureRegion);
    }
}

