/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.FrameBuffer;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;
import org.mini2Dx.core.util.Ref;

public class BeginFrameBufferOperation
implements RenderOperation {
    private final Ref<FrameBuffer> frameBufferRef;
    private final boolean clearBuffer;
    private FrameBuffer frameBuffer;

    public BeginFrameBufferOperation(Ref<FrameBuffer> frameBufferRef) {
        this(frameBufferRef, true);
    }

    public BeginFrameBufferOperation(Ref<FrameBuffer> frameBufferRef, boolean clearBuffer) {
        this.frameBufferRef = frameBufferRef;
        this.clearBuffer = clearBuffer;
    }

    @Override
    public void update(GameContainer gc, float delta) {
        this.frameBuffer = this.frameBufferRef.get();
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        if (this.frameBuffer == null) {
            return;
        }
        this.frameBuffer.begin();
        if (!this.clearBuffer) {
            return;
        }
        g.clearContext();
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
    }
}

