/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.FrameBuffer;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;
import org.mini2Dx.core.util.Ref;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;

public class RenderFrameBufferOperation
implements RenderOperation {
    private final Ref<FrameBuffer> frameBufferRef;
    private final Vector2 renderPosition = new Vector2();
    private FrameBuffer frameBuffer;
    private int renderX;
    private int renderY;

    public RenderFrameBufferOperation(Ref<FrameBuffer> frameBufferRef) {
        this.frameBufferRef = frameBufferRef;
    }

    public void updateRenderPosition(Vector2 position, GameContainer gc, float delta) {
    }

    @Override
    public void update(GameContainer gc, float delta) {
        this.updateRenderPosition(this.renderPosition, gc, delta);
        this.frameBuffer = this.frameBufferRef.get();
        this.renderX = MathUtils.round((float)this.renderPosition.x);
        this.renderY = MathUtils.round((float)this.renderPosition.y);
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        if (this.frameBuffer == null) {
            return;
        }
        Texture texture = this.frameBuffer.getTexture();
        g.drawTexture(texture, this.renderX, this.renderY);
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
    }
}

