/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;
import org.mini2Dx.gdx.utils.Array;

public class RenderPipeline {
    private Array<RenderOperation> operations = new Array(true, 2);
    private boolean oneWay = false;

    public void update(GameContainer gc, float delta) {
        for (RenderOperation stage : this.operations) {
            stage.update(gc, delta);
        }
    }

    public void interpolate(GameContainer gc, float alpha) {
        for (RenderOperation stage : this.operations) {
            stage.interpolate(gc, alpha);
        }
    }

    public void render(GameContainer gc, Graphics g) {
        for (RenderOperation stage : this.operations) {
            stage.apply(gc, g);
        }
        if (this.oneWay) {
            return;
        }
        for (int i = this.operations.size - 1; i >= 0; --i) {
            ((RenderOperation)this.operations.get(i)).unapply(gc, g);
        }
    }

    public void add(RenderOperation operation) {
        this.operations.add((Object)operation);
    }

    public void remove(RenderOperation operation) {
        this.operations.removeValue((Object)operation, true);
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }
}

