/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;
import org.mini2Dx.gdx.math.Vector2;

public abstract class ScaleOperation
implements RenderOperation {
    private final Vector2 scale = new Vector2();
    private float scaleX;
    private float scaleY;
    private float unscaleX;
    private float unscaleY;

    public abstract void updateScale(Vector2 var1, GameContainer var2, float var3);

    @Override
    public void update(GameContainer gc, float delta) {
        this.updateScale(this.scale, gc, delta);
        this.scaleX = this.scale.x;
        this.scaleY = this.scale.y;
        this.unscaleX = 1.0f / this.scaleX;
        this.unscaleY = 1.0f / this.scaleY;
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        g.scale(this.scaleX, this.scaleY);
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
        g.scale(this.unscaleX, this.unscaleY);
    }
}

