/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Shader;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;

public class ShaderOperation
implements RenderOperation {
    private static final String LOGGING_TAG = ShaderOperation.class.getSimpleName();
    protected final Shader shader;
    private Shader previousShader;

    public ShaderOperation(String shaderPath) {
        this(Mdx.graphics.newShader(shaderPath));
    }

    public ShaderOperation(Shader shader) {
        this.shader = shader;
        if (!shader.isCompiled()) {
            Mdx.log.error(LOGGING_TAG, shader.getLog());
        }
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        this.previousShader = g.getShader();
        g.setShader(this.shader);
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
        g.setShader(this.previousShader);
    }
}

