/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.viewport;

import org.mini2Dx.core.graphics.viewport.Viewport;
import org.mini2Dx.core.util.Scaling;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;

public class ExtendViewport
extends Viewport {
    private float minWorldWidth;
    private float minWorldHeight;
    private float maxWorldWidth;
    private float maxWorldHeight;
    private boolean powerOfTwo = false;
    private final Vector2 size = new Vector2();
    private final Vector2 scale = new Vector2();

    public ExtendViewport(float minWorldWidth, float minWorldHeight) {
        this(minWorldWidth, minWorldHeight, 0.0f, 0.0f);
    }

    public ExtendViewport(float minWorldWidth, float minWorldHeight, float maxWorldWidth, float maxWorldHeight) {
        this(false, minWorldWidth, minWorldHeight, maxWorldWidth, maxWorldHeight);
    }

    public ExtendViewport(boolean powerOfTwo, float minWorldWidth, float minWorldHeight) {
        this(powerOfTwo, minWorldWidth, minWorldHeight, 0.0f, 0.0f);
    }

    public ExtendViewport(boolean powerOfTwo, float minWorldWidth, float minWorldHeight, float maxWorldWidth, float maxWorldHeight) {
        this.powerOfTwo = powerOfTwo;
        this.minWorldWidth = minWorldWidth;
        this.minWorldHeight = minWorldHeight;
        this.maxWorldWidth = maxWorldWidth;
        this.maxWorldHeight = maxWorldHeight;
    }

    @Override
    public void onResize(int width, int height) {
        float lengthen;
        float toWorldSpace;
        float toViewportSpace;
        float worldWidth = this.minWorldWidth;
        float worldHeight = this.minWorldHeight;
        Scaling.FIT.apply(this.size, this.scale, this.powerOfTwo, worldWidth, worldHeight, width, height);
        int viewportWidth = Math.round(this.size.x);
        int viewportHeight = Math.round(this.size.y);
        if (viewportWidth < width) {
            toViewportSpace = (float)viewportHeight / worldHeight;
            toWorldSpace = worldHeight / (float)viewportHeight;
            lengthen = (float)(width - viewportWidth) * toWorldSpace;
            if (this.maxWorldWidth > 0.0f) {
                lengthen = Math.min(lengthen, this.maxWorldWidth - this.minWorldWidth);
            }
            worldWidth += lengthen;
            viewportWidth += Math.round(lengthen * toViewportSpace);
        }
        if (viewportHeight < height) {
            toViewportSpace = (float)viewportWidth / worldWidth;
            toWorldSpace = worldWidth / (float)viewportWidth;
            lengthen = (float)(height - viewportHeight) * toWorldSpace;
            if (this.maxWorldHeight > 0.0f) {
                lengthen = Math.min(lengthen, this.maxWorldHeight - this.minWorldHeight);
            }
            worldHeight += lengthen;
            viewportHeight += Math.round(lengthen * toViewportSpace);
        }
        this.setBounds((width - viewportWidth) / MathUtils.round((float)(2.0f * this.scale.x)), (height - viewportHeight) / MathUtils.round((float)(2.0f * this.scale.y)), MathUtils.round((float)worldWidth), MathUtils.round((float)worldHeight), this.scale.x, this.scale.y);
    }

    public float getMinWorldWidth() {
        return this.minWorldWidth;
    }

    public void setMinWorldWidth(float minWorldWidth) {
        this.minWorldWidth = minWorldWidth;
    }

    public float getMinWorldHeight() {
        return this.minWorldHeight;
    }

    public void setMinWorldHeight(float minWorldHeight) {
        this.minWorldHeight = minWorldHeight;
    }

    public float getMaxWorldWidth() {
        return this.maxWorldWidth;
    }

    public void setMaxWorldWidth(float maxWorldWidth) {
        this.maxWorldWidth = maxWorldWidth;
    }

    public float getMaxWorldHeight() {
        return this.maxWorldHeight;
    }

    public void setMaxWorldHeight(float maxWorldHeight) {
        this.maxWorldHeight = maxWorldHeight;
    }

    public boolean isPowerOfTwo() {
        return this.powerOfTwo;
    }

    public void setPowerOfTwo(boolean powerOfTwo) {
        this.powerOfTwo = powerOfTwo;
    }
}

