/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.input.button;

import org.mini2Dx.core.input.button.GamePadButton;

public enum XboxButton implements GamePadButton
{
    UP("xbox-up"),
    DOWN("xbox-down"),
    LEFT("xbox-left"),
    RIGHT("xbox-right"),
    START("xbox-start"),
    BACK("xbox-back"),
    GUIDE("xbox-guide"),
    LEFT_STICK("xbox-left-stick"),
    RIGHT_STICK("xbox-right-stick"),
    LEFT_SHOULDER("xbox-left-shoulder"),
    RIGHT_SHOULDER("xbox-right-shoulder"),
    LEFT_TRIGGER("xbox-left-trigger"),
    RIGHT_TRIGGER("xbox-right-trigger"),
    A("xbox-a"),
    B("xbox-b"),
    X("xbox-x"),
    Y("xbox-y");

    private final String internalName;

    private XboxButton(String internalName) {
        this.internalName = internalName;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public boolean equals(GamePadButton gamePadButton) {
        return this.internalName.equals(gamePadButton.getInternalName());
    }

    public static XboxButton fromInternalName(String value) {
        for (XboxButton button : XboxButton.values()) {
            if (!button.getInternalName().equals(value)) continue;
            return button;
        }
        return null;
    }
}

