/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.input.nswitch;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.GamePadMapping;
import org.mini2Dx.core.input.button.SwitchDualJoyConButton;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.deadzone.NoopDeadZone;
import org.mini2Dx.core.input.deadzone.RadialDeadZone;
import org.mini2Dx.core.input.nswitch.SwitchDualJoyConGamePadListener;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public abstract class SwitchDualJoyConGamePad
implements GamePadMapping<SwitchDualJoyConGamePadListener>,
Disposable {
    public static final String[] ID = new String[]{"Joy-Con (Dual)".toLowerCase()};
    private final Array<SwitchDualJoyConGamePadListener> listeners = new Array(true, 2, SwitchDualJoyConGamePadListener.class);
    private final GamePad gamePad;
    private DeadZone leftStickDeadZone;
    private DeadZone rightStickDeadZone;
    private DeadZone zlDeadZone;
    private DeadZone zrDeadZone;
    private boolean zl;
    private boolean zr;

    public SwitchDualJoyConGamePad(GamePad gamePad) {
        this(gamePad, new NoopDeadZone(), new NoopDeadZone());
    }

    public SwitchDualJoyConGamePad(GamePad gamePad, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        this.gamePad = gamePad;
        this.leftStickDeadZone = leftStickDeadZone;
        this.rightStickDeadZone = rightStickDeadZone;
        this.zlDeadZone = new RadialDeadZone();
        this.zrDeadZone = new RadialDeadZone();
        gamePad.addListener(this);
    }

    public abstract boolean isButtonDown(SwitchDualJoyConButton var1);

    public abstract boolean isButtonUp(SwitchDualJoyConButton var1);

    protected boolean notifyConnected() {
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            listener.connected(this);
        }
        return false;
    }

    protected boolean notifyDisconnected() {
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            listener.disconnected(this);
        }
        return false;
    }

    protected boolean notifyButtonDown(SwitchDualJoyConButton button) {
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.buttonDown(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyButtonUp(SwitchDualJoyConButton button) {
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.buttonUp(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickXMoved(float value) {
        this.leftStickDeadZone.updateX(value);
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.leftStickXMoved(this, this.leftStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickYMoved(float value) {
        this.leftStickDeadZone.updateY(value);
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.leftStickYMoved(this, this.leftStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickXMoved(float value) {
        this.rightStickDeadZone.updateX(value);
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.rightStickXMoved(this, this.rightStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickYMoved(float value) {
        this.rightStickDeadZone.updateY(value);
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.rightStickYMoved(this, this.rightStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyZLMoved(float value) {
        this.zlDeadZone.updateY(value);
        if (this.zlDeadZone.getY() >= 0.5f && !this.zl) {
            this.notifyButtonDown(SwitchDualJoyConButton.ZL);
            this.zl = true;
        } else if (this.zlDeadZone.getY() < 0.5f && this.zl) {
            this.notifyButtonUp(SwitchDualJoyConButton.ZL);
            this.zl = false;
        }
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.zlMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyZRMoved(float value) {
        this.zrDeadZone.updateY(value);
        if (this.zrDeadZone.getY() >= 0.5f && !this.zr) {
            this.notifyButtonDown(SwitchDualJoyConButton.ZR);
            this.zr = true;
        } else if (this.zrDeadZone.getY() < 0.5f && this.zr) {
            this.notifyButtonUp(SwitchDualJoyConButton.ZR);
            this.zr = false;
        }
        for (SwitchDualJoyConGamePadListener listener : this.listeners) {
            if (!listener.zrMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(SwitchDualJoyConGamePadListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addListener(int index, SwitchDualJoyConGamePadListener listener) {
        this.listeners.insert(index, (Object)listener);
    }

    @Override
    public void removeListener(SwitchDualJoyConGamePadListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    @Override
    public void removeListener(int index) {
        this.listeners.removeIndex(index);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public int getTotalListeners() {
        return this.listeners.size;
    }

    public void dispose() {
        this.gamePad.removeListener(this);
        this.listeners.clear();
    }

    public DeadZone getLeftStickDeadZone() {
        return this.leftStickDeadZone;
    }

    public void setLeftStickDeadZone(DeadZone leftStickDeadZone) {
        if (leftStickDeadZone == null) {
            leftStickDeadZone = new NoopDeadZone();
        }
        this.leftStickDeadZone = leftStickDeadZone;
    }

    public DeadZone getRightStickDeadZone() {
        return this.rightStickDeadZone;
    }

    public void setRightStickDeadZone(DeadZone rightStickDeadZone) {
        if (rightStickDeadZone == null) {
            rightStickDeadZone = new NoopDeadZone();
        }
        this.rightStickDeadZone = rightStickDeadZone;
    }

    public DeadZone getZLDeadZone() {
        return this.zlDeadZone;
    }

    public void setZLDeadZone(DeadZone zlDeadZone) {
        if (zlDeadZone == null) {
            zlDeadZone = new NoopDeadZone();
        }
        this.zlDeadZone = zlDeadZone;
    }

    public DeadZone getZRDeadZone() {
        return this.zrDeadZone;
    }

    public void setZRDeadZone(DeadZone zrDeadZone) {
        if (zrDeadZone == null) {
            zrDeadZone = new NoopDeadZone();
        }
        this.zrDeadZone = zrDeadZone;
    }

    public boolean isConnected() {
        return this.gamePad.isConnected();
    }

    public String getInstanceId() {
        return this.gamePad.getInstanceId();
    }

    public String getModelInfo() {
        return this.gamePad.getModelInfo();
    }

    public boolean isPlayerIndicesSupported() {
        return this.gamePad.isPlayerIndicesSupported();
    }

    public int getPlayerIndex() {
        return this.gamePad.getPlayerIndex();
    }

    public void setPlayerIndex(int playerIndex) {
        this.gamePad.setPlayerIndex(playerIndex);
    }

    public boolean isVibrateSupported() {
        return this.gamePad.isVibrateSupported();
    }

    public boolean isVibrating() {
        return this.gamePad.isVibrating();
    }

    public float getVibrationStrength() {
        return this.gamePad.getVibrationStrength();
    }

    public void startVibration(float strength) {
        this.gamePad.startVibration(strength);
    }

    public void stopVibration() {
        this.gamePad.stopVibration();
    }
}

