/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.input.nswitch;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.GamePadMapping;
import org.mini2Dx.core.input.button.SwitchJoyConLButton;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.deadzone.NoopDeadZone;
import org.mini2Dx.core.input.deadzone.RadialDeadZone;
import org.mini2Dx.core.input.nswitch.SwitchJoyConLGamePadListener;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public abstract class SwitchJoyConLGamePad
implements GamePadMapping<SwitchJoyConLGamePadListener>,
Disposable {
    public static final String[] ID = new String[]{"Joy-Con (L)".toLowerCase()};
    private final Array<SwitchJoyConLGamePadListener> listeners = new Array(true, 2, SwitchJoyConLGamePadListener.class);
    private final GamePad gamePad;
    private DeadZone leftStickDeadZone;
    private DeadZone zlDeadZone;
    private boolean zl;

    public SwitchJoyConLGamePad(GamePad gamePad) {
        this(gamePad, new NoopDeadZone());
    }

    public SwitchJoyConLGamePad(GamePad gamePad, DeadZone leftStickDeadZone) {
        this.gamePad = gamePad;
        this.leftStickDeadZone = leftStickDeadZone;
        this.zlDeadZone = new RadialDeadZone();
        gamePad.addListener(this);
    }

    public abstract boolean isButtonDown(SwitchJoyConLButton var1);

    public abstract boolean isButtonUp(SwitchJoyConLButton var1);

    protected boolean notifyConnected() {
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            listener.connected(this);
        }
        return false;
    }

    protected boolean notifyDisconnected() {
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            listener.disconnected(this);
        }
        return false;
    }

    protected boolean notifyButtonDown(SwitchJoyConLButton button) {
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            if (!listener.buttonDown(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyButtonUp(SwitchJoyConLButton button) {
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            if (!listener.buttonUp(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickXMoved(float value) {
        this.leftStickDeadZone.updateX(value);
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            if (!listener.leftStickXMoved(this, this.leftStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickYMoved(float value) {
        this.leftStickDeadZone.updateY(value);
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            if (!listener.leftStickYMoved(this, this.leftStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyZLMoved(float value) {
        this.zlDeadZone.updateY(value);
        if (this.zlDeadZone.getY() >= 0.5f && !this.zl) {
            this.notifyButtonDown(SwitchJoyConLButton.ZL);
            this.zl = true;
        } else if (this.zlDeadZone.getY() < 0.5f && this.zl) {
            this.notifyButtonUp(SwitchJoyConLButton.ZL);
            this.zl = false;
        }
        for (SwitchJoyConLGamePadListener listener : this.listeners) {
            if (!listener.zlMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(SwitchJoyConLGamePadListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addListener(int index, SwitchJoyConLGamePadListener listener) {
        this.listeners.insert(index, (Object)listener);
    }

    @Override
    public void removeListener(SwitchJoyConLGamePadListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    @Override
    public void removeListener(int index) {
        this.listeners.removeIndex(index);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public int getTotalListeners() {
        return this.listeners.size;
    }

    public void dispose() {
        this.gamePad.removeListener(this);
        this.listeners.clear();
    }

    public DeadZone getLeftStickDeadZone() {
        return this.leftStickDeadZone;
    }

    public void setLeftStickDeadZone(DeadZone leftStickDeadZone) {
        if (leftStickDeadZone == null) {
            leftStickDeadZone = new NoopDeadZone();
        }
        this.leftStickDeadZone = leftStickDeadZone;
    }

    public DeadZone getZLDeadZone() {
        return this.zlDeadZone;
    }

    public void setZLDeadZone(DeadZone zlDeadZone) {
        if (zlDeadZone == null) {
            zlDeadZone = new NoopDeadZone();
        }
        this.zlDeadZone = zlDeadZone;
    }

    public boolean isConnected() {
        return this.gamePad.isConnected();
    }

    public String getInstanceId() {
        return this.gamePad.getInstanceId();
    }

    public String getModelInfo() {
        return this.gamePad.getModelInfo();
    }

    public boolean isPlayerIndicesSupported() {
        return this.gamePad.isPlayerIndicesSupported();
    }

    public int getPlayerIndex() {
        return this.gamePad.getPlayerIndex();
    }

    public void setPlayerIndex(int playerIndex) {
        this.gamePad.setPlayerIndex(playerIndex);
    }

    public boolean isVibrateSupported() {
        return this.gamePad.isVibrateSupported();
    }

    public boolean isVibrating() {
        return this.gamePad.isVibrating();
    }

    public float getVibrationStrength() {
        return this.gamePad.getVibrationStrength();
    }

    public void startVibration(float strength) {
        this.gamePad.startVibration(strength);
    }

    public void stopVibration() {
        this.gamePad.stopVibration();
    }
}

