/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.input.nswitch;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.GamePadMapping;
import org.mini2Dx.core.input.button.SwitchJoyConRButton;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.deadzone.NoopDeadZone;
import org.mini2Dx.core.input.deadzone.RadialDeadZone;
import org.mini2Dx.core.input.nswitch.SwitchJoyConRGamePadListener;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public abstract class SwitchJoyConRGamePad
implements GamePadMapping<SwitchJoyConRGamePadListener>,
Disposable {
    public static final String[] ID = new String[]{"Joy-Con (R)".toLowerCase()};
    private final Array<SwitchJoyConRGamePadListener> listeners = new Array(true, 2, SwitchJoyConRGamePadListener.class);
    private final GamePad gamePad;
    private DeadZone rightStickDeadZone;
    private DeadZone zrDeadZone;
    private boolean zr;

    public SwitchJoyConRGamePad(GamePad gamePad) {
        this(gamePad, new NoopDeadZone());
    }

    public SwitchJoyConRGamePad(GamePad gamePad, DeadZone rightStickDeadZone) {
        this.gamePad = gamePad;
        this.rightStickDeadZone = rightStickDeadZone;
        this.zrDeadZone = new RadialDeadZone();
        gamePad.addListener(this);
    }

    public abstract boolean isButtonDown(SwitchJoyConRButton var1);

    public abstract boolean isButtonUp(SwitchJoyConRButton var1);

    protected boolean notifyConnected() {
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            listener.connected(this);
        }
        return false;
    }

    protected boolean notifyDisconnected() {
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            listener.disconnected(this);
        }
        return false;
    }

    protected boolean notifyButtonDown(SwitchJoyConRButton button) {
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            if (!listener.buttonDown(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyButtonUp(SwitchJoyConRButton button) {
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            if (!listener.buttonUp(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickXMoved(float value) {
        this.rightStickDeadZone.updateX(value);
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            if (!listener.rightStickXMoved(this, this.rightStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickYMoved(float value) {
        this.rightStickDeadZone.updateY(value);
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            if (!listener.rightStickYMoved(this, this.rightStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyZRMoved(float value) {
        this.zrDeadZone.updateY(value);
        if (this.zrDeadZone.getY() >= 0.5f && !this.zr) {
            this.notifyButtonDown(SwitchJoyConRButton.ZR);
            this.zr = true;
        } else if (this.zrDeadZone.getY() < 0.5f && this.zr) {
            this.notifyButtonUp(SwitchJoyConRButton.ZR);
            this.zr = false;
        }
        for (SwitchJoyConRGamePadListener listener : this.listeners) {
            if (!listener.zrMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(SwitchJoyConRGamePadListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addListener(int index, SwitchJoyConRGamePadListener listener) {
        this.listeners.insert(index, (Object)listener);
    }

    @Override
    public void removeListener(SwitchJoyConRGamePadListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    @Override
    public void removeListener(int index) {
        this.listeners.removeIndex(index);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public int getTotalListeners() {
        return this.listeners.size;
    }

    public void dispose() {
        this.gamePad.removeListener(this);
        this.listeners.clear();
    }

    public DeadZone getRightStickDeadZone() {
        return this.rightStickDeadZone;
    }

    public void setRightStickDeadZone(DeadZone rightStickDeadZone) {
        if (rightStickDeadZone == null) {
            rightStickDeadZone = new NoopDeadZone();
        }
        this.rightStickDeadZone = rightStickDeadZone;
    }

    public DeadZone getZRDeadZone() {
        return this.zrDeadZone;
    }

    public void setZRDeadZone(DeadZone zrDeadZone) {
        if (zrDeadZone == null) {
            zrDeadZone = new NoopDeadZone();
        }
        this.zrDeadZone = zrDeadZone;
    }

    public boolean isConnected() {
        return this.gamePad.isConnected();
    }

    public String getInstanceId() {
        return this.gamePad.getInstanceId();
    }

    public String getModelInfo() {
        return this.gamePad.getModelInfo();
    }

    public boolean isPlayerIndicesSupported() {
        return this.gamePad.isPlayerIndicesSupported();
    }

    public int getPlayerIndex() {
        return this.gamePad.getPlayerIndex();
    }

    public void setPlayerIndex(int playerIndex) {
        this.gamePad.setPlayerIndex(playerIndex);
    }

    public boolean isVibrateSupported() {
        return this.gamePad.isVibrateSupported();
    }

    public boolean isVibrating() {
        return this.gamePad.isVibrating();
    }

    public float getVibrationStrength() {
        return this.gamePad.getVibrationStrength();
    }

    public void startVibration(float strength) {
        this.gamePad.startVibration(strength);
    }

    public void stopVibration() {
        this.gamePad.stopVibration();
    }
}

