/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.input.ps4;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.GamePadMapping;
import org.mini2Dx.core.input.button.PS4Button;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.deadzone.NoopDeadZone;
import org.mini2Dx.core.input.deadzone.RadialDeadZone;
import org.mini2Dx.core.input.ps4.PS4GamePadListener;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public abstract class PS4GamePad
implements GamePadMapping<PS4GamePadListener>,
Disposable {
    public static final String[] ID = new String[]{"Sony DualShock 4".toLowerCase(), "PS4".toLowerCase()};
    protected final Array<PS4GamePadListener> listeners = new Array(true, 2, PS4GamePadListener.class);
    protected final GamePad gamePad;
    protected DeadZone leftStickDeadZone;
    protected DeadZone rightStickDeadZone;
    protected DeadZone l2DeadZone;
    protected DeadZone r2DeadZone;
    protected boolean l2;
    protected boolean r2;

    public PS4GamePad(GamePad gamePad) {
        this(gamePad, new NoopDeadZone(), new NoopDeadZone());
    }

    public PS4GamePad(GamePad gamePad, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        this.gamePad = gamePad;
        this.leftStickDeadZone = leftStickDeadZone;
        this.rightStickDeadZone = rightStickDeadZone;
        this.l2DeadZone = new RadialDeadZone();
        this.r2DeadZone = new RadialDeadZone();
        gamePad.addListener(this);
    }

    public abstract boolean isButtonDown(PS4Button var1);

    public abstract boolean isButtonUp(PS4Button var1);

    protected boolean notifyConnected() {
        for (PS4GamePadListener listener : this.listeners) {
            listener.connected(this);
        }
        return false;
    }

    protected boolean notifyDisconnected() {
        for (PS4GamePadListener listener : this.listeners) {
            listener.disconnected(this);
        }
        return false;
    }

    protected boolean notifyButtonDown(PS4Button button) {
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.buttonDown(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyButtonUp(PS4Button button) {
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.buttonUp(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickXMoved(float value) {
        this.leftStickDeadZone.updateX(value);
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.leftStickXMoved(this, this.leftStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickYMoved(float value) {
        this.leftStickDeadZone.updateY(value);
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.leftStickYMoved(this, this.leftStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickXMoved(float value) {
        this.rightStickDeadZone.updateX(value);
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.rightStickXMoved(this, this.rightStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickYMoved(float value) {
        this.rightStickDeadZone.updateY(value);
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.rightStickYMoved(this, this.rightStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyL2Moved(float value) {
        this.l2DeadZone.updateY(value);
        if (this.l2DeadZone.getY() >= 0.5f && !this.l2) {
            this.notifyButtonDown(PS4Button.L2);
            this.l2 = true;
        } else if (this.l2DeadZone.getY() < 0.5f && this.l2) {
            this.notifyButtonUp(PS4Button.L2);
            this.l2 = false;
        }
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.l2Moved(this, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyR2Moved(float value) {
        this.r2DeadZone.updateY(value);
        if (this.r2DeadZone.getY() >= 0.5f && !this.r2) {
            this.notifyButtonDown(PS4Button.R2);
            this.r2 = true;
        } else if (this.r2DeadZone.getY() < 0.5f && this.r2) {
            this.notifyButtonUp(PS4Button.R2);
            this.r2 = false;
        }
        for (PS4GamePadListener listener : this.listeners) {
            if (!listener.r2Moved(this, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(PS4GamePadListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addListener(int index, PS4GamePadListener listener) {
        this.listeners.insert(index, (Object)listener);
    }

    @Override
    public void removeListener(PS4GamePadListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    @Override
    public void removeListener(int index) {
        this.listeners.removeIndex(index);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public int getTotalListeners() {
        return this.listeners.size;
    }

    public void dispose() {
        this.gamePad.removeListener(this);
        this.listeners.clear();
    }

    public DeadZone getLeftStickDeadZone() {
        return this.leftStickDeadZone;
    }

    public void setLeftStickDeadZone(DeadZone leftStickDeadZone) {
        if (leftStickDeadZone == null) {
            leftStickDeadZone = new NoopDeadZone();
        }
        this.leftStickDeadZone = leftStickDeadZone;
    }

    public DeadZone getRightStickDeadZone() {
        return this.rightStickDeadZone;
    }

    public void setRightStickDeadZone(DeadZone rightStickDeadZone) {
        if (rightStickDeadZone == null) {
            rightStickDeadZone = new NoopDeadZone();
        }
        this.rightStickDeadZone = rightStickDeadZone;
    }

    public DeadZone getL2DeadZone() {
        return this.l2DeadZone;
    }

    public void setL2DeadZone(DeadZone l2DeadZone) {
        if (l2DeadZone == null) {
            l2DeadZone = new NoopDeadZone();
        }
        this.l2DeadZone = l2DeadZone;
    }

    public DeadZone getR2DeadZone() {
        return this.r2DeadZone;
    }

    public void setR2DeadZone(DeadZone r2DeadZone) {
        if (r2DeadZone == null) {
            r2DeadZone = new NoopDeadZone();
        }
        this.r2DeadZone = r2DeadZone;
    }

    public boolean isConnected() {
        return this.gamePad.isConnected();
    }

    public String getInstanceId() {
        return this.gamePad.getInstanceId();
    }

    public String getModelInfo() {
        return this.gamePad.getModelInfo();
    }

    public boolean isPlayerIndicesSupported() {
        return this.gamePad.isPlayerIndicesSupported();
    }

    public int getPlayerIndex() {
        return this.gamePad.getPlayerIndex();
    }

    public void setPlayerIndex(int playerIndex) {
        this.gamePad.setPlayerIndex(playerIndex);
    }

    public boolean isVibrateSupported() {
        return this.gamePad.isVibrateSupported();
    }

    public boolean isVibrating() {
        return this.gamePad.isVibrating();
    }

    public float getVibrationStrength() {
        return this.gamePad.getVibrationStrength();
    }

    public void startVibration(float strength) {
        this.gamePad.startVibration(strength);
    }

    public void stopVibration() {
        this.gamePad.stopVibration();
    }
}

