/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.input.xbox;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.GamePadMapping;
import org.mini2Dx.core.input.button.XboxButton;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.deadzone.NoopDeadZone;
import org.mini2Dx.core.input.deadzone.RadialDeadZone;
import org.mini2Dx.core.input.xbox.XboxGamePadListener;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public abstract class XboxGamePad
implements GamePadMapping<XboxGamePadListener>,
Disposable {
    public static final String[] ID = new String[]{"360".toLowerCase(), "Xbox".toLowerCase(), "X-Box".toLowerCase(), "X360".toLowerCase(), "XInput".toLowerCase(), "PC Wired GamePad".toLowerCase()};
    protected final Array<XboxGamePadListener> listeners = new Array(true, 2, XboxGamePadListener.class);
    protected final GamePad gamePad;
    protected DeadZone leftStickDeadZone;
    protected DeadZone rightStickDeadZone;
    protected DeadZone leftTriggerDeadZone;
    protected DeadZone rightTriggerDeadZone;
    protected boolean leftTrigger;
    protected boolean rightTrigger;

    public XboxGamePad(GamePad gamePad) {
        this(gamePad, new NoopDeadZone(), new NoopDeadZone());
    }

    public XboxGamePad(GamePad gamePad, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        this.gamePad = gamePad;
        this.leftStickDeadZone = leftStickDeadZone;
        this.rightStickDeadZone = rightStickDeadZone;
        this.leftTriggerDeadZone = new RadialDeadZone();
        this.rightTriggerDeadZone = new RadialDeadZone();
        gamePad.addListener(this);
    }

    public abstract boolean isButtonDown(XboxButton var1);

    public abstract boolean isButtonUp(XboxButton var1);

    protected boolean notifyConnected() {
        for (XboxGamePadListener listener : this.listeners) {
            listener.connected(this);
        }
        return false;
    }

    protected boolean notifyDisconnected() {
        for (XboxGamePadListener listener : this.listeners) {
            listener.disconnected(this);
        }
        return false;
    }

    protected boolean notifyButtonDown(XboxButton button) {
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.buttonDown(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyButtonUp(XboxButton button) {
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.buttonUp(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftTriggerMoved(float value) {
        this.leftTriggerDeadZone.updateY(value);
        if (this.leftTriggerDeadZone.getY() >= 0.5f && !this.leftTrigger) {
            this.notifyButtonDown(XboxButton.LEFT_TRIGGER);
            this.leftTrigger = true;
        } else if (this.leftTriggerDeadZone.getY() < 0.5f && this.leftTrigger) {
            this.notifyButtonUp(XboxButton.LEFT_TRIGGER);
            this.leftTrigger = false;
        }
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.leftTriggerMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightTriggerMoved(float value) {
        this.rightTriggerDeadZone.updateY(value);
        if (this.rightTriggerDeadZone.getY() >= 0.5f && !this.rightTrigger) {
            this.notifyButtonDown(XboxButton.RIGHT_TRIGGER);
            this.rightTrigger = true;
        } else if (this.rightTriggerDeadZone.getY() < 0.5f && this.rightTrigger) {
            this.notifyButtonUp(XboxButton.RIGHT_TRIGGER);
            this.rightTrigger = false;
        }
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.rightTriggerMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickXMoved(float value) {
        this.leftStickDeadZone.updateX(value);
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.leftStickXMoved(this, this.leftStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickYMoved(float value) {
        this.leftStickDeadZone.updateY(value);
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.leftStickYMoved(this, this.leftStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickXMoved(float value) {
        this.rightStickDeadZone.updateX(value);
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.rightStickXMoved(this, this.rightStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickYMoved(float value) {
        this.rightStickDeadZone.updateY(value);
        for (XboxGamePadListener listener : this.listeners) {
            if (!listener.rightStickYMoved(this, this.rightStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(XboxGamePadListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addListener(int index, XboxGamePadListener listener) {
        this.listeners.insert(index, (Object)listener);
    }

    @Override
    public void removeListener(int index) {
        this.listeners.removeIndex(index);
    }

    @Override
    public void removeListener(XboxGamePadListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public int getTotalListeners() {
        return this.listeners.size;
    }

    public void dispose() {
        this.gamePad.removeListener(this);
        this.listeners.clear();
    }

    public DeadZone getLeftStickDeadZone() {
        return this.leftStickDeadZone;
    }

    public void setLeftStickDeadZone(DeadZone leftStickDeadZone) {
        this.leftStickDeadZone = leftStickDeadZone;
    }

    public DeadZone getRightStickDeadZone() {
        return this.rightStickDeadZone;
    }

    public void setRightStickDeadZone(DeadZone rightStickDeadZone) {
        this.rightStickDeadZone = rightStickDeadZone;
    }

    public DeadZone getLeftTriggerDeadZone() {
        return this.leftTriggerDeadZone;
    }

    public void setLeftTriggerDeadZone(DeadZone leftTriggerDeadZone) {
        if (leftTriggerDeadZone == null) {
            leftTriggerDeadZone = new NoopDeadZone();
        }
        this.leftTriggerDeadZone = leftTriggerDeadZone;
    }

    public DeadZone getRightTriggerDeadZone() {
        return this.rightTriggerDeadZone;
    }

    public void setRightTriggerDeadZone(DeadZone rightTriggerDeadZone) {
        if (rightTriggerDeadZone == null) {
            rightTriggerDeadZone = new NoopDeadZone();
        }
        this.rightTriggerDeadZone = rightTriggerDeadZone;
    }

    public boolean isConnected() {
        return this.gamePad.isConnected();
    }

    public String getInstanceId() {
        return this.gamePad.getInstanceId();
    }

    public String getModelInfo() {
        return this.gamePad.getModelInfo();
    }

    public boolean isPlayerIndicesSupported() {
        return this.gamePad.isPlayerIndicesSupported();
    }

    public int getPlayerIndex() {
        return this.gamePad.getPlayerIndex();
    }

    public void setPlayerIndex(int playerIndex) {
        this.gamePad.setPlayerIndex(playerIndex);
    }

    public boolean isVibrateSupported() {
        return this.gamePad.isVibrateSupported();
    }

    public boolean isVibrating() {
        return this.gamePad.isVibrating();
    }

    public float getVibrationStrength() {
        return this.gamePad.getVibrationStrength();
    }

    public void startVibration(float strength) {
        this.gamePad.startVibration(strength);
    }

    public void stopVibration() {
        this.gamePad.stopVibration();
    }
}

