/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.reflect.jvm;

import java.lang.reflect.InvocationTargetException;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Constructor;
import org.mini2Dx.core.reflect.jvm.JvmAnnotation;

public class JvmConstructor
implements Constructor {
    public final java.lang.reflect.Constructor constructor;
    private Class[] parameterTypes = null;
    private Annotation[][] parameterAnnotations = null;

    public JvmConstructor(java.lang.reflect.Constructor constructor) {
        try {
            constructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.constructor = constructor;
    }

    @Override
    public Class getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public Class[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.constructor.getParameterTypes();
        }
        return this.parameterTypes;
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            java.lang.annotation.Annotation[][] annotations = this.constructor.getParameterAnnotations();
            Annotation[][] result = new Annotation[annotations.length][];
            for (int i = 0; i < annotations.length; ++i) {
                result[i] = new Annotation[annotations[i].length];
                for (int j = 0; j < annotations[i].length; ++j) {
                    result[i][j] = new JvmAnnotation(annotations[i][j]);
                }
            }
            this.parameterAnnotations = result;
        }
        return this.parameterAnnotations;
    }

    @Override
    public Object newInstance(Object ... args) throws ReflectionException {
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }
}

