/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.reflect.jvm;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.reflect.jvm.JvmAnnotation;

public class JvmField
implements Field {
    public final java.lang.reflect.Field field;

    public JvmField(java.lang.reflect.Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Object get(Object instance) throws ReflectionException {
        try {
            return this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    @Override
    public void set(Object instance, Object value) throws ReflectionException {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotation) {
        return this.field.isAnnotationPresent(annotation);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        java.lang.annotation.Annotation[] annotations = this.field.getDeclaredAnnotations();
        Annotation[] result = new Annotation[annotations.length];
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                result[i] = new JvmAnnotation(annotations[i]);
            }
        }
        return result;
    }

    @Override
    public Annotation getDeclaredAnnotation(Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations = this.field.getDeclaredAnnotations();
        if (annotations == null) {
            return null;
        }
        for (java.lang.annotation.Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return new JvmAnnotation(annotation);
        }
        return null;
    }

    @Override
    public Class getType() {
        return this.field.getType();
    }

    @Override
    public Class getElementType(int index) {
        Type[] actualTypes;
        Type genericType = this.field.getGenericType();
        if (genericType instanceof ParameterizedType && (actualTypes = ((ParameterizedType)genericType).getActualTypeArguments()).length - 1 >= index) {
            Type componentType;
            Type actualType = actualTypes[index];
            if (actualType instanceof Class) {
                return (Class)actualType;
            }
            if (actualType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)actualType).getRawType();
            }
            if (actualType instanceof GenericArrayType && (componentType = ((GenericArrayType)actualType).getGenericComponentType()) instanceof Class) {
                return Mdx.reflect.newArray((Class)componentType, 0).getClass();
            }
        }
        return null;
    }

    @Override
    public int getTotalElementTypes() {
        Type genericType = this.field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            return actualTypes.length;
        }
        return 0;
    }

    @Override
    public boolean isDefaultAccess() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.field.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.field.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return this.field.isSynthetic();
    }
}

