/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.reflect.jvm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.mini2Dx.core.collections.concurrent.ConcurrentObjectSet;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.reflect.jvm.JvmAnnotation;
import org.mini2Dx.gdx.utils.ObjectSet;

public class JvmMethod
implements Method {
    private final java.lang.reflect.Method method;
    private final ObjectSet<Class> annotationsPresent = new ConcurrentObjectSet<Class>(4);
    private final ObjectSet<Class> annotationsNotPresent = new ConcurrentObjectSet<Class>(4);
    private Class[] parameterTypes = null;
    private Class returnType = null;
    private Annotation[] declaredAnnotations = null;

    public JvmMethod(java.lang.reflect.Method method) {
        try {
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.method = method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Object invoke(Object obj, Object ... args) throws ReflectionException {
        try {
            return this.method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotation) {
        if (this.annotationsPresent.contains(annotation)) {
            return true;
        }
        if (this.annotationsNotPresent.contains(annotation)) {
            return false;
        }
        boolean present = this.method.isAnnotationPresent(annotation);
        if (present) {
            this.annotationsPresent.add(annotation);
        } else {
            this.annotationsNotPresent.add(annotation);
        }
        return present;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        if (this.declaredAnnotations == null) {
            java.lang.annotation.Annotation[] annotations = this.method.getDeclaredAnnotations();
            Annotation[] result = new Annotation[annotations.length];
            if (annotations != null) {
                for (int i = 0; i < annotations.length; ++i) {
                    result[i] = new JvmAnnotation(annotations[i]);
                }
            }
            this.declaredAnnotations = result;
        }
        return this.declaredAnnotations;
    }

    @Override
    public Annotation getDeclaredAnnotation(Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations = this.method.getDeclaredAnnotations();
        if (annotations == null) {
            return null;
        }
        for (java.lang.annotation.Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return new JvmAnnotation(annotation);
        }
        return null;
    }

    @Override
    public Class getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.method.getReturnType();
        }
        return this.returnType;
    }

    @Override
    public Class[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.method.getParameterTypes();
        }
        return this.parameterTypes;
    }

    @Override
    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.method.getModifiers());
    }

    @Override
    public boolean isDefaultAccess() {
        if (this.isPrivate()) {
            return false;
        }
        if (this.isProtected()) {
            return false;
        }
        return !this.isPublic();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.method.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.method.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public boolean isNative() {
        return Modifier.isNative(this.method.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }
}

