/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.reflect.jvm;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import org.mini2Dx.core.Reflection;
import org.mini2Dx.core.collections.concurrent.ConcurrentObjectMap;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Constructor;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.reflect.jvm.JvmAnnotation;
import org.mini2Dx.core.reflect.jvm.JvmConstructor;
import org.mini2Dx.core.reflect.jvm.JvmField;
import org.mini2Dx.core.reflect.jvm.JvmMethod;
import org.mini2Dx.gdx.utils.ObjectMap;

public class JvmReflection
implements Reflection {
    private final ObjectMap<Class, Constructor[]> constructorsCache = new ConcurrentObjectMap<Class, Constructor[]>();
    private final ObjectMap<Class, Constructor[]> declaredConstructorsCache = new ConcurrentObjectMap<Class, Constructor[]>();
    private final ObjectMap<Class, Method[]> methodsCache = new ConcurrentObjectMap<Class, Method[]>();
    private final ObjectMap<Class, Method[]> declaredMethodsCache = new ConcurrentObjectMap<Class, Method[]>();
    private final ObjectMap<Class, Field[]> fieldsCache = new ConcurrentObjectMap<Class, Field[]>();
    private final ObjectMap<Class, Field[]> declaredFieldsCache = new ConcurrentObjectMap<Class, Field[]>();
    private final ObjectMap<String, Field> fieldCache = new ConcurrentObjectMap<String, Field>();
    private final ObjectMap<String, Field> declaredFieldCache = new ConcurrentObjectMap<String, Field>();

    @Override
    public Class forName(String qualifiedName) throws ReflectionException {
        try {
            return Class.forName(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    @Override
    public Object newInstance(Class clazz) throws ReflectionException {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isInstanceOf(Class clazz, Object obj) {
        return clazz.isInstance(obj);
    }

    @Override
    public boolean isAssignableFrom(Class class1, Class class2) {
        return class1.isAssignableFrom(class2);
    }

    @Override
    public boolean isAnnotationPresent(Class clazz, Class<? extends java.lang.annotation.Annotation> annotationType) {
        return clazz.isAnnotationPresent(annotationType);
    }

    @Override
    public Annotation[] getAnnotations(Class clazz) {
        return this.convert(clazz.getAnnotations());
    }

    @Override
    public Annotation getAnnotation(Class clazz, Class<? extends java.lang.annotation.Annotation> annotationType) {
        return new JvmAnnotation(clazz.getAnnotation(annotationType));
    }

    @Override
    public Annotation[] getDeclaredAnnotations(Class clazz) {
        return this.convert(clazz.getDeclaredAnnotations());
    }

    @Override
    public Annotation getDeclaredAnnotation(Class clazz, Class<? extends java.lang.annotation.Annotation> annotationType) {
        return new JvmAnnotation(clazz.getDeclaredAnnotation(annotationType));
    }

    @Override
    public Constructor[] getConstructors(Class clazz) {
        if (!this.constructorsCache.containsKey((Object)clazz)) {
            this.constructorsCache.put((Object)clazz, (Object)this.convert(clazz.getConstructors()));
        }
        return (Constructor[])this.constructorsCache.get((Object)clazz);
    }

    @Override
    public Constructor[] getDeclaredConstructors(Class clazz) {
        if (!this.declaredConstructorsCache.containsKey((Object)clazz)) {
            this.declaredConstructorsCache.put((Object)clazz, (Object)this.convert(clazz.getDeclaredConstructors()));
        }
        return (Constructor[])this.declaredConstructorsCache.get((Object)clazz);
    }

    @Override
    public Method[] getMethods(Class clazz) {
        if (!this.methodsCache.containsKey((Object)clazz)) {
            this.methodsCache.put((Object)clazz, (Object)this.convert(clazz.getMethods()));
        }
        return (Method[])this.methodsCache.get((Object)clazz);
    }

    @Override
    public Method[] getDeclaredMethods(Class clazz) {
        if (!this.declaredMethodsCache.containsKey((Object)clazz)) {
            this.declaredMethodsCache.put((Object)clazz, (Object)this.convert(clazz.getDeclaredMethods()));
        }
        return (Method[])this.declaredMethodsCache.get((Object)clazz);
    }

    @Override
    public Field[] getFields(Class clazz) {
        if (!this.fieldsCache.containsKey((Object)clazz)) {
            this.fieldsCache.put((Object)clazz, (Object)this.convert(clazz.getFields()));
        }
        return (Field[])this.fieldsCache.get((Object)clazz);
    }

    @Override
    public Field[] getDeclaredFields(Class clazz) {
        if (!this.declaredFieldsCache.containsKey((Object)clazz)) {
            this.declaredFieldsCache.put((Object)clazz, (Object)this.convert(clazz.getDeclaredFields()));
        }
        return (Field[])this.declaredFieldsCache.get((Object)clazz);
    }

    @Override
    public Field getField(Class clazz, String fieldName) throws ReflectionException {
        String key = clazz.getName() + "->" + fieldName;
        if (!this.fieldCache.containsKey((Object)key)) {
            try {
                this.fieldCache.put((Object)key, (Object)new JvmField(clazz.getField(fieldName)));
            }
            catch (NoSuchFieldException e) {
                throw new ReflectionException(e.getMessage(), e);
            }
        }
        return (Field)this.fieldCache.get((Object)key);
    }

    @Override
    public Field getDeclaredField(Class clazz, String fieldName) throws ReflectionException {
        String key = clazz.getName() + "->" + fieldName;
        if (!this.declaredFieldCache.containsKey((Object)key)) {
            try {
                this.declaredFieldCache.put((Object)key, (Object)new JvmField(clazz.getDeclaredField(fieldName)));
            }
            catch (NoSuchFieldException e) {
                throw new ReflectionException(e.getMessage(), e);
            }
        }
        return (Field)this.declaredFieldCache.get((Object)key);
    }

    @Override
    public boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    @Override
    public boolean isInterface(Class clazz) {
        return clazz.isInterface();
    }

    @Override
    public boolean isEnum(Class clazz) {
        return clazz.isEnum();
    }

    @Override
    public boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive();
    }

    @Override
    public boolean isAnnotation(Class clazz) {
        return clazz.isAnnotation();
    }

    @Override
    public boolean isArray(Class clazz) {
        return clazz.isArray();
    }

    @Override
    public Class arrayComponentType(Class clazz) {
        return clazz.getComponentType();
    }

    @Override
    public Object arrayGet(Object array, int index) {
        return Array.get(array, index);
    }

    @Override
    public void arraySet(Object array, int index, Object value) {
        Array.set(array, index, value);
    }

    @Override
    public int arrayLength(Object array) {
        return Array.getLength(array);
    }

    @Override
    public Object newArray(Class clazz, int size) {
        return Array.newInstance(clazz, size);
    }

    private Constructor[] convert(java.lang.reflect.Constructor[] constructors) {
        Constructor[] result = new Constructor[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new JvmConstructor(constructors[i]);
        }
        return result;
    }

    private Method[] convert(java.lang.reflect.Method[] methods) {
        Method[] result = new Method[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new JvmMethod(methods[i]);
        }
        return result;
    }

    private Field[] convert(java.lang.reflect.Field[] fields) {
        Field[] result = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new JvmField(fields[i]);
        }
        return result;
    }

    private Annotation[] convert(java.lang.annotation.Annotation[] annotations) {
        Annotation[] result = new Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = new JvmAnnotation(annotations[i]);
        }
        return result;
    }
}

