/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.screen.transition;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Colors;
import org.mini2Dx.core.screen.GameScreen;
import org.mini2Dx.core.screen.Transition;

public class FadeInTransition
implements Transition {
    private final Color originalColor;
    private Color color;
    private float duration;

    public FadeInTransition() {
        this(Colors.rgbToColor("1,1,1"));
    }

    public FadeInTransition(Color color) {
        this(color, 0.5f);
    }

    public FadeInTransition(Color color, float duration) {
        this.originalColor = color;
        this.duration = duration;
    }

    @Override
    public void initialise(GameScreen outScreen, GameScreen inScreen) {
        this.color = this.originalColor.copy();
        this.color.setA(1.0f);
    }

    @Override
    public void update(GameContainer gc, float delta) {
        this.color.setA(this.color.af() - delta * 1.0f / this.duration);
        if (this.color.af() < 0.0f) {
            this.color.setA(0.0f);
        }
    }

    @Override
    public void preRender(GameContainer gc, Graphics g) {
    }

    @Override
    public void postRender(GameContainer gc, Graphics g) {
        Color old = g.getColor();
        g.setColor(this.color);
        g.fillRect(0.0f, 0.0f, gc.getWidth(), gc.getHeight());
        g.setColor(old);
    }

    @Override
    public boolean isFinished() {
        return this.color.af() <= 0.0f;
    }
}

