/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.serialization.aot.AotSerializedClassData;
import org.mini2Dx.core.serialization.aot.AotSerializedFieldData;
import org.mini2Dx.gdx.utils.ObjectMap;

public class AotSerializationData {
    private static final ObjectMap<String, AotSerializedClassData> AOT_DATA = new ObjectMap();

    public static void registerClass(Class clazz) {
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz.getName().equals("java.lang.String")) {
            return;
        }
        if (AOT_DATA.containsKey((Object)clazz.getName())) {
            return;
        }
        AotSerializedClassData classData = null;
        while (clazz != null && !clazz.equals(Object.class)) {
            classData = new AotSerializedClassData(clazz);
            if (classData.getTotalFields() > 0 || classData.getTotalConstructors() > 0 || classData.getPostDeserializeMethodName() != null || classData.isNonConcrete()) {
                AOT_DATA.put((Object)clazz.getName(), (Object)classData);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static AotSerializedClassData getClassData(Class clazz) {
        return (AotSerializedClassData)AOT_DATA.get((Object)clazz.getName(), null);
    }

    public static AotSerializedFieldData getFieldData(Class clazz, String fieldName) {
        AotSerializedClassData classData;
        AotSerializedFieldData result = null;
        while (!(result != null || clazz == null || clazz.equals(Object.class) || (classData = AotSerializationData.getClassData(clazz)) != null && (result = classData.getFieldData(fieldName)) != null)) {
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static void saveTo(FileHandle fileHandle) throws IOException {
        AotSerializationData.saveTo(fileHandle.writer(false));
    }

    public static void saveTo(Writer output) throws IOException {
        PrintWriter writer = new PrintWriter(output);
        for (AotSerializedClassData data : AOT_DATA.values()) {
            data.saveTo(writer);
        }
        writer.flush();
        writer.close();
    }

    public static void restoreFrom(FileHandle fileHandle) throws IOException, ClassNotFoundException {
        AotSerializationData.restoreFrom(new InputStreamReader(new BufferedInputStream(fileHandle.read())));
    }

    public static void restoreFrom(Reader reader) throws IOException, ClassNotFoundException {
        Scanner scanner = new Scanner(reader);
        while (scanner.hasNext()) {
            AotSerializedClassData classData = new AotSerializedClassData(scanner);
            AOT_DATA.put((Object)classData.getQualifiedClassName(), (Object)classData);
        }
        scanner.close();
    }

    public static void clear() {
        AOT_DATA.clear();
    }
}

