/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GameDataSerializableUtils {
    public static void writeArray(long[] array, DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            outputStream.writeLong(array[i]);
        }
    }

    public static long[] readArray(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = inputStream.readLong();
        }
        return result;
    }

    public static void writeString(String str, DataOutputStream outputStream) throws IOException {
        outputStream.writeBoolean(str != null);
        if (str != null) {
            outputStream.writeUTF(str);
        }
    }

    public static String readString(DataInputStream inputStream) throws IOException {
        boolean exists = inputStream.readBoolean();
        if (!exists) {
            return null;
        }
        return inputStream.readUTF();
    }
}

