/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentObjectMap;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.exception.RequiredFieldException;
import org.mini2Dx.core.exception.SerializationException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Constructor;
import org.mini2Dx.core.reflect.ConstructorSorter;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.annotation.ConstructorArg;
import org.mini2Dx.core.serialization.annotation.Field;
import org.mini2Dx.core.serialization.annotation.NonConcrete;
import org.mini2Dx.core.serialization.annotation.PostDeserialize;
import org.mini2Dx.core.serialization.aot.AotSerializedClassData;
import org.mini2Dx.core.serialization.aot.AotSerializedConstructorData;
import org.mini2Dx.core.serialization.collection.DeserializedCollection;
import org.mini2Dx.core.serialization.collection.SerializedCollection;
import org.mini2Dx.core.serialization.map.deserialize.DeserializedMap;
import org.mini2Dx.core.serialization.map.serialize.SerializedMap;
import org.mini2Dx.gdx.json.JsonReader;
import org.mini2Dx.gdx.json.JsonValue;
import org.mini2Dx.gdx.json.JsonWriter;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;

public class JsonSerializer {
    private static final String LOGGING_TAG = JsonSerializer.class.getSimpleName();
    private final ObjectMap<String, Method> postDeserializeCache = new ConcurrentObjectMap<String, Method>();

    public <T> T fromJson(FileHandle fileHandle, Class<T> clazz) throws SerializationException {
        try {
            return this.deserialize(new JsonReader().parse(fileHandle.reader()), clazz);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    public <T> T fromJson(String json, Class<T> clazz) throws SerializationException {
        return this.deserialize(new JsonReader().parse(json), clazz);
    }

    public <T> void toJson(FileHandle fileHandle, T object) throws SerializationException {
        this.toJson(fileHandle, object, false);
    }

    public <T> void toJson(FileHandle fileHandle, T object, boolean prettyPrint) throws SerializationException {
        String json = this.toJson(object, prettyPrint);
        try {
            fileHandle.writeString(json, false);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    public <T> String toJson(T object) throws SerializationException {
        return this.toJson(object, false);
    }

    public <T> String toJson(T object, boolean prettyPrint) throws SerializationException {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        jsonWriter.setOutputType(JsonWriter.OutputType.json);
        this.writeObject(null, object, null, jsonWriter);
        try {
            jsonWriter.flush();
            String result = writer.toString();
            writer.flush();
            writer.close();
            if (prettyPrint) {
                return new JsonReader().parse(result).prettyPrint(JsonWriter.OutputType.json, 0);
            }
            return result;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    private <T> void writeObject(org.mini2Dx.core.reflect.Field fieldDefinition, T object, String fieldName, JsonWriter json) throws SerializationException {
        try {
            if (object == null) {
                this.writePrimitive(fieldName, null, json);
                return;
            }
            Class<?> clazz = object.getClass();
            if (this.isPrimitive(clazz) || clazz.equals(String.class)) {
                this.writePrimitive(fieldName, object, json);
                return;
            }
            if (clazz.isEnum() || clazz.getSuperclass().isEnum()) {
                this.writePrimitive(fieldName, object.toString(), json);
                return;
            }
            if (clazz.isArray()) {
                this.writeArray(fieldDefinition, object, json);
                return;
            }
            SerializedMap serializedMap = SerializedMap.getImplementation(clazz, object);
            if (serializedMap != null) {
                this.writeSerializedMap(fieldDefinition, serializedMap, json);
                return;
            }
            SerializedCollection serializedCollection = SerializedCollection.getImplementation(clazz, object);
            if (serializedCollection != null) {
                this.writeSerializedCollection(fieldDefinition, serializedCollection, json);
                return;
            }
            if (fieldName == null) {
                json.object();
            } else {
                json.object(fieldName);
            }
            this.writeClassFieldIfRequired(fieldDefinition, object, fieldName, json);
            for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                Annotation annotation;
                Method[] methods = Mdx.reflect.getDeclaredMethods(currentClass);
                org.mini2Dx.core.reflect.Field[] fields = Mdx.reflect.getDeclaredFields(currentClass);
                for (org.mini2Dx.core.reflect.Field field : fields) {
                    annotation = field.getDeclaredAnnotation(Field.class);
                    if (annotation == null) continue;
                    Field fieldAnnotation = annotation.getAnnotation(Field.class);
                    if (!fieldAnnotation.optional() && field.get(object) == null) {
                        throw new RequiredFieldException(currentClass, field.getName());
                    }
                    this.writeObject(field, field.get(object), field.getName(), json);
                }
                for (Method method : methods) {
                    if (method.getParameterTypes().length > 0 || (annotation = method.getDeclaredAnnotation(ConstructorArg.class)) == null) continue;
                    ConstructorArg constructorArg = annotation.getAnnotation(ConstructorArg.class);
                    this.writeObject(null, method.invoke(object, new Object[0]), constructorArg.name(), json);
                }
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method[] methods;
                String className = interfaces[i].getName();
                for (Method method : methods = Mdx.reflect.getDeclaredMethods(interfaces[i])) {
                    Annotation annotation;
                    if (method.getParameterTypes().length > 0 || (annotation = method.getDeclaredAnnotation(ConstructorArg.class)) == null) continue;
                    ConstructorArg constructorArg = annotation.getAnnotation(ConstructorArg.class);
                    this.writeObject(null, method.invoke(object, new Object[0]), constructorArg.name(), json);
                }
            }
            json.pop();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private <T> void writeClassFieldIfRequired(org.mini2Dx.core.reflect.Field fieldDefinition, T object, String fieldName, JsonWriter json) throws SerializationException, IOException {
        if (fieldDefinition == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        Class fieldDefinitionClass = fieldDefinition.getType();
        if (Mdx.reflect.isArray(fieldDefinitionClass)) {
            Class arrayComponentType = Mdx.reflect.arrayComponentType(fieldDefinitionClass);
            if (arrayComponentType.isInterface() && arrayComponentType.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Mdx.reflect.isAssignableFrom(Collection.class, fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(0);
            if (valueClass.isInterface() && valueClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Mdx.reflect.isAssignableFrom(Map.class, fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(1);
            if (valueClass.isInterface() && valueClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Mdx.reflect.isInterface(fieldDefinitionClass)) {
            if (fieldDefinitionClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Mdx.reflect.isAbstract(fieldDefinitionClass)) {
            if (fieldDefinitionClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize abstract class unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
    }

    private <T> void writeArray(org.mini2Dx.core.reflect.Field field, Object array, JsonWriter json) throws IOException, SerializationException {
        if (field != null) {
            json.array(field.getName());
        } else {
            json.array();
        }
        int arrayLength = Mdx.reflect.arrayLength(array);
        for (int i = 0; i < arrayLength; ++i) {
            this.writeObject(field, Mdx.reflect.arrayGet(array, i), null, json);
        }
        json.pop();
    }

    private <T> void writeSerializedCollection(org.mini2Dx.core.reflect.Field field, SerializedCollection collection, JsonWriter json) throws IOException, SerializationException {
        if (field != null) {
            json.array(field.getName());
        } else {
            json.array();
        }
        int arrayLength = collection.getLength();
        for (int i = 0; i < arrayLength; ++i) {
            this.writeObject(field, collection.get(i), null, json);
        }
        json.pop();
        collection.dispose();
    }

    private <T> void writeSerializedMap(org.mini2Dx.core.reflect.Field field, SerializedMap map, JsonWriter json) throws IOException, SerializationException {
        if (field != null) {
            json.object(field.getName());
        } else {
            json.object();
        }
        for (Object key : map.keys()) {
            this.writeObject(field, map.get(key), key.toString(), json);
        }
        json.pop();
    }

    private <T> void writePrimitive(String fieldName, Object value, JsonWriter json) throws IOException {
        if (fieldName != null) {
            json.name(fieldName);
        }
        json.value(value);
    }

    private <T> T construct(JsonValue objectRoot, Class<?> clazz) throws SerializationException, IllegalArgumentException {
        Constructor[] constructors = Mdx.reflect.getConstructors(clazz);
        ConstructorSorter.sort(constructors);
        if (constructors.length == 1 && constructors[0].getParameterAnnotations().length == 0) {
            return (T)constructors[0].newInstance(new Object[0]);
        }
        AotSerializedClassData classData = AotSerializationData.getClassData(clazz);
        if (classData != null) {
            AotSerializedConstructorData bestMatchedConstructor = null;
            for (int i = 0; i < classData.getTotalConstructors(); ++i) {
                AotSerializedConstructorData constructorData = classData.getConstructorData(i);
                boolean allMatched = true;
                for (int j = 0; j < constructorData.getTotalArgs(); ++j) {
                    String argName = constructorData.getConstructorArgName(j);
                    if (objectRoot.get(argName) != null) continue;
                    allMatched = false;
                    break;
                }
                if (!allMatched) continue;
                if (bestMatchedConstructor == null) {
                    bestMatchedConstructor = constructorData;
                    continue;
                }
                if (constructorData.getTotalArgs() <= bestMatchedConstructor.getTotalArgs()) continue;
                bestMatchedConstructor = constructorData;
            }
            if (bestMatchedConstructor == null) {
                return (T)Mdx.reflect.newInstance(clazz);
            }
            Object[] constructorParameters = new Object[bestMatchedConstructor.getTotalArgs()];
            for (int i = 0; i < bestMatchedConstructor.getTotalArgs(); ++i) {
                constructorParameters[i] = this.deserialize(objectRoot.get(bestMatchedConstructor.getConstructorArgName(i)), bestMatchedConstructor.getConstructorArgType(i));
                objectRoot.remove(bestMatchedConstructor.getConstructorArgName(i));
            }
            boolean couldNotFindConstructor = false;
            try {
                return (T)clazz.getConstructor(bestMatchedConstructor.getConstructorArgTypes()).newInstance(constructorParameters);
            }
            catch (NoSuchMethodException e) {
                couldNotFindConstructor = true;
            }
            catch (Exception e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
            try {
                return (T)clazz.getConstructor(bestMatchedConstructor.getConstructorArgTypesWithPrimitives()).newInstance(constructorParameters);
            }
            catch (NoSuchMethodException e) {
                couldNotFindConstructor = true;
            }
            catch (Exception e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
            if (couldNotFindConstructor) {
                Mdx.log.error(LOGGING_TAG, "Could not find constructor for " + clazz.getName() + ". Falling back to default constructor");
            }
            return (T)Mdx.reflect.newInstance(clazz);
        }
        Constructor bestMatchedConstructor = null;
        Array detectedAnnotations = new Array(1);
        for (int i = 0; i < constructors.length; ++i) {
            detectedAnnotations.clear();
            boolean allAnnotated = true;
            for (int j = 0; j < constructors[i].getParameterAnnotations().length; ++j) {
                Annotation[] annotations = constructors[i].getParameterAnnotations()[j];
                if (annotations.length == 0) {
                    allAnnotated = false;
                    break;
                }
                boolean hasConstructorArgAnnotation = false;
                for (int k = 0; k < annotations.length; ++k) {
                    ConstructorArg constructorArg;
                    Annotation annotation;
                    if (!annotations[k].getAnnotationType().isAssignableFrom(ConstructorArg.class) || (annotation = annotations[k]) == null || objectRoot.get((constructorArg = annotation.getAnnotation(ConstructorArg.class)).name()) == null) continue;
                    detectedAnnotations.add((Object)constructorArg);
                    hasConstructorArgAnnotation = true;
                    break;
                }
                if (hasConstructorArgAnnotation) continue;
                allAnnotated = false;
            }
            if (!allAnnotated) continue;
            if (bestMatchedConstructor == null) {
                bestMatchedConstructor = constructors[i];
                continue;
            }
            if (detectedAnnotations.size <= bestMatchedConstructor.getParameterAnnotations().length) continue;
            bestMatchedConstructor = constructors[i];
        }
        if (bestMatchedConstructor == null || detectedAnnotations.size == 0) {
            if (detectedAnnotations.size > 0) {
                Mdx.log.error(LOGGING_TAG, "Could not find suitable constructor for " + clazz.getSimpleName() + ". Falling back to default constructor.");
            }
            return (T)Mdx.reflect.newInstance(clazz);
        }
        Object[] constructorParameters = new Object[detectedAnnotations.size];
        for (int i = 0; i < detectedAnnotations.size; ++i) {
            ConstructorArg constructorArg = (ConstructorArg)detectedAnnotations.get(i);
            constructorParameters[i] = this.deserialize(objectRoot.get(constructorArg.name()), constructorArg.clazz());
            objectRoot.remove(constructorArg.name());
        }
        return (T)bestMatchedConstructor.newInstance(constructorParameters);
    }

    private Class<?> determineImplementation(JsonValue objectRoot, Class<?> clazz) throws SerializationException, ClassNotFoundException {
        if (Mdx.reflect.isInterface(clazz) || Mdx.reflect.isAbstract(clazz)) {
            JsonValue classField = objectRoot.get("class");
            if (classField == null) {
                throw new SerializationException("No class field found for deserializing " + clazz.getName());
            }
            clazz = Mdx.reflect.forName(classField.asString());
        }
        return clazz;
    }

    private <T> void callPostDeserializeMethods(T object, Class<?> clazz) throws SerializationException {
        block6: for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            String className = currentClass.getName();
            if (this.postDeserializeCache.containsKey((Object)className)) {
                try {
                    ((Method)this.postDeserializeCache.get((Object)className)).invoke(object, new Object[0]);
                    continue;
                }
                catch (ReflectionException e) {
                    throw new SerializationException(e);
                }
            }
            Method[] methods = Mdx.reflect.getDeclaredMethods(currentClass);
            AotSerializedClassData classData = AotSerializationData.getClassData(currentClass);
            if (classData != null) {
                if (classData.getPostDeserializeMethodName() == null) continue;
                for (Method method : methods) {
                    if (!method.getName().equals(classData.getPostDeserializeMethodName())) continue;
                    this.postDeserializeCache.put((Object)className, (Object)method);
                    try {
                        method.invoke(object, new Object[0]);
                        continue block6;
                    }
                    catch (ReflectionException e) {
                        throw new SerializationException(e);
                    }
                }
                continue;
            }
            for (Method method : methods) {
                if (!method.isAnnotationPresent(PostDeserialize.class)) continue;
                try {
                    method.invoke(object, new Object[0]);
                }
                catch (ReflectionException e) {
                    throw new SerializationException(e);
                }
            }
        }
    }

    private <T> T deserialize(JsonValue objectRoot, Class<T> fieldClass) throws SerializationException {
        try {
            if (objectRoot.isNull()) {
                return null;
            }
            if (objectRoot.isObject()) {
                Class<?> clazz = this.determineImplementation(objectRoot, fieldClass);
                T result = this.construct(objectRoot, clazz);
                for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                    AotSerializedClassData classData = AotSerializationData.getClassData(currentClass);
                    org.mini2Dx.core.reflect.Field[] fields = classData != null ? classData.getFieldDataAsFieldArray() : Mdx.reflect.getDeclaredFields(currentClass);
                    for (org.mini2Dx.core.reflect.Field field : fields) {
                        Annotation annotation = field.getDeclaredAnnotation(Field.class);
                        Field fieldAnnotation = null;
                        if (classData == null && (annotation == null || (fieldAnnotation = annotation.getAnnotation(Field.class)) == null)) continue;
                        JsonValue value = objectRoot.get(field.getName());
                        if (value == null || value.isNull()) {
                            if (classData != null || fieldAnnotation == null || fieldAnnotation.optional()) continue;
                            throw new RequiredFieldException(currentClass, field.getName());
                        }
                        this.setField(result, currentClass, field, value);
                    }
                }
                this.callPostDeserializeMethods(result, clazz);
                return result;
            }
            if (objectRoot.isArray()) {
                Class arrayType = Mdx.reflect.arrayComponentType(fieldClass);
                Object array = Mdx.reflect.newArray(arrayType, objectRoot.size);
                for (int i = 0; i < objectRoot.size; ++i) {
                    Mdx.reflect.arraySet(array, i, this.deserialize(objectRoot.get(i), arrayType));
                }
                return (T)array;
            }
            if (Mdx.reflect.isEnum(fieldClass)) {
                return Enum.valueOf(fieldClass, objectRoot.asString());
            }
            if (fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.class)) {
                return (T)Boolean.valueOf(objectRoot.asBoolean());
            }
            if (fieldClass.equals(Byte.TYPE) || fieldClass.equals(Byte.class)) {
                return (T)Byte.valueOf(objectRoot.asByte());
            }
            if (fieldClass.equals(Character.TYPE) || fieldClass.equals(Character.class)) {
                return (T)Character.valueOf(objectRoot.asChar());
            }
            if (fieldClass.equals(Double.TYPE) || fieldClass.equals(Double.class)) {
                return (T)Double.valueOf(objectRoot.asDouble());
            }
            if (fieldClass.equals(Float.TYPE) || fieldClass.equals(Float.class)) {
                return (T)Float.valueOf(objectRoot.asFloat());
            }
            if (fieldClass.equals(Integer.TYPE) || fieldClass.equals(Integer.class)) {
                return (T)Integer.valueOf(objectRoot.asInt());
            }
            if (fieldClass.equals(Long.TYPE) || fieldClass.equals(Long.class)) {
                return (T)Long.valueOf(objectRoot.asLong());
            }
            if (fieldClass.equals(Short.TYPE) || fieldClass.equals(Short.class)) {
                return (T)Short.valueOf(objectRoot.asShort());
            }
            return (T)objectRoot.asString();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializationException(e);
        }
    }

    private <T> void setField(T targetObject, Class<?> ownerClass, org.mini2Dx.core.reflect.Field field, JsonValue value) throws SerializationException {
        try {
            Class clazz = field.getType();
            if (Mdx.reflect.isArray(clazz)) {
                this.setArrayField(targetObject, field, clazz, value);
                return;
            }
            if (Mdx.reflect.isEnum(clazz)) {
                if (field.isFinal()) {
                    throw new SerializationException("Cannot use @Field on final enum fields. Use the @ConstructorArg method instead.");
                }
                field.set(targetObject, Enum.valueOf(clazz, value.asString()));
                return;
            }
            if (!Mdx.reflect.isPrimitive(clazz)) {
                if (clazz.equals(String.class)) {
                    if (field.isFinal()) {
                        throw new SerializationException("Cannot use @Field on final String fields. Use the @ConstructorArg method instead.");
                    }
                    field.set(targetObject, value.asString());
                } else {
                    DeserializedMap deserializedMap = DeserializedMap.getImplementation(ownerClass, field, clazz, targetObject);
                    if (deserializedMap != null) {
                        this.setSerializedMapField(deserializedMap, targetObject, field, clazz, value);
                    } else {
                        DeserializedCollection deserializedCollection = DeserializedCollection.getImplementation(ownerClass, field, clazz, targetObject);
                        if (deserializedCollection != null) {
                            this.setSerializedCollectionField(deserializedCollection, targetObject, field, clazz, value);
                        } else {
                            if (field.isFinal()) {
                                throw new SerializationException("Cannot use @Field on final " + clazz.getName() + " fields.");
                            }
                            field.set(targetObject, this.deserialize(value, clazz));
                        }
                    }
                }
                return;
            }
            if (field.isFinal()) {
                throw new SerializationException("Cannot use @Field on final " + clazz.getName() + " fields. Use the @ConstructorArg method instead.");
            }
            field.set(targetObject, this.deserialize(value, clazz));
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializationException(e);
        }
    }

    private <T> void setSerializedCollectionField(DeserializedCollection deserializedCollection, T targetObject, org.mini2Dx.core.reflect.Field field, Class<?> clazz, JsonValue value) throws SerializationException {
        try {
            Class<?> valueClass = deserializedCollection.getValueClass();
            for (int i = 0; i < value.size; ++i) {
                deserializedCollection.add(this.deserialize(value.get(i), valueClass));
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            e.getMessage();
            throw new SerializationException(e);
        }
    }

    private <T> void setArrayField(T targetObject, org.mini2Dx.core.reflect.Field field, Class<?> clazz, JsonValue value) throws SerializationException {
        try {
            if (clazz.equals(boolean[].class)) {
                boolean[] result = value.asBooleanArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(byte[].class)) {
                byte[] result = value.asByteArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(char[].class)) {
                char[] result = value.asCharArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, Character.valueOf(result[i]));
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(double[].class)) {
                double[] result = value.asDoubleArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(float[].class)) {
                float[] result = value.asFloatArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, Float.valueOf(result[i]));
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(int[].class)) {
                int[] result = value.asIntArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(long[].class)) {
                long[] result = value.asLongArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(short[].class)) {
                short[] result = value.asShortArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else if (clazz.equals(String[].class)) {
                String[] result = value.asStringArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, result[i]);
                    }
                } else {
                    field.set(targetObject, result);
                }
            } else {
                Object result = this.deserialize(value, clazz);
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    int length = Mdx.reflect.arrayLength(result);
                    for (int i = 0; i < length; ++i) {
                        Mdx.reflect.arraySet(targetArray, i, Mdx.reflect.arrayGet(result, i));
                    }
                } else {
                    field.set(targetObject, result);
                }
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private <T> void setSerializedMapField(DeserializedMap deserializedMap, T targetObject, org.mini2Dx.core.reflect.Field field, Class<?> clazz, JsonValue value) throws SerializationException {
        try {
            Class<?> keyClass = deserializedMap.getKeyClass();
            Class<?> valueClass = deserializedMap.getValueClass();
            for (int i = 0; i < value.size; ++i) {
                deserializedMap.put(this.parseMapKey(value.get((int)i).name, keyClass), this.deserialize(value.get(i), valueClass));
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (Mdx.reflect.isPrimitive(clazz)) {
            return true;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Character.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        return clazz.equals(Short.class);
    }

    private <T> T parseMapKey(String value, Class<T> clazz) {
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return (T)new Boolean(value);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return (T)new Byte(value);
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
            return (T)new Character(value.charAt(0));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return (T)new Double(value);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return (T)new Float(value);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return (T)new Integer(value);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return (T)new Long(value);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return (T)new Short(value);
        }
        if (Mdx.reflect.isEnum(clazz)) {
            return Enum.valueOf(clazz, value);
        }
        return (T)value;
    }
}

