/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentObjectMap;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.exception.RequiredFieldException;
import org.mini2Dx.core.exception.SerializationException;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Constructor;
import org.mini2Dx.core.reflect.ConstructorSorter;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.annotation.ConstructorArg;
import org.mini2Dx.core.serialization.annotation.Field;
import org.mini2Dx.core.serialization.annotation.NonConcrete;
import org.mini2Dx.core.serialization.annotation.PostDeserialize;
import org.mini2Dx.core.serialization.aot.AotSerializedClassData;
import org.mini2Dx.core.serialization.aot.AotSerializedConstructorData;
import org.mini2Dx.core.serialization.collection.DeserializedCollection;
import org.mini2Dx.core.serialization.collection.SerializedCollection;
import org.mini2Dx.core.serialization.map.deserialize.DeserializedMap;
import org.mini2Dx.core.serialization.map.serialize.SerializedMap;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.xml.XmlReader;
import org.mini2Dx.gdx.xml.XmlWriter;

public class XmlSerializer {
    private static final String LOGGING_TAG = XmlSerializer.class.getSimpleName();
    private final ObjectMap<String, Method> postDeserializeCache = new ConcurrentObjectMap<String, Method>();

    public <T> T fromXml(String xml, Class<T> clazz) throws SerializationException {
        return this.fromXml(new StringReader(xml), clazz);
    }

    public <T> T fromXml(Reader reader, Class<T> clazz) throws SerializationException {
        T result = null;
        try {
            XmlReader xmlReader = new XmlReader();
            XmlReader.Element root = xmlReader.parse(reader);
            result = this.deserializeObject(root, clazz);
        }
        catch (org.mini2Dx.gdx.xml.SerializationException e) {
            throw new SerializationException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
        }
        return result;
    }

    public <T> String toXml(T object) throws SerializationException {
        StringWriter writer = new StringWriter();
        this.toXml(object, writer);
        return writer.toString();
    }

    public <T> void toXml(T object, Writer writer) throws SerializationException {
        try {
            XmlWriter xmlWriter = new XmlWriter(writer);
            this.writeObject(null, object, "data", xmlWriter);
            writer.flush();
            writer.close();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private <T> void writeObject(org.mini2Dx.core.reflect.Field fieldDefinition, T object, String tagName, XmlWriter xmlWriter) throws SerializationException {
        try {
            Class<?> currentClass;
            ConstructorArg constructorArg;
            Annotation annotation;
            Method[] methods;
            if (object == null) {
                this.writePrimitive(tagName, "", xmlWriter);
                return;
            }
            Class<?> clazz = object.getClass();
            if (this.isPrimitive(clazz) || clazz.equals(String.class)) {
                this.writePrimitive(tagName, object, xmlWriter);
                return;
            }
            if (Mdx.reflect.isArray(clazz)) {
                this.writeArray(fieldDefinition, object, xmlWriter);
                return;
            }
            if (Mdx.reflect.isEnum(clazz) || Mdx.reflect.isEnum(clazz.getSuperclass())) {
                this.writePrimitive(tagName, object, xmlWriter);
                return;
            }
            SerializedMap serializedMap = SerializedMap.getImplementation(clazz, object);
            if (serializedMap != null) {
                this.writeSerializedMap(fieldDefinition, serializedMap, xmlWriter);
                return;
            }
            SerializedCollection serializedCollection = SerializedCollection.getImplementation(clazz, object);
            if (serializedCollection != null) {
                this.writeSerializedCollection(fieldDefinition, serializedCollection, xmlWriter);
                return;
            }
            if (tagName != null) {
                xmlWriter.element(tagName);
                this.writeClassFieldIfRequired(fieldDefinition, object, tagName, xmlWriter);
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    for (Method method : methods = Mdx.reflect.getDeclaredMethods(interfaces[i])) {
                        if (method.getParameterTypes().length > 0 || (annotation = method.getDeclaredAnnotation(ConstructorArg.class)) == null) continue;
                        constructorArg = annotation.getAnnotation(ConstructorArg.class);
                        xmlWriter.attribute(constructorArg.name(), (Object)String.valueOf(method.invoke(object, new Object[0])));
                    }
                }
            }
            for (currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                String className = currentClass.getName();
                for (Method method : methods = Mdx.reflect.getDeclaredMethods(currentClass)) {
                    if (method.getParameterTypes().length > 0 || (annotation = method.getDeclaredAnnotation(ConstructorArg.class)) == null) continue;
                    constructorArg = annotation.getAnnotation(ConstructorArg.class);
                    xmlWriter.attribute(constructorArg.name(), (Object)String.valueOf(method.invoke(object, new Object[0])));
                }
            }
            for (currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                org.mini2Dx.core.reflect.Field[] fields;
                String className = currentClass.getName();
                AotSerializedClassData classData = AotSerializationData.getClassData(currentClass);
                for (org.mini2Dx.core.reflect.Field field : fields = classData == null ? Mdx.reflect.getDeclaredFields(currentClass) : classData.getFieldDataAsFieldArray()) {
                    Annotation annotation2 = field.getDeclaredAnnotation(Field.class);
                    if (annotation2 == null) continue;
                    Field fieldAnnotation = annotation2.getAnnotation(Field.class);
                    Object value = field.get(object);
                    if (!fieldAnnotation.optional() && value == null) {
                        throw new RequiredFieldException(currentClass, field.getName());
                    }
                    if (fieldAnnotation.optional() && value == null) continue;
                    this.writeObject(field, value, field.getName(), xmlWriter);
                }
            }
            if (tagName != null) {
                xmlWriter.pop();
            }
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private <T> T deserializeObject(XmlReader.Element element, Class<T> objClass) throws SerializationException {
        try {
            if (this.isPrimitive(objClass) || objClass.equals(String.class)) {
                return this.parsePrimitive(element.getText(), objClass);
            }
            if (Mdx.reflect.isEnum(objClass)) {
                return Enum.valueOf(objClass, element.getText());
            }
            Class<?> clazz = this.determineImplementation(element, objClass);
            T result = this.construct(element, clazz);
            for (int i = 0; i < element.getChildCount(); ++i) {
                XmlReader.Element child = element.getChild(i);
                String currentFieldName = child.getName();
                org.mini2Dx.core.reflect.Field currentField = this.findField(clazz, currentFieldName);
                Class fieldClass = currentField.getType();
                if (Mdx.reflect.isArray(fieldClass)) {
                    int arraySize = child.getIntAttribute("length", 0);
                    this.setArrayField(child, currentField, fieldClass, result, arraySize);
                    continue;
                }
                if (Mdx.reflect.isEnum(fieldClass)) {
                    this.setEnumField(currentField, fieldClass, result, child.getText());
                    continue;
                }
                if (!Mdx.reflect.isPrimitive(fieldClass)) {
                    if (fieldClass.equals(String.class)) {
                        this.setPrimitiveField(currentField, fieldClass, result, child.getText());
                        continue;
                    }
                    DeserializedMap deserializedMap = DeserializedMap.getImplementation(clazz, currentField, fieldClass, result);
                    if (deserializedMap != null) {
                        this.setSerializedMapField(child, deserializedMap);
                        continue;
                    }
                    DeserializedCollection deserializedCollection = DeserializedCollection.getImplementation(clazz, currentField, fieldClass, result);
                    if (deserializedCollection != null) {
                        this.setSerializedCollectionField(child, deserializedCollection);
                        continue;
                    }
                    if (currentField.isFinal()) {
                        throw new SerializationException("Cannot use @Field on final " + fieldClass.getName() + " fields.");
                    }
                    currentField.set(result, this.deserializeObject(child, fieldClass));
                    continue;
                }
                this.setPrimitiveField(currentField, fieldClass, result, child.getText());
            }
            this.callPostDeserializeMethods(result, clazz);
            return result;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (ReflectionException e) {
            e.printStackTrace();
            throw new SerializationException(element.toString() + "\n" + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializationException(element.toString() + "\n" + e.getMessage(), e);
        }
    }

    private <T> void callPostDeserializeMethods(T object, Class<?> clazz) throws SerializationException {
        block6: for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            String className = currentClass.getName();
            if (this.postDeserializeCache.containsKey((Object)className)) {
                try {
                    ((Method)this.postDeserializeCache.get((Object)className)).invoke(object, new Object[0]);
                    continue;
                }
                catch (ReflectionException e) {
                    throw new SerializationException(e);
                }
            }
            Method[] methods = Mdx.reflect.getDeclaredMethods(currentClass);
            AotSerializedClassData classData = AotSerializationData.getClassData(currentClass);
            if (classData != null) {
                if (classData.getPostDeserializeMethodName() == null) continue;
                for (Method method : methods) {
                    if (!method.getName().equals(classData.getPostDeserializeMethodName())) continue;
                    this.postDeserializeCache.put((Object)className, (Object)method);
                    try {
                        method.invoke(object, new Object[0]);
                        continue block6;
                    }
                    catch (ReflectionException e) {
                        throw new SerializationException(e);
                    }
                }
                continue;
            }
            for (Method method : methods) {
                if (!method.isAnnotationPresent(PostDeserialize.class)) continue;
                try {
                    method.invoke(object, new Object[0]);
                }
                catch (ReflectionException e) {
                    throw new SerializationException(e);
                }
            }
        }
    }

    private Class<?> determineImplementation(XmlReader.Element element, Class<?> clazz) throws ClassNotFoundException, SerializationException {
        if (Mdx.reflect.isInterface(clazz) || Mdx.reflect.isAbstract(clazz)) {
            String classValue = element.getAttribute("class", null);
            if (classValue == null) {
                throw new SerializationException("No class field found for deserializing " + clazz.getName());
            }
            clazz = Mdx.reflect.forName(classValue);
        }
        return clazz;
    }

    private <T> T construct(XmlReader.Element element, Class<?> clazz) throws SerializationException, IllegalArgumentException {
        Constructor[] constructors = Mdx.reflect.getConstructors(clazz);
        ConstructorSorter.sort(constructors);
        if (constructors.length == 1 && constructors[0].getParameterAnnotations().length == 0) {
            return (T)constructors[0].newInstance(new Object[0]);
        }
        int attributesCountModifier = element.getAttributes() != null && element.getAttributes().containsKey((Object)"class") ? 1 : 0;
        AotSerializedClassData classData = AotSerializationData.getClassData(clazz);
        if (classData != null) {
            AotSerializedConstructorData bestMatchedConstructor = null;
            for (int i = 0; i < classData.getTotalConstructors(); ++i) {
                AotSerializedConstructorData constructorData = classData.getConstructorData(i);
                boolean allMatched = true;
                for (int j = 0; j < constructorData.getTotalArgs(); ++j) {
                    String argName = constructorData.getConstructorArgName(j);
                    if (element.getAttributes() != null && element.getAttributes().containsKey((Object)argName)) continue;
                    allMatched = false;
                    break;
                }
                if (!allMatched) continue;
                if (bestMatchedConstructor == null) {
                    bestMatchedConstructor = constructorData;
                    continue;
                }
                if (constructorData.getTotalArgs() <= bestMatchedConstructor.getTotalArgs()) continue;
                bestMatchedConstructor = constructorData;
            }
            if (bestMatchedConstructor == null) {
                return (T)Mdx.reflect.newInstance(clazz);
            }
            Object[] constructorParameters = new Object[bestMatchedConstructor.getTotalArgs()];
            for (int i = 0; i < bestMatchedConstructor.getTotalArgs(); ++i) {
                constructorParameters[i] = this.parsePrimitive((String)element.getAttributes().get((Object)bestMatchedConstructor.getConstructorArgName(i)), bestMatchedConstructor.getConstructorArgTypes()[i]);
            }
            boolean couldNotFindConstructor = false;
            try {
                return (T)clazz.getConstructor(bestMatchedConstructor.getConstructorArgTypes()).newInstance(constructorParameters);
            }
            catch (NoSuchMethodException e) {
                couldNotFindConstructor = true;
            }
            catch (Exception e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
            try {
                return (T)clazz.getConstructor(bestMatchedConstructor.getConstructorArgTypesWithPrimitives()).newInstance(constructorParameters);
            }
            catch (NoSuchMethodException e) {
                couldNotFindConstructor = true;
            }
            catch (Exception e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
            if (couldNotFindConstructor) {
                Mdx.log.error(LOGGING_TAG, "Could not find constructor for " + clazz.getName() + ". Falling back to default constructor");
            }
            return (T)Mdx.reflect.newInstance(clazz);
        }
        Constructor bestMatchedConstructor = null;
        Array detectedAnnotations = new Array(1);
        for (int i = 0; i < constructors.length; ++i) {
            detectedAnnotations.clear();
            boolean allAnnotated = constructors[i].getParameterAnnotations().length > 0;
            for (int j = 0; j < constructors[i].getParameterAnnotations().length; ++j) {
                Annotation[] annotations = constructors[i].getParameterAnnotations()[j];
                if (annotations.length == 0) {
                    allAnnotated = false;
                    break;
                }
                boolean hasConstructorArgAnnotation = false;
                for (int k = 0; k < annotations.length; ++k) {
                    Annotation annotation;
                    if (!annotations[k].getAnnotationType().isAssignableFrom(ConstructorArg.class) || (annotation = annotations[k]) == null) continue;
                    ConstructorArg constructorArg = annotation.getAnnotation(ConstructorArg.class);
                    if (element.getAttributes() == null || !element.getAttributes().containsKey((Object)constructorArg.name())) continue;
                    detectedAnnotations.add((Object)constructorArg);
                    hasConstructorArgAnnotation = true;
                    break;
                }
                if (hasConstructorArgAnnotation) continue;
                allAnnotated = false;
            }
            if (!allAnnotated) continue;
            if (detectedAnnotations.size == element.getAttributes().size - attributesCountModifier) {
                bestMatchedConstructor = constructors[i];
                break;
            }
            if (bestMatchedConstructor == null) {
                bestMatchedConstructor = constructors[i];
                continue;
            }
            if (detectedAnnotations.size <= bestMatchedConstructor.getParameterAnnotations().length) continue;
            bestMatchedConstructor = constructors[i];
        }
        if (bestMatchedConstructor == null || detectedAnnotations.size == 0) {
            if (detectedAnnotations.size > 0) {
                Mdx.log.error(LOGGING_TAG, "Could not find suitable constructor for " + clazz.getSimpleName() + ". Falling back to default constructor.");
            }
            return (T)Mdx.reflect.newInstance(clazz);
        }
        Object[] constructorParameters = new Object[detectedAnnotations.size];
        for (int i = 0; i < detectedAnnotations.size; ++i) {
            ConstructorArg constructorArg = (ConstructorArg)detectedAnnotations.get(i);
            constructorParameters[i] = this.parsePrimitive((String)element.getAttributes().get((Object)constructorArg.name()), constructorArg.clazz());
        }
        return (T)bestMatchedConstructor.newInstance(constructorParameters);
    }

    private org.mini2Dx.core.reflect.Field findField(Class<?> clazz, String fieldName) throws ReflectionException {
        Class<?> currentClass = clazz;
        while (currentClass != null && !currentClass.equals(Object.class)) {
            try {
                org.mini2Dx.core.reflect.Field result = Mdx.reflect.getDeclaredField(currentClass, fieldName);
                if (result == null) continue;
                return result;
            }
            catch (ReflectionException reflectionException) {
                currentClass = currentClass.getSuperclass();
            }
        }
        throw new ReflectionException("No field '" + fieldName + "' found in class " + clazz.getName());
    }

    private <T> void setSerializedMapField(XmlReader.Element element, DeserializedMap deserializedMap) throws SerializationException {
        Class<?> keyClass = deserializedMap.getKeyClass();
        Class<?> valueClass = deserializedMap.getValueClass();
        for (XmlReader.Element entry : element.getChildrenByName("entry")) {
            Object key = this.deserializeObject(entry.getChildByName("key"), keyClass);
            Object value = this.deserializeObject(entry.getChildByName("value"), valueClass);
            deserializedMap.put(key, value);
        }
    }

    private <T> void setSerializedCollectionField(XmlReader.Element element, DeserializedCollection deserializedCollection) throws SerializationException {
        Class<?> valueClass = deserializedCollection.getValueClass();
        for (XmlReader.Element value : element.getChildrenByName("value")) {
            deserializedCollection.add(this.deserializeObject(value, valueClass));
        }
    }

    private <T> void setArrayField(XmlReader.Element element, org.mini2Dx.core.reflect.Field field, Class<?> fieldClass, T object, int size) throws SerializationException {
        try {
            Class arrayType = Mdx.reflect.arrayComponentType(fieldClass);
            Array list = new Array();
            for (XmlReader.Element value : element.getChildrenByName("value")) {
                list.add(this.deserializeObject(value, arrayType));
            }
            Object targetArray = null;
            targetArray = field.isFinal() ? field.get(object) : Mdx.reflect.newArray(arrayType, size);
            for (int i = 0; i < list.size; ++i) {
                Mdx.reflect.arraySet(targetArray, i, list.get(i));
            }
            if (!field.isFinal()) {
                field.set(object, targetArray);
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw new SerializationException("Could not set " + field.getName() + " - " + e.getMessage(), e);
        }
    }

    private <T> void setEnumField(org.mini2Dx.core.reflect.Field field, Class<?> fieldClass, T object, String value) throws SerializationException {
        if (field.isFinal()) {
            throw new SerializationException("Cannot use @Field on final enum fields. Use the @ConstructorArg method instead.");
        }
        try {
            field.set(object, Enum.valueOf(fieldClass, value));
        }
        catch (ReflectionException e) {
            throw new SerializationException("Could not set field " + field.getName() + " with value '" + value + "' - " + e.getMessage(), e);
        }
    }

    private <T> void setPrimitiveField(org.mini2Dx.core.reflect.Field field, Class<?> fieldClass, T object, String value) throws SerializationException {
        if (field.isFinal()) {
            throw new SerializationException("Cannot use @Field on final " + fieldClass.getName() + " fields.");
        }
        try {
            if (fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.class)) {
                field.set(object, Boolean.parseBoolean(value));
            } else if (fieldClass.equals(Byte.TYPE) || fieldClass.equals(Byte.class)) {
                field.set(object, Byte.parseByte(value));
            } else if (fieldClass.equals(Character.TYPE) || fieldClass.equals(Character.class)) {
                field.set(object, Character.valueOf(value.charAt(0)));
            } else if (fieldClass.equals(Double.TYPE) || fieldClass.equals(Double.class)) {
                field.set(object, Double.parseDouble(value));
            } else if (fieldClass.equals(Float.TYPE) || fieldClass.equals(Float.class)) {
                field.set(object, Float.valueOf(Float.parseFloat(value)));
            } else if (fieldClass.equals(Integer.TYPE) || fieldClass.equals(Integer.class)) {
                field.set(object, Integer.parseInt(value));
            } else if (fieldClass.equals(Long.TYPE) || fieldClass.equals(Long.class)) {
                field.set(object, Long.parseLong(value));
            } else if (fieldClass.equals(Short.TYPE) || fieldClass.equals(Short.class)) {
                field.set(object, Short.parseShort(value));
            } else {
                field.set(object, value);
            }
        }
        catch (Exception e) {
            Mdx.log.error(LOGGING_TAG, "Could not set field " + field.getName() + " with value '" + value + "' - " + e.getMessage());
            throw new SerializationException("Could not set field " + field.getName() + " with value '" + value + "' - " + e.getMessage(), e);
        }
    }

    private <T> void writeClassFieldIfRequired(org.mini2Dx.core.reflect.Field fieldDefinition, T object, String fieldName, XmlWriter xmlWriter) throws SerializationException, IOException {
        if (fieldDefinition == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        Class fieldDefinitionClass = fieldDefinition.getType();
        if (Mdx.reflect.isArray(fieldDefinitionClass)) {
            Class arrayComponentType = Mdx.reflect.arrayComponentType(fieldDefinitionClass);
            if (Mdx.reflect.isInterface(arrayComponentType) && Mdx.reflect.getAnnotation(arrayComponentType, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
        if (Mdx.reflect.isAssignableFrom(Collection.class, fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(0);
            if (Mdx.reflect.isInterface(valueClass) && Mdx.reflect.getAnnotation(valueClass, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
        if (Mdx.reflect.isAssignableFrom(Array.class, fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(0);
            if (Mdx.reflect.isInterface(valueClass) && Mdx.reflect.getAnnotation(valueClass, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
        if (Mdx.reflect.isAssignableFrom(Map.class, fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(1);
            if (Mdx.reflect.isInterface(valueClass) && Mdx.reflect.getAnnotation(valueClass, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
        if (Mdx.reflect.isAssignableFrom(ObjectMap.class, fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(1);
            if (Mdx.reflect.isInterface(valueClass) && Mdx.reflect.getAnnotation(valueClass, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
        if (Mdx.reflect.isInterface(fieldDefinitionClass)) {
            if (Mdx.reflect.getAnnotation(fieldDefinitionClass, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
        if (Mdx.reflect.isAbstract(fieldDefinitionClass)) {
            if (Mdx.reflect.getAnnotation(fieldDefinitionClass, NonConcrete.class) == null) {
                throw new SerializationException(fieldName + ":: Cannot serialize abstract class unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            xmlWriter.attribute("class", (Object)clazz.getName());
            return;
        }
    }

    private <T> void writeSerializedMap(org.mini2Dx.core.reflect.Field field, SerializedMap map, XmlWriter xmlWriter) throws SerializationException {
        try {
            if (field != null) {
                xmlWriter.element(field.getName());
            }
            for (Object key : map.keys()) {
                xmlWriter.element("entry");
                this.writeObject(null, key, "key", xmlWriter);
                this.writeObject(field, map.get(key), "value", xmlWriter);
                xmlWriter.pop();
            }
            if (field != null) {
                xmlWriter.pop();
            }
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private <T> void writeSerializedCollection(org.mini2Dx.core.reflect.Field field, SerializedCollection serializedCollection, XmlWriter xmlWriter) throws SerializationException {
        try {
            if (field != null) {
                xmlWriter.element(field.getName());
                xmlWriter.attribute("length", (Object)String.valueOf(serializedCollection.getLength()));
            }
            for (int i = 0; i < serializedCollection.getLength(); ++i) {
                Object object = serializedCollection.get(i);
                if (object == null) continue;
                this.writeObject(field, object, "value", xmlWriter);
            }
            if (field != null) {
                xmlWriter.pop();
            }
            serializedCollection.dispose();
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private <T> void writeArray(org.mini2Dx.core.reflect.Field field, T array, XmlWriter xmlWriter) throws SerializationException {
        try {
            int arrayLength = Mdx.reflect.arrayLength(array);
            if (field != null) {
                xmlWriter.element(field.getName());
                xmlWriter.attribute("length", (Object)String.valueOf(arrayLength));
            }
            for (int i = 0; i < arrayLength; ++i) {
                Object object = Mdx.reflect.arrayGet(array, i);
                if (object == null) continue;
                this.writeObject(field, object, "value", xmlWriter);
            }
            if (field != null) {
                xmlWriter.pop();
            }
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new SerializationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private <T> void writePrimitive(String tagName, T object, XmlWriter xmlWriter) throws IOException {
        if (tagName != null) {
            xmlWriter.element(tagName, (Object)String.valueOf(object));
        } else {
            xmlWriter.write(String.valueOf(object));
        }
    }

    private <T> T parsePrimitive(String value, Class<T> fieldClass) throws SerializationException {
        if (value != null && value.contains("&nbsp;")) {
            value = value.replace("&nbsp;", " ");
        }
        try {
            if (fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.class)) {
                return (T)new Boolean(value);
            }
            if (fieldClass.equals(Byte.TYPE) || fieldClass.equals(Byte.class)) {
                return (T)new Byte(value);
            }
            if (fieldClass.equals(Character.TYPE) || fieldClass.equals(Character.class)) {
                return (T)Character.valueOf(value.charAt(0));
            }
            if (fieldClass.equals(Double.TYPE) || fieldClass.equals(Double.class)) {
                return (T)new Double(value);
            }
            if (fieldClass.equals(Float.TYPE) || fieldClass.equals(Float.class)) {
                return (T)new Float(value);
            }
            if (fieldClass.equals(Integer.TYPE) || fieldClass.equals(Integer.class)) {
                return (T)new Integer(value);
            }
            if (fieldClass.equals(Long.TYPE) || fieldClass.equals(Long.class)) {
                return (T)new Long(value);
            }
            if (fieldClass.equals(Short.TYPE) || fieldClass.equals(Short.class)) {
                return (T)new Short(value);
            }
            return (T)value;
        }
        catch (Exception e) {
            if (Mdx.log != null) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            } else {
                e.printStackTrace();
            }
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (Mdx.reflect.isPrimitive(clazz)) {
            return true;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Character.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        return clazz.equals(Short.class);
    }
}

