/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.aot;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.Scanner;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Constructor;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.serialization.annotation.ConstructorArg;
import org.mini2Dx.core.serialization.annotation.Field;
import org.mini2Dx.core.serialization.annotation.NonConcrete;
import org.mini2Dx.core.serialization.annotation.PostDeserialize;
import org.mini2Dx.core.serialization.aot.AotSerializedConstructorData;
import org.mini2Dx.core.serialization.aot.AotSerializedFieldData;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;

public class AotSerializedClassData {
    private final String qualifiedClassName;
    private final String postDeserializeMethodName;
    private final boolean nonConcrete;
    private final Class clazz;
    private final Array<AotSerializedConstructorData> constructorData = new Array();
    private final Array<AotSerializedFieldData> fieldData = new Array();
    private final ObjectMap<String, AotSerializedFieldData> fieldDataByFieldName = new ObjectMap();
    private org.mini2Dx.core.reflect.Field[] fieldDataAsFieldArray;

    public AotSerializedClassData(Class clazz) {
        this.clazz = clazz;
        this.qualifiedClassName = clazz.getName();
        this.nonConcrete = Mdx.reflect.isAnnotationPresent(clazz, NonConcrete.class);
        String postDeserializeMethod = null;
        for (Method method : Mdx.reflect.getDeclaredMethods(clazz)) {
            if (!method.isAnnotationPresent(PostDeserialize.class)) continue;
            postDeserializeMethod = method.getName();
            break;
        }
        this.postDeserializeMethodName = postDeserializeMethod;
        Constructor[] constructors = Mdx.reflect.getConstructors(clazz);
        Array constructorArgs = new Array();
        for (int i = 0; i < constructors.length; ++i) {
            constructorArgs.clear();
            for (int j = 0; j < constructors[i].getParameterAnnotations().length; ++j) {
                ConstructorArg constructorArg = null;
                Annotation[] annotations = constructors[i].getParameterAnnotations()[j];
                for (int k = 0; k < annotations.length; ++k) {
                    Annotation annotation;
                    if (!annotations[k].getAnnotationType().isAssignableFrom(ConstructorArg.class) || (annotation = annotations[k]) == null) continue;
                    constructorArg = annotation.getAnnotation(ConstructorArg.class);
                    break;
                }
                if (constructorArg == null) {
                    constructorArgs.clear();
                    break;
                }
                constructorArgs.add(constructorArg);
            }
            if (constructorArgs.size == 0 || constructorArgs.size != constructors[i].getParameterTypes().length) continue;
            this.constructorData.add((Object)new AotSerializedConstructorData(clazz, constructors[i], (Array<ConstructorArg>)constructorArgs));
        }
        org.mini2Dx.core.reflect.Field[] fields = Mdx.reflect.getDeclaredFields(clazz);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Field.class)) continue;
            this.fieldData.add((Object)new AotSerializedFieldData(clazz, fields[i]));
        }
    }

    public AotSerializedClassData(Scanner scanner) throws ClassNotFoundException {
        this.qualifiedClassName = scanner.nextLine();
        this.nonConcrete = Boolean.parseBoolean(scanner.nextLine());
        String postDeserializeMethod = scanner.nextLine();
        this.postDeserializeMethodName = postDeserializeMethod.equals("null") ? null : postDeserializeMethod;
        this.clazz = Class.forName(this.qualifiedClassName);
        int totalConstructors = Integer.parseInt(scanner.nextLine().trim());
        for (int i = 0; i < totalConstructors; ++i) {
            this.constructorData.add((Object)new AotSerializedConstructorData(scanner));
        }
        int totalFields = Integer.parseInt(scanner.nextLine().trim());
        for (int i = 0; i < totalFields; ++i) {
            this.fieldData.add((Object)new AotSerializedFieldData(this.clazz, scanner));
        }
    }

    public void saveTo(PrintWriter writer) {
        int i;
        writer.println(this.qualifiedClassName);
        writer.println(this.nonConcrete);
        writer.println(this.postDeserializeMethodName);
        writer.println(this.constructorData.size);
        for (i = 0; i < this.constructorData.size; ++i) {
            ((AotSerializedConstructorData)this.constructorData.get(i)).saveTo(writer);
        }
        writer.println(this.fieldData.size);
        for (i = 0; i < this.fieldData.size; ++i) {
            ((AotSerializedFieldData)this.fieldData.get(i)).saveTo(writer);
        }
    }

    public String getQualifiedClassName() {
        return this.qualifiedClassName;
    }

    public String getPostDeserializeMethodName() {
        return this.postDeserializeMethodName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public int getTotalFields() {
        return this.fieldData.size;
    }

    public AotSerializedFieldData getFieldData(int fieldIndex) {
        return (AotSerializedFieldData)this.fieldData.get(fieldIndex);
    }

    public org.mini2Dx.core.reflect.Field getFieldDataAsField(int fieldIndex) {
        return ((AotSerializedFieldData)this.fieldData.get(fieldIndex)).getField();
    }

    public synchronized org.mini2Dx.core.reflect.Field[] getFieldDataAsFieldArray() {
        if (this.fieldDataAsFieldArray == null) {
            this.fieldDataAsFieldArray = new org.mini2Dx.core.reflect.Field[this.getTotalFields()];
            for (int i = 0; i < this.fieldDataAsFieldArray.length; ++i) {
                this.fieldDataAsFieldArray[i] = this.getFieldData(i).getField();
            }
        }
        return this.fieldDataAsFieldArray;
    }

    public synchronized AotSerializedFieldData getFieldData(String fieldName) {
        if (this.fieldDataByFieldName.containsKey((Object)fieldName)) {
            return (AotSerializedFieldData)this.fieldDataByFieldName.get((Object)fieldName);
        }
        for (int i = 0; i < this.fieldData.size; ++i) {
            AotSerializedFieldData fieldData = (AotSerializedFieldData)this.fieldData.get(i);
            if (!fieldData.getFieldName().equals(fieldName)) continue;
            this.fieldDataByFieldName.put((Object)fieldName, (Object)fieldData);
            return fieldData;
        }
        return null;
    }

    public int getTotalConstructors() {
        return this.constructorData.size;
    }

    public AotSerializedConstructorData getConstructorData(int index) {
        return (AotSerializedConstructorData)this.constructorData.get(index);
    }

    public boolean isNonConcrete() {
        return this.nonConcrete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AotSerializedClassData)) {
            return false;
        }
        AotSerializedClassData classData = (AotSerializedClassData)o;
        return this.nonConcrete == classData.nonConcrete && Objects.equals(this.qualifiedClassName, classData.qualifiedClassName) && Objects.equals(this.postDeserializeMethodName, classData.postDeserializeMethodName) && Objects.equals(this.constructorData, classData.constructorData) && Objects.equals(this.fieldData, classData.fieldData);
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedClassName, this.postDeserializeMethodName, this.nonConcrete, this.constructorData, this.fieldData);
    }
}

