/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.aot;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.Scanner;
import org.mini2Dx.core.reflect.Constructor;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.annotation.ConstructorArg;
import org.mini2Dx.gdx.utils.Array;

public class AotSerializedConstructorData {
    private static final String ARG_SEPERATOR = ":";
    private static final String INFO_SEPERATOR = ",";
    private final Array<String> constructorArgNames = new Array();
    private final Array<String> constructorArgTypes = new Array();
    private Class[] constructorArgClasses = null;
    private Class[] constructorArgClassesWithPrimitives = null;

    public AotSerializedConstructorData(Class ownerClass, Constructor constructor, Array<ConstructorArg> constructorArgs) {
        for (int i = 0; i < constructorArgs.size; ++i) {
            this.constructorArgNames.add((Object)((ConstructorArg)constructorArgs.get(i)).name());
            Class<?> clazz = null;
            clazz = ((ConstructorArg)constructorArgs.get(i)).clazz() != null ? ((ConstructorArg)constructorArgs.get(i)).clazz() : constructor.getParameterTypes()[i];
            if (!clazz.equals(ownerClass)) {
                AotSerializationData.registerClass(clazz);
            }
            this.constructorArgTypes.add((Object)clazz.getName());
        }
    }

    public AotSerializedConstructorData(Scanner scanner) throws ClassNotFoundException {
        String[] data = scanner.nextLine().split(ARG_SEPERATOR);
        int totalArgs = Integer.parseInt(data[0]);
        for (int i = 0; i < totalArgs; ++i) {
            String[] argData = data[i + 1].split(INFO_SEPERATOR);
            this.constructorArgNames.add((Object)argData[0]);
            this.constructorArgTypes.add((Object)argData[1]);
        }
    }

    public void saveTo(PrintWriter writer) {
        StringBuilder result = new StringBuilder();
        result.append(this.constructorArgTypes.size);
        result.append(ARG_SEPERATOR);
        for (int i = 0; i < this.constructorArgNames.size; ++i) {
            result.append((String)this.constructorArgNames.get(i));
            result.append(INFO_SEPERATOR);
            result.append((String)this.constructorArgTypes.get(i));
            if (i >= this.constructorArgNames.size - 1) continue;
            result.append(ARG_SEPERATOR);
        }
        writer.println(result.toString());
    }

    public synchronized int getTotalArgs() {
        return this.constructorArgNames.size;
    }

    public synchronized String getConstructorArgName(int index) {
        return (String)this.constructorArgNames.get(index);
    }

    public synchronized Class getConstructorArgType(int index) {
        return this.getConstructorArgTypes()[index];
    }

    public synchronized Class getConstructorArgPrimitiveType(int index) {
        switch (((String)this.constructorArgTypes.get(index)).toLowerCase()) {
            case "java.lang.boolean": {
                return Boolean.TYPE;
            }
            case "java.lang.byte": {
                return Byte.TYPE;
            }
            case "java.lang.char": {
                return Character.TYPE;
            }
            case "java.lang.double": {
                return Double.TYPE;
            }
            case "java.lang.float": {
                return Float.TYPE;
            }
            case "java.lang.integer": {
                return Integer.TYPE;
            }
            case "java.lang.long": {
                return Long.TYPE;
            }
            case "java.lang.short": {
                return Short.TYPE;
            }
        }
        return null;
    }

    public synchronized Class[] getConstructorArgTypes() {
        if (this.constructorArgClasses == null) {
            this.constructorArgClasses = new Class[this.constructorArgTypes.size];
            for (int i = 0; i < this.constructorArgClasses.length; ++i) {
                try {
                    this.constructorArgClasses[i] = Class.forName((String)this.constructorArgTypes.get(i));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.constructorArgClasses;
    }

    public synchronized Class[] getConstructorArgTypesWithPrimitives() {
        if (this.constructorArgClassesWithPrimitives == null) {
            this.constructorArgClassesWithPrimitives = new Class[this.constructorArgTypes.size];
            for (int i = 0; i < this.constructorArgClassesWithPrimitives.length; ++i) {
                Class primitiveType = this.getConstructorArgPrimitiveType(i);
                if (primitiveType == null) {
                    try {
                        this.constructorArgClassesWithPrimitives[i] = Class.forName((String)this.constructorArgTypes.get(i));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.constructorArgClassesWithPrimitives[i] = primitiveType;
            }
        }
        return this.constructorArgClassesWithPrimitives;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AotSerializedConstructorData)) {
            return false;
        }
        AotSerializedConstructorData that = (AotSerializedConstructorData)o;
        return Objects.equals(this.constructorArgNames, that.constructorArgNames) && Objects.equals(this.constructorArgTypes, that.constructorArgTypes);
    }

    public int hashCode() {
        return Objects.hash(this.constructorArgNames, this.constructorArgTypes);
    }
}

