/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.aot;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.Scanner;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.gdx.utils.Array;

public class AotSerializedFieldData {
    private final String fieldName;
    private final Field field;
    private final Array<Class> elementTypes = new Array();

    public AotSerializedFieldData(Class ownerClass, Field field) {
        this.fieldName = field.getName();
        this.field = field;
        if (!field.getType().equals(ownerClass)) {
            AotSerializationData.registerClass(field.getType());
        }
        for (int i = 0; i < field.getTotalElementTypes(); ++i) {
            Class elementClass = field.getElementType(i);
            this.elementTypes.add((Object)elementClass);
            if (elementClass.equals(ownerClass)) continue;
            AotSerializationData.registerClass(elementClass);
        }
    }

    public AotSerializedFieldData(Class clazz, Scanner scanner) throws ClassNotFoundException {
        String[] fieldInfo = scanner.nextLine().split(",");
        this.fieldName = fieldInfo[0];
        this.field = Mdx.reflect.getDeclaredField(clazz, this.fieldName);
        int totalElementTypes = Integer.parseInt(fieldInfo[1].trim());
        for (int i = 0; i < totalElementTypes; ++i) {
            this.elementTypes.add(Class.forName(fieldInfo[2 + i]));
        }
    }

    public void saveTo(PrintWriter writer) {
        StringBuilder result = new StringBuilder();
        result.append(this.fieldName);
        result.append(',');
        result.append(this.field.getTotalElementTypes());
        for (int i = 0; i < this.field.getTotalElementTypes(); ++i) {
            result.append(',');
            result.append(this.field.getElementType(i).getName());
        }
        writer.println(result);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Field getField() {
        return this.field;
    }

    public int getTotalElementTypes() {
        return this.elementTypes.size;
    }

    public Class getElementType(int index) {
        return (Class)this.elementTypes.get(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AotSerializedFieldData fieldData = (AotSerializedFieldData)o;
        return Objects.equals(this.fieldName, fieldData.fieldName) && Objects.equals(this.elementTypes, fieldData.elementTypes);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.elementTypes);
    }
}

