/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.collection;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.serialization.collection.GdxDeserializedCollection;
import org.mini2Dx.core.serialization.collection.ListDeserializedCollection;
import org.mini2Dx.core.serialization.collection.SetDeserializedCollection;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.BooleanArray;
import org.mini2Dx.gdx.utils.ByteArray;
import org.mini2Dx.gdx.utils.CharArray;
import org.mini2Dx.gdx.utils.FloatArray;
import org.mini2Dx.gdx.utils.IntArray;
import org.mini2Dx.gdx.utils.IntSet;
import org.mini2Dx.gdx.utils.LongArray;
import org.mini2Dx.gdx.utils.ObjectSet;
import org.mini2Dx.gdx.utils.OrderedSet;
import org.mini2Dx.gdx.utils.ShortArray;
import org.mini2Dx.gdx.utils.SortedIntList;

public abstract class DeserializedCollection<T> {
    protected final Class<?> ownerClass;
    protected final Field field;
    protected final Class<?> fieldClass;
    protected final T collection;

    public DeserializedCollection(Class<?> ownerClass, Field field, Class<?> fieldClass, Object object) throws ReflectionException {
        this.ownerClass = ownerClass;
        this.field = field;
        this.fieldClass = fieldClass;
        if (field.isFinal()) {
            this.collection = field.get(object);
        } else {
            this.collection = fieldClass.isInterface() ? Mdx.reflect.newInstance(this.getFallbackImplementation()) : Mdx.reflect.newInstance(fieldClass);
            field.set(object, this.collection);
        }
    }

    public abstract Class<? extends T> getFallbackImplementation();

    public abstract Class<?> getValueClass();

    public abstract void add(Object var1);

    public static DeserializedCollection getImplementation(Class<?> ownerClass, Field field, Class<?> fieldClass, Object object) throws ReflectionException, NoSuchMethodException {
        if (Mdx.reflect.isAssignableFrom(List.class, fieldClass)) {
            return new ListDeserializedCollection(ownerClass, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(Set.class, fieldClass)) {
            return new SetDeserializedCollection(ownerClass, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(Array.class, fieldClass)) {
            return new GdxDeserializedCollection(ownerClass, Array.class, field.getElementType(0), field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(BooleanArray.class, fieldClass)) {
            return new GdxDeserializedCollection<BooleanArray, Boolean>(ownerClass, BooleanArray.class, Boolean.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(ByteArray.class, fieldClass)) {
            return new GdxDeserializedCollection<ByteArray, Byte>(ownerClass, ByteArray.class, Byte.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(CharArray.class, fieldClass)) {
            return new GdxDeserializedCollection<CharArray, Character>(ownerClass, CharArray.class, Character.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(FloatArray.class, fieldClass)) {
            return new GdxDeserializedCollection<FloatArray, Float>(ownerClass, FloatArray.class, Float.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(IntArray.class, fieldClass)) {
            return new GdxDeserializedCollection<IntArray, Integer>(ownerClass, IntArray.class, Integer.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(IntSet.class, fieldClass)) {
            return new GdxDeserializedCollection<IntSet, Integer>(ownerClass, IntSet.class, Integer.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(LongArray.class, fieldClass)) {
            return new GdxDeserializedCollection<LongArray, Long>(ownerClass, LongArray.class, Long.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(OrderedSet.class, fieldClass)) {
            return new GdxDeserializedCollection(ownerClass, OrderedSet.class, field.getElementType(0), field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(ObjectSet.class, fieldClass)) {
            return new GdxDeserializedCollection(ownerClass, ObjectSet.class, field.getElementType(0), field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(ShortArray.class, fieldClass)) {
            return new GdxDeserializedCollection<ShortArray, Short>(ownerClass, ShortArray.class, Short.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(SortedIntList.class, fieldClass)) {
            return new GdxDeserializedCollection<SortedIntList, Integer>(ownerClass, SortedIntList.class, Integer.class, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(Collection.class, fieldClass)) {
            return new ListDeserializedCollection(ownerClass, field, fieldClass, object);
        }
        return null;
    }
}

