/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.collection;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.aot.AotSerializedFieldData;
import org.mini2Dx.core.serialization.collection.DeserializedCollection;

public class GdxDeserializedCollection<T, N>
extends DeserializedCollection<T> {
    private static final String LOGGING_TAG = GdxDeserializedCollection.class.getSimpleName();
    private final Class<T> fallbackClass;
    private Class<N> valueClass;
    private Method addMethod;

    public GdxDeserializedCollection(Class<?> ownerClass, Class<T> fallbackClass, Class<N> valueClass, Field field, Class<?> fieldClass, Object object) throws ReflectionException, NoSuchMethodException {
        super(ownerClass, field, fieldClass, object);
        this.fallbackClass = fallbackClass;
        this.valueClass = valueClass;
        for (Method method : Mdx.reflect.getMethods(fieldClass)) {
            if (!method.getName().equals("add") || method.getParameterTypes().length != 1) continue;
            this.addMethod = method;
            break;
        }
        if (this.addMethod == null) {
            throw new NoSuchMethodException("No such method add on " + fieldClass.getName());
        }
    }

    @Override
    public Class<? extends T> getFallbackImplementation() {
        return this.fallbackClass;
    }

    @Override
    public Class<?> getValueClass() {
        AotSerializedFieldData aotFieldData;
        if (this.valueClass == null && (aotFieldData = AotSerializationData.getFieldData(this.ownerClass, this.field.getName())) != null) {
            this.valueClass = aotFieldData.getElementType(0);
        }
        return this.valueClass;
    }

    @Override
    public void add(Object element) {
        try {
            this.addMethod.invoke(this.collection, element);
        }
        catch (Exception e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
    }
}

