/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.collection;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.serialization.collection.SerializedCollection;

public class GdxSerializedCollection<T>
extends SerializedCollection<T> {
    private static final String LOGGING_TAG = GdxSerializedCollection.class.getSimpleName();
    private Method getMethod;
    private Field sizeField;

    public GdxSerializedCollection(Class<T> clazz, T collection) throws NoSuchFieldException {
        super(collection);
        for (Method method : Mdx.reflect.getMethods(clazz)) {
            if (!method.getName().equals("get")) continue;
            this.getMethod = method;
            break;
        }
        this.sizeField = Mdx.reflect.getField(clazz, "size");
    }

    @Override
    public Object get(int index) {
        try {
            return this.getMethod.invoke(this.collection, index);
        }
        catch (ReflectionException e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public int getLength() {
        try {
            return (Integer)this.sizeField.get(this.collection);
        }
        catch (ReflectionException e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            return -1;
        }
    }

    @Override
    public void dispose() {
    }
}

