/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.map.deserialize;

import java.util.Map;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.serialization.map.deserialize.GdxDeserializedMap;
import org.mini2Dx.core.serialization.map.deserialize.MapDeserializedMap;
import org.mini2Dx.gdx.utils.ArrayMap;
import org.mini2Dx.gdx.utils.IntFloatMap;
import org.mini2Dx.gdx.utils.IntIntMap;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.gdx.utils.LongMap;
import org.mini2Dx.gdx.utils.ObjectFloatMap;
import org.mini2Dx.gdx.utils.ObjectIntMap;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.utils.OrderedMap;

public abstract class DeserializedMap<T> {
    protected final Class<?> ownerClass;
    protected final Field field;
    protected final Class<?> fieldClass;
    protected final T map;

    public DeserializedMap(Class<?> ownerClass, Field field, Class<?> fieldClass, Object object) throws ReflectionException {
        this.ownerClass = ownerClass;
        this.field = field;
        this.fieldClass = fieldClass;
        if (field.isFinal()) {
            this.map = field.get(object);
        } else {
            this.map = Mdx.reflect.isInterface(fieldClass) ? Mdx.reflect.newInstance(this.getFallbackImplementation()) : Mdx.reflect.newInstance(fieldClass);
            field.set(object, this.map);
        }
    }

    public abstract Class<? extends T> getFallbackImplementation();

    public abstract Class<?> getKeyClass();

    public abstract Class<?> getValueClass();

    public abstract void put(Object var1, Object var2);

    public static DeserializedMap getImplementation(Class<?> ownerClass, Field field, Class<?> fieldClass, Object object) throws ReflectionException {
        if (Mdx.reflect.isAssignableFrom(Map.class, fieldClass)) {
            return new MapDeserializedMap(ownerClass, field, fieldClass, object);
        }
        if (Mdx.reflect.isAssignableFrom(ArrayMap.class, fieldClass)) {
            return new GdxDeserializedMap<ArrayMap>(ownerClass, field, ArrayMap.class, field.getElementType(0), field.getElementType(1), object);
        }
        if (Mdx.reflect.isAssignableFrom(IntMap.class, fieldClass)) {
            return new GdxDeserializedMap<IntMap>(ownerClass, field, IntMap.class, Integer.class, field.getElementType(0), object);
        }
        if (Mdx.reflect.isAssignableFrom(IntFloatMap.class, fieldClass)) {
            return new GdxDeserializedMap<IntFloatMap>(ownerClass, field, IntFloatMap.class, Integer.class, Float.class, object);
        }
        if (Mdx.reflect.isAssignableFrom(IntIntMap.class, fieldClass)) {
            return new GdxDeserializedMap<IntIntMap>(ownerClass, field, IntIntMap.class, Integer.class, Integer.class, object);
        }
        if (Mdx.reflect.isAssignableFrom(LongMap.class, fieldClass)) {
            return new GdxDeserializedMap<LongMap>(ownerClass, field, LongMap.class, Long.class, field.getElementType(0), object);
        }
        if (Mdx.reflect.isAssignableFrom(ObjectFloatMap.class, fieldClass)) {
            return new GdxDeserializedMap<ObjectFloatMap>(ownerClass, field, ObjectFloatMap.class, field.getElementType(0), Float.class, object);
        }
        if (Mdx.reflect.isAssignableFrom(ObjectIntMap.class, fieldClass)) {
            return new GdxDeserializedMap<ObjectIntMap>(ownerClass, field, ObjectIntMap.class, field.getElementType(0), Integer.class, object);
        }
        if (Mdx.reflect.isAssignableFrom(ObjectMap.class, fieldClass)) {
            return new GdxDeserializedMap<ObjectMap>(ownerClass, field, ObjectMap.class, field.getElementType(0), field.getElementType(1), object);
        }
        if (Mdx.reflect.isAssignableFrom(OrderedMap.class, fieldClass)) {
            return new GdxDeserializedMap<OrderedMap>(ownerClass, field, OrderedMap.class, field.getElementType(0), field.getElementType(1), object);
        }
        return null;
    }
}

