/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.map.deserialize;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.aot.AotSerializedFieldData;
import org.mini2Dx.core.serialization.map.deserialize.DeserializedMap;

public class GdxDeserializedMap<T>
extends DeserializedMap<T> {
    private static final String LOGGING_TAG = GdxDeserializedMap.class.getSimpleName();
    private final Class<T> fallbackClass;
    private final Class<?> keyClass;
    private final Class<?> valueClass;
    private Method putMethod;

    public GdxDeserializedMap(Class<?> ownerClass, Field field, Class<T> fieldClass, Class<?> keyClass, Class<?> valueClass, Object object) throws ReflectionException {
        super(ownerClass, field, fieldClass, object);
        this.fallbackClass = fieldClass;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        for (Method method : Mdx.reflect.getMethods(fieldClass)) {
            if (!method.getName().equals("put") || method.getParameterTypes().length != 2) continue;
            this.putMethod = method;
            break;
        }
    }

    @Override
    public Class<? extends T> getFallbackImplementation() {
        return this.fallbackClass;
    }

    @Override
    public Class<?> getKeyClass() {
        AotSerializedFieldData aotFieldData;
        if (this.keyClass == null && (aotFieldData = AotSerializationData.getFieldData(this.ownerClass, this.field.getName())) != null) {
            return aotFieldData.getElementType(0);
        }
        return this.keyClass;
    }

    @Override
    public Class<?> getValueClass() {
        AotSerializedFieldData aotFieldData;
        if (this.valueClass == null && (aotFieldData = AotSerializationData.getFieldData(this.ownerClass, this.field.getName())) != null) {
            return aotFieldData.getElementType(1);
        }
        return this.valueClass;
    }

    @Override
    public void put(Object key, Object value) {
        try {
            this.putMethod.invoke(this.map, key, value);
        }
        catch (ReflectionException e) {
            Mdx.log.error(LOGGING_TAG, this.fieldClass + " (fallback:" + this.fallbackClass + ") - " + e.getMessage(), e);
        }
    }
}

