/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.util.Interpolatable;
import org.mini2Dx.gdx.utils.ObjectIntMap;
import org.mini2Dx.gdx.utils.OrderedSet;

public class InterpolationTracker {
    private static final String LOGGING_TAG = InterpolationTracker.class.getSimpleName();
    public static int INITIAL_SIZE = 512;
    private static OrderedSet<Interpolatable> INTERPOLATABLES = null;
    private static ObjectIntMap<String> CLASS_COUNT = null;

    private static void init() {
        if (INTERPOLATABLES != null) {
            return;
        }
        CLASS_COUNT = new ObjectIntMap();
        INTERPOLATABLES = new OrderedSet(INITIAL_SIZE);
    }

    public static void preUpdate() {
        InterpolationTracker.init();
        for (Interpolatable interpolatable : INTERPOLATABLES.orderedItems()) {
            interpolatable.preUpdate();
        }
    }

    public static void interpolate(float alpha) {
        InterpolationTracker.init();
        for (Interpolatable interpolatable : INTERPOLATABLES.orderedItems()) {
            interpolatable.interpolate(alpha);
        }
    }

    public static synchronized boolean isRegistered(Interpolatable interpolatable) {
        InterpolationTracker.init();
        if (INTERPOLATABLES.contains((Object)interpolatable)) {
            Interpolatable existingKey = (Interpolatable)INTERPOLATABLES.get((Object)interpolatable);
            return interpolatable == existingKey;
        }
        return false;
    }

    public static synchronized boolean register(Interpolatable interpolatable) {
        InterpolationTracker.init();
        int size = InterpolationTracker.INTERPOLATABLES.size;
        Interpolatable existingKey = (Interpolatable)INTERPOLATABLES.get((Object)interpolatable);
        if (!INTERPOLATABLES.add((Object)interpolatable)) {
            if (Mdx.log != null) {
                Mdx.log.info(LOGGING_TAG, "WARN: " + interpolatable.toString() + " was not registered for interpolation. This may be due to duplicate collision IDs.");
            }
            return false;
        }
        if (existingKey != interpolatable && size == InterpolationTracker.INTERPOLATABLES.size && Mdx.log != null) {
            Mdx.log.info(LOGGING_TAG, "WARN: " + interpolatable.toString() + " replaced an existing object with same ID. The previous object may not be interpolated correctly.");
        }
        return true;
    }

    public static synchronized void deregister(Interpolatable interpolatable) {
        InterpolationTracker.init();
        INTERPOLATABLES.remove((Object)interpolatable);
    }

    public static synchronized void deregisterAll() {
        InterpolationTracker.init();
        INTERPOLATABLES.clear();
    }

    public static synchronized int getTotalObjects() {
        InterpolationTracker.init();
        return InterpolationTracker.INTERPOLATABLES.size;
    }

    public static synchronized String toDebugString() {
        InterpolationTracker.init();
        CLASS_COUNT.clear();
        for (Interpolatable interpolatable : INTERPOLATABLES.orderedItems()) {
            String key = interpolatable.getClass().getSimpleName();
            CLASS_COUNT.getAndIncrement((Object)key, 0, 1);
        }
        StringBuilder result = new StringBuilder();
        result.append(InterpolationTracker.class.getSimpleName() + " {\n");
        result.append("size: ");
        result.append(InterpolationTracker.getTotalObjects());
        result.append(", \nclasses: {\n");
        for (String key : CLASS_COUNT.keys()) {
            result.append(key);
            result.append(':');
            result.append(' ');
            result.append(CLASS_COUNT.get((Object)key, 0));
            result.append('\n');
        }
        result.append("}\n}");
        return result.toString();
    }
}

