/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import org.mini2Dx.gdx.math.MathUtils;

public class Lerper {
    public static Mode MODE = Mode.MONOTONIC;

    public static float lerp(float from, float to, float alpha) {
        switch (MODE) {
            case PRECISE: {
                return Lerper.lerp3(from, to, alpha);
            }
            case BOUNDLESS: {
                return Lerper.lerp0(from, to, alpha);
            }
            case MONOTONIC: {
                return Lerper.lerp2(from, to, alpha);
            }
        }
        return Lerper.lerp1(from, to, alpha);
    }

    static float lerp0(float from, float to, float alpha) {
        float inverseAlpha = 1.0f - alpha;
        return from * inverseAlpha + to * alpha;
    }

    static float lerp1(float from, float to, float alpha) {
        float inverseAlpha = 1.0f - alpha;
        return MathUtils.clamp((float)(from * inverseAlpha + to * alpha), (float)from, (float)to);
    }

    static float lerp2(float from, float to, float alpha) {
        return from + alpha * (to - from);
    }

    static float lerp3(float from, float to, float alpha) {
        if (from <= 0.0f && to >= 0.0f || from >= 0.0f && to <= 0.0f) {
            return alpha * to + (1.0f - alpha) * from;
        }
        if (alpha == 1.0f) {
            return to;
        }
        float x = from + alpha * (to - from);
        return alpha > 1.0f == to > from ? Math.max(to, x) : Math.min(to, x);
    }

    public static enum Mode {
        BOUNDLESS,
        CLAMP,
        MONOTONIC,
        PRECISE;

    }
}

