/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import org.mini2Dx.core.collections.LongQueue;

public class RollingAverage {
    private final LongQueue queue = new LongQueue();
    private int size;
    private double average;

    public RollingAverage(int size) {
        this.size = size;
    }

    public void mark(long value) {
        if (this.queue.size < this.size) {
            this.queue.addLast(value);
            long sum = 0L;
            for (int i = 0; i < this.queue.size; ++i) {
                sum += this.queue.get(i);
            }
            this.average = (double)sum / (double)this.queue.size;
        } else {
            long head = this.queue.removeFirst();
            double minus = (double)head / (double)this.size;
            this.queue.addLast(value);
            double add = (double)value / (double)this.size;
            this.average = this.average + add - minus;
        }
    }

    public double getAverage() {
        return this.average;
    }
}

