/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import org.mini2Dx.core.util.PowerOfTwo;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;

public enum Scaling {
    NONE,
    FIT,
    FILL,
    FILL_X,
    FILL_Y,
    STRETCH;


    public void apply(Vector2 sizeResult, Vector2 scaleResult, boolean powerOfTwo, float sourceWidth, float sourceHeight, float targetWidth, float targetHeight) {
        switch (this) {
            case FIT: {
                float scale;
                float targetRatio = targetHeight / targetWidth;
                float sourceRatio = sourceHeight / sourceWidth;
                float f = scale = targetRatio > sourceRatio ? targetWidth / sourceWidth : targetHeight / sourceHeight;
                if (powerOfTwo) {
                    scale = PowerOfTwo.previousPowerOfTwo(MathUtils.floor((float)scale));
                }
                sizeResult.set(sourceWidth * scale, sourceHeight * scale);
                scaleResult.set(scale, scale);
                break;
            }
            case FILL: {
                float scale;
                float targetRatio = targetHeight / targetWidth;
                float sourceRatio = sourceHeight / sourceWidth;
                float f = scale = targetRatio < sourceRatio ? targetWidth / sourceWidth : targetHeight / sourceHeight;
                if (powerOfTwo) {
                    scale = PowerOfTwo.previousPowerOfTwo(MathUtils.ceil((float)scale));
                }
                sizeResult.set(sourceWidth * scale, sourceHeight * scale);
                scaleResult.set(scale, scale);
                break;
            }
            case FILL_X: {
                float scale = targetWidth / sourceWidth;
                if (powerOfTwo) {
                    scale = PowerOfTwo.previousPowerOfTwo(MathUtils.ceil((float)scale));
                }
                sizeResult.set(sourceWidth * scale, sourceHeight * scale);
                scaleResult.set(scale, scale);
                break;
            }
            case FILL_Y: {
                float scale = targetHeight / sourceHeight;
                if (powerOfTwo) {
                    scale = PowerOfTwo.previousPowerOfTwo(MathUtils.ceil((float)scale));
                }
                sizeResult.set(sourceWidth * scale, sourceHeight * scale);
                scaleResult.set(scale, scale);
                break;
            }
            case STRETCH: {
                float scaleX = targetWidth / sourceWidth;
                float scaleY = targetHeight / sourceHeight;
                if (powerOfTwo) {
                    scaleX = PowerOfTwo.previousPowerOfTwo(MathUtils.ceil((float)scaleX));
                    scaleY = PowerOfTwo.previousPowerOfTwo(MathUtils.ceil((float)scaleY));
                }
                sizeResult.set(targetWidth, targetHeight);
                scaleResult.set(scaleX, scaleY);
                break;
            }
            default: {
                sizeResult.set(sourceWidth, sourceHeight);
                scaleResult.set(1.0f, 1.0f);
            }
        }
    }

    private boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }
}

