/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import java.io.IOException;
import java.io.InputStream;
import org.mini2Dx.core.util.ZlibStream;

public class ZlibInputStream
extends InputStream {
    private final ZlibStream zlibStream;
    private final byte[] buffer = new byte[2048];
    private int bufferLength = this.buffer.length;
    private int bufferIndex = this.buffer.length;

    public ZlibInputStream(ZlibStream zlibStream) {
        this.zlibStream = zlibStream;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferLength == 0) {
            return -1;
        }
        if (!this.fillBuffer()) {
            return -1;
        }
        return this.buffer[this.bufferIndex++] & 0xFF;
    }

    private boolean fillBuffer() {
        if (this.bufferIndex < this.bufferLength) {
            return true;
        }
        this.bufferLength = this.zlibStream.read(this.buffer);
        if (this.bufferLength == 0) {
            return false;
        }
        this.bufferIndex = 0;
        return true;
    }
}

