/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.utils.Queue;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledLayerParserListener;
import org.mini2Dx.tiled.TiledMapData;
import org.mini2Dx.tiled.TiledObjectGroup;

public class GroupLayer
extends Layer
implements TiledLayerParserListener {
    private static final int INITIAL_POOL_SIZE = 4096;
    private static final Queue<GroupLayer> POOL = new Queue(4096);
    protected final Array<Layer> layers = new Array(true, 2, Layer.class);
    protected final ObjectMap<String, TiledObjectGroup> objectGroups = new ObjectMap();

    private GroupLayer() {
        super(LayerType.GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GroupLayer create() {
        GroupLayer result;
        Queue<GroupLayer> queue = POOL;
        synchronized (queue) {
            result = GroupLayer.POOL.size == 0 ? new GroupLayer() : (GroupLayer)POOL.removeFirst();
        }
        return result;
    }

    public static GroupLayer fromInputStream(DataInputStream inputStream) throws IOException {
        GroupLayer result = GroupLayer.create();
        result.readData(inputStream);
        return result;
    }

    @Override
    public void writeData(DataOutputStream outputStream) throws IOException {
        super.writeData(outputStream);
        outputStream.writeInt(this.layers.size);
        for (int i = 0; i < this.layers.size; ++i) {
            ((Layer)this.layers.get(i)).writeData(outputStream);
        }
    }

    @Override
    public void readData(DataInputStream inputStream) throws IOException {
        super.readData(inputStream);
        int totalLayers = inputStream.readInt();
        block5: for (int i = 0; i < totalLayers; ++i) {
            Layer layer = Layer.fromInputStream(inputStream);
            switch (layer.getLayerType()) {
                default: {
                    this.onTileLayerParsed((TileLayer)layer);
                    continue block5;
                }
                case OBJECT: {
                    this.onObjectGroupParsed((TiledObjectGroup)layer);
                    continue block5;
                }
                case IMAGE: {
                    continue block5;
                }
                case GROUP: {
                    this.onGroupLayerParsed((GroupLayer)layer);
                }
            }
        }
    }

    public TileLayer getTileLayer(String name) {
        return this.getTileLayer(name, true);
    }

    public TileLayer getTileLayer(String name, boolean recursive) {
        return TiledMapData.getTileLayer(this.layers, name, recursive);
    }

    public GroupLayer getGroupLayer(String name) {
        return this.getGroupLayer(name, true);
    }

    public GroupLayer getGroupLayer(String name, boolean recursive) {
        return TiledMapData.getGroupLayer(this.layers, name, recursive);
    }

    public TiledObjectGroup getObjectGroup(String name) {
        return this.getObjectGroup(name, true);
    }

    public TiledObjectGroup getObjectGroup(String name, boolean recursive) {
        return TiledMapData.getObjectGroup(this.layers, this.objectGroups, name, recursive);
    }

    public TileLayer getTileLayer(int index) {
        if (index < 0 || index >= this.layers.size) {
            return null;
        }
        return (TileLayer)this.layers.get(index);
    }

    public GroupLayer getGroupLayer(int index) {
        if (index < 0 || index >= this.layers.size) {
            return null;
        }
        return (GroupLayer)this.layers.get(index);
    }

    @Override
    public void onTileLayerParsed(TileLayer parsedLayer) {
        parsedLayer.setIndex(this.layers.size);
        this.layers.add((Object)parsedLayer);
    }

    @Override
    public void onObjectGroupParsed(TiledObjectGroup parsedObjectGroup) {
        parsedObjectGroup.setIndex(this.layers.size);
        this.layers.add((Object)parsedObjectGroup);
        this.objectGroups.put((Object)parsedObjectGroup.getName(), (Object)parsedObjectGroup);
    }

    @Override
    public void onGroupLayerParsed(GroupLayer parsedLayer) {
        parsedLayer.setIndex(this.layers.size);
        this.layers.add((Object)parsedLayer);
    }

    public Array<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupLayer that = (GroupLayer)o;
        return Objects.equals(this.layers, that.layers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.layers);
    }

    @Override
    public String toString() {
        return "GroupLayer{layers=" + this.layers + "} " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        for (int i = 0; i < this.layers.size; ++i) {
            ((Layer)this.layers.get(i)).dispose();
        }
        this.layers.clear();
        this.objectGroups.clear();
        Queue<GroupLayer> queue = POOL;
        synchronized (queue) {
            POOL.addLast((Object)this);
        }
    }

    static {
        for (int i = 0; i < 4096; ++i) {
            POOL.addLast((Object)new GroupLayer());
        }
    }
}

