/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.serialization.GameDataSerializable;
import org.mini2Dx.core.serialization.GameDataSerializableUtils;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.GroupLayer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledObjectGroup;

public abstract class Layer
implements Disposable,
GameDataSerializable {
    public static int DEFAULT_PROPERTY_MAP_SIZE = 16;
    private final LayerType layerType;
    private String name;
    private int index;
    private ObjectMap<String, String> properties;
    private boolean visible;

    public Layer(LayerType layerType) {
        this.layerType = layerType;
    }

    public static Layer fromInputStream(DataInputStream inputStream) throws IOException {
        LayerType layerType = LayerType.valueOf(inputStream.readUTF());
        switch (layerType) {
            default: {
                return TileLayer.fromInputStream(inputStream);
            }
            case OBJECT: {
                return TiledObjectGroup.fromInputStream(inputStream);
            }
            case IMAGE: {
                return null;
            }
            case GROUP: 
        }
        return GroupLayer.fromInputStream(inputStream);
    }

    public void dispose() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this.layerType.name());
        GameDataSerializableUtils.writeString((String)this.name, (DataOutputStream)outputStream);
        outputStream.writeInt(this.index);
        outputStream.writeBoolean(this.visible);
        outputStream.writeInt(this.properties == null ? 0 : this.properties.size);
        if (this.properties != null) {
            for (String key : this.properties.keys()) {
                outputStream.writeUTF(key);
                GameDataSerializableUtils.writeString((String)((String)this.properties.get((Object)key, null)), (DataOutputStream)outputStream);
            }
        }
    }

    public void readData(DataInputStream inputStream) throws IOException {
        this.name = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        this.index = inputStream.readInt();
        this.visible = inputStream.readBoolean();
        int totalProperties = inputStream.readInt();
        if (totalProperties > 0) {
            if (this.properties == null) {
                this.properties = new ObjectMap(DEFAULT_PROPERTY_MAP_SIZE);
            }
            for (int i = 0; i < totalProperties; ++i) {
                String key = inputStream.readUTF();
                String value = GameDataSerializableUtils.readString((DataInputStream)inputStream);
                this.properties.put((Object)key, (Object)value);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey((Object)propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new ObjectMap(DEFAULT_PROPERTY_MAP_SIZE);
        }
        this.properties.put((Object)propertyName, (Object)value);
    }

    public ObjectMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public LayerType getLayerType() {
        return this.layerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Layer layer = (Layer)o;
        return this.index == layer.index && this.visible == layer.visible && this.layerType == layer.layerType && Objects.equals(this.name, layer.name) && Objects.equals(this.properties, layer.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.layerType, this.name, this.index, this.properties, this.visible});
    }

    public String toString() {
        return "Layer{layerType=" + (Object)((Object)this.layerType) + ", name='" + this.name + '\'' + ", index=" + this.index + ", properties=" + this.properties + ", visible=" + this.visible + '}';
    }
}

