/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.serialization.GameDataSerializable;
import org.mini2Dx.core.serialization.GameDataSerializableUtils;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.utils.Queue;
import org.mini2Dx.tiled.renderer.TileRenderer;

public class Tile
implements GameDataSerializable,
Disposable {
    public static int DEFAULT_PROPERTY_MAP_SIZE = 8;
    private static final int INITIAL_POOL_SIZE = 16384;
    private static final Queue<Tile> POOL = new Queue(16384);
    private int tileId;
    private TileRenderer tileRenderer;
    private ObjectMap<String, String> properties;

    private Tile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tile create() {
        Tile tile;
        Queue<Tile> queue = POOL;
        synchronized (queue) {
            tile = Tile.POOL.size == 0 ? new Tile() : (Tile)POOL.removeFirst();
        }
        return tile;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.tileId);
        outputStream.writeInt(this.properties == null ? 0 : this.properties.size);
        if (this.properties != null) {
            for (String key : this.properties.keys()) {
                outputStream.writeUTF(key);
                GameDataSerializableUtils.writeString((String)((String)this.properties.get((Object)key, null)), (DataOutputStream)outputStream);
            }
        }
    }

    public void readData(DataInputStream inputStream) throws IOException {
        this.tileId = inputStream.readInt();
        int totalProperties = inputStream.readInt();
        if (totalProperties > 0) {
            if (this.properties == null) {
                this.properties = new ObjectMap(DEFAULT_PROPERTY_MAP_SIZE);
            }
            for (int i = 0; i < totalProperties; ++i) {
                String key = inputStream.readUTF();
                String value = GameDataSerializableUtils.readString((DataInputStream)inputStream);
                this.properties.put((Object)key, (Object)value);
            }
        }
    }

    public void update(float delta) {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.update(this, delta);
    }

    public void draw(Graphics g, int renderX, int renderY, float alpha, boolean flipH, boolean flipV, boolean flipD) {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.draw(g, this, renderX, renderY, alpha, flipH, flipV, flipD);
    }

    public void draw(Graphics g, int renderX, int renderY, float alpha) {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.draw(g, this, renderX, renderY, alpha);
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey((Object)propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new ObjectMap(DEFAULT_PROPERTY_MAP_SIZE);
        }
        this.properties.put((Object)propertyName, (Object)value);
    }

    public ObjectMap<String, String> getProperties() {
        return this.properties;
    }

    @Deprecated
    public int getTileId() {
        return this.getTileId(0);
    }

    public int getTileId(int firstGid) {
        return firstGid + this.tileId;
    }

    public void setTileId(int tileId) {
        this.tileId = tileId;
    }

    public TileRenderer getTileRenderer() {
        return this.tileRenderer;
    }

    public void setTileRenderer(TileRenderer tileRenderer) {
        this.tileRenderer = tileRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.tileId = 0;
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.tileRenderer != null) {
            this.tileRenderer.dispose();
            this.tileRenderer = null;
        }
        Queue<Tile> queue = POOL;
        synchronized (queue) {
            POOL.addLast((Object)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tile tile = (Tile)o;
        return this.tileId == tile.tileId && Objects.equals(this.tileRenderer, tile.tileRenderer) && Objects.equals(this.properties, tile.properties);
    }

    public int hashCode() {
        return Objects.hash(this.tileId, this.tileRenderer, this.properties);
    }

    public String toString() {
        return "Tile{tileId=" + this.tileId + ", tileRenderer=" + this.tileRenderer + ", properties=" + this.properties + '}';
    }

    static {
        for (int i = 0; i < 16384; ++i) {
            POOL.addLast((Object)new Tile());
        }
    }
}

