/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.mini2Dx.core.serialization.GameDataSerializableUtils;
import org.mini2Dx.gdx.utils.Queue;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.TiledMap;

public class TileLayer
extends Layer {
    private static final int INITIAL_POOL_SIZE = 4096;
    private static final Queue<TileLayer> POOL = new Queue(4096);
    private int[][] tiles;
    private BitSet flipHorizontally;
    private BitSet flipVertically;
    private BitSet flipDiagonally;

    private TileLayer() {
        super(LayerType.TILE);
    }

    private void resize(int width, int height) {
        this.tiles = new int[width][height];
        this.flipHorizontally = new BitSet(width * height);
        this.flipVertically = new BitSet(width * height);
        this.flipDiagonally = new BitSet(width * height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TileLayer create() {
        TileLayer result;
        Queue<TileLayer> queue = POOL;
        synchronized (queue) {
            result = TileLayer.POOL.size == 0 ? new TileLayer() : (TileLayer)POOL.removeFirst();
        }
        return result;
    }

    public static TileLayer create(int width, int height) {
        TileLayer result = TileLayer.create();
        result.resize(width, height);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TileLayer fromInputStream(DataInputStream inputStream) throws IOException {
        TileLayer result;
        Queue<TileLayer> queue = POOL;
        synchronized (queue) {
            result = TileLayer.POOL.size == 0 ? new TileLayer() : (TileLayer)POOL.removeFirst();
        }
        result.readData(inputStream);
        return result;
    }

    @Override
    public void writeData(DataOutputStream outputStream) throws IOException {
        super.writeData(outputStream);
        outputStream.writeInt(this.getWidth());
        outputStream.writeInt(this.getHeight());
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                outputStream.writeInt(this.tiles[x][y]);
            }
        }
        GameDataSerializableUtils.writeArray((long[])this.flipHorizontally.toLongArray(), (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeArray((long[])this.flipVertically.toLongArray(), (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeArray((long[])this.flipDiagonally.toLongArray(), (DataOutputStream)outputStream);
    }

    @Override
    public void readData(DataInputStream inputStream) throws IOException {
        super.readData(inputStream);
        int width = inputStream.readInt();
        int height = inputStream.readInt();
        if (this.tiles == null || this.tiles.length != width || this.tiles[0].length != height) {
            this.tiles = new int[width][height];
        }
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                this.tiles[x][y] = inputStream.readInt();
            }
        }
        this.flipHorizontally = BitSet.valueOf(GameDataSerializableUtils.readArray((DataInputStream)inputStream));
        this.flipVertically = BitSet.valueOf(GameDataSerializableUtils.readArray((DataInputStream)inputStream));
        this.flipDiagonally = BitSet.valueOf(GameDataSerializableUtils.readArray((DataInputStream)inputStream));
    }

    public int getTileId(int x, int y) {
        return this.tiles[x][y];
    }

    public void setTileId(int x, int y, int id) {
        this.tiles[x][y] = id;
    }

    public void setTileId(int x, int y, int id, boolean flipH, boolean flipV, boolean flipD) {
        this.tiles[x][y] = id;
        this.setFlippedHorizontally(x, y, flipH);
        this.setFlippedVertically(x, y, flipV);
        this.setFlippedDiagonally(x, y, flipD);
    }

    public boolean isFlippedHorizontally(int x, int y) {
        return this.flipHorizontally.get(this.getBitIndex(x, y));
    }

    public void setFlippedHorizontally(int x, int y, boolean flip) {
        this.flipHorizontally.set(this.getBitIndex(x, y), flip);
    }

    public boolean isFlippedVertically(int x, int y) {
        return this.flipVertically.get(this.getBitIndex(x, y));
    }

    public void setFlippedVertically(int x, int y, boolean flip) {
        this.flipVertically.set(this.getBitIndex(x, y), flip);
    }

    public boolean isFlippedDiagonally(int x, int y) {
        return this.flipDiagonally.get(this.getBitIndex(x, y));
    }

    public void setFlippedDiagonally(int x, int y, boolean flip) {
        this.flipDiagonally.set(this.getBitIndex(x, y), flip);
    }

    public int getWidth() {
        return this.tiles.length;
    }

    public int getHeight() {
        return this.tiles[0].length;
    }

    private int getBitIndex(int x, int y) {
        return y * this.tiles.length + x;
    }

    public boolean isMostlyEmptyTiles() {
        return (float)this.getTotalEmptyTiles() * 1.0f / ((float)(this.getWidth() * this.getHeight()) * 1.0f) >= TiledMap.FAST_RENDER_EMPTY_LAYERS_THRESHOLD;
    }

    public int getTotalEmptyTiles() {
        int result = 0;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.getTileId(x, y) >= 1) continue;
                ++result;
            }
        }
        return result;
    }

    public int getTotalFilledTiles() {
        int result = 0;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.getTileId(x, y) < 1) continue;
                ++result;
            }
        }
        return result;
    }

    public boolean isTileUsed(int tileId) {
        if (tileId < 1) {
            return false;
        }
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.getTileId(x, y) != tileId) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        this.flipHorizontally.clear();
        this.flipVertically.clear();
        this.flipDiagonally.clear();
        Queue<TileLayer> queue = POOL;
        synchronized (queue) {
            POOL.addLast((Object)this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TileLayer tileLayer = (TileLayer)o;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.tiles[x][y] == tileLayer.tiles[x][y]) continue;
                return false;
            }
        }
        return Objects.equals(this.flipHorizontally, tileLayer.flipHorizontally) && Objects.equals(this.flipVertically, tileLayer.flipVertically) && Objects.equals(this.flipDiagonally, tileLayer.flipDiagonally);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.flipHorizontally, this.flipVertically, this.flipDiagonally);
        result = 31 * result + Arrays.hashCode((Object[])this.tiles);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder tilesStr = new StringBuilder();
        tilesStr.append("[");
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                tilesStr.append(this.tiles[x][y]);
                tilesStr.append(' ');
            }
        }
        tilesStr.append("]");
        return "TileLayer{tiles=" + tilesStr.toString() + ", flipHorizontally=" + this.flipHorizontally + ", flipVertically=" + this.flipVertically + ", flipDiagonally=" + this.flipDiagonally + "} " + super.toString();
    }

    static {
        for (int i = 0; i < 4096; ++i) {
            POOL.addLast((Object)new TileLayer());
        }
    }
}

