/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.tiled.GroupLayer;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.Orientation;
import org.mini2Dx.tiled.StaggerAxis;
import org.mini2Dx.tiled.StaggerIndex;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMapData;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.TiledParser;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.exception.UnsupportedOrientationException;
import org.mini2Dx.tiled.renderer.HexagonalTileLayerRenderer;
import org.mini2Dx.tiled.renderer.IsometricTileLayerRenderer;
import org.mini2Dx.tiled.renderer.OrthogonalTileLayerRenderer;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;
import org.mini2Dx.tiled.renderer.TiledObjectGroupRenderer;

public class TiledMap {
    private static int INITIAL_TILE_ID_TO_TILESET_MAP_SIZE = 1024;
    public static boolean STRICT_LAYER_VISIBILITY = false;
    public static boolean FAST_RENDER_EMPTY_LAYERS = false;
    public static float FAST_RENDER_EMPTY_LAYERS_THRESHOLD = 0.8f;
    public static boolean CLIP_TILES_OUTSIDE_GRAPHICS_VIEWPORT = false;
    public static boolean SHARED_TILE_ID_MAP = false;
    public static boolean OPTIMISE_ANIMATED_TILES = false;
    private static final IntMap<Tileset> GLOBAL_TILE_ID_TO_TILESET = new IntMap(INITIAL_TILE_ID_TO_TILESET_MAP_SIZE);
    private final TiledMapData tiledMapData;
    private final IntMap<Tileset> tileIdToTileset;
    private TileLayerRenderer tileLayerRenderer;
    private TiledObjectGroupRenderer tiledObjectGroupRenderer;

    public TiledMap(FileHandle fileHandle) {
        this(fileHandle, true);
    }

    public TiledMap(FileHandle fileHandle, boolean loadTilesetTextures) {
        this(new TiledParser(), fileHandle, loadTilesetTextures);
    }

    public TiledMap(TiledParser parser, FileHandle fileHandle, boolean loadTilesetTextures) {
        this(new TiledMapData(parser, fileHandle), loadTilesetTextures);
    }

    public TiledMap(TiledMapData tiledMapData, boolean loadTilesetTextures) {
        this.tiledMapData = tiledMapData;
        IntMap intMap = this.tileIdToTileset = SHARED_TILE_ID_MAP ? GLOBAL_TILE_ID_TO_TILESET : new IntMap(INITIAL_TILE_ID_TO_TILESET_MAP_SIZE);
        if (loadTilesetTextures) {
            this.loadTilesetTextures();
        }
        switch (tiledMapData.getOrientation()) {
            case ORTHOGONAL: {
                this.tileLayerRenderer = new OrthogonalTileLayerRenderer(this, this.tileIdToTileset);
                break;
            }
            case ISOMETRIC: {
                this.tileLayerRenderer = new IsometricTileLayerRenderer(this, this.tileIdToTileset);
                break;
            }
            case ISOMETRIC_STAGGERED: {
                break;
            }
            case HEXAGONAL: {
                this.tileLayerRenderer = new HexagonalTileLayerRenderer(this, this.tileIdToTileset);
                break;
            }
            default: {
                throw new UnsupportedOrientationException(tiledMapData.getOrientation().name());
            }
        }
    }

    public boolean isTilesetTexturesLoaded() {
        return this.tiledMapData.isTilesetTexturesLoaded();
    }

    public boolean isTilesetTexturesLoaded(boolean ignoreObjectTemplateTilesets) {
        return this.tiledMapData.isTilesetTexturesLoaded(ignoreObjectTemplateTilesets);
    }

    public boolean loadTilesetTextures() {
        return this.tiledMapData.loadTilesetTextures();
    }

    public boolean loadTilesetTextures(AssetManager assetManager) {
        return this.tiledMapData.loadTilesetTextures(assetManager);
    }

    public boolean loadTilesetTextures(TextureAtlas textureAtlas) {
        return this.tiledMapData.loadTilesetTextures(textureAtlas);
    }

    public boolean loadTilesetTextures(boolean loadObjectTemplateTilesets) {
        return this.tiledMapData.loadTilesetTextures(loadObjectTemplateTilesets);
    }

    public boolean loadTilesetTextures(AssetManager assetManager, boolean loadObjectTemplateTilesets) {
        return this.tiledMapData.loadTilesetTextures(assetManager, loadObjectTemplateTilesets);
    }

    public boolean loadTilesetTextures(TextureAtlas textureAtlas, boolean loadObjectTemplateTilesets) {
        return this.tiledMapData.loadTilesetTextures(textureAtlas, loadObjectTemplateTilesets);
    }

    public void update(float delta) {
        if (this.tiledMapData.getAnimatedTiles() == null) {
            return;
        }
        for (int i = 0; i < this.tiledMapData.getAnimatedTiles().size; ++i) {
            ((Tile)this.tiledMapData.getAnimatedTiles().get(i)).update(delta);
        }
    }

    public void draw(Graphics g, int x, int y) {
        this.draw(g, x, y, 0, 0, this.tiledMapData.getWidth(), this.tiledMapData.getHeight());
    }

    public void draw(Graphics g, int x, int y, int layer) {
        this.draw(g, x, y, 0, 0, this.tiledMapData.getWidth(), this.tiledMapData.getHeight(), layer);
    }

    public void draw(Graphics g, int x, int y, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        for (int i = 0; i < this.tiledMapData.getTotalLayers(); ++i) {
            this.draw(g, x, y, startTileX, startTileY, widthInTiles, heightInTiles, i);
        }
    }

    public void draw(Graphics g, int x, int y, int startTileX, int startTileY, int widthInTiles, int heightInTiles, int layer) {
        this.draw(g, x, y, startTileX, startTileY, widthInTiles, heightInTiles, layer, 1.0f);
    }

    public void draw(Graphics g, int x, int y, int startTileX, int startTileY, int widthInTiles, int heightInTiles, int layer, float alpha) {
        Layer tiledLayer = (Layer)this.tiledMapData.getLayers().get(layer);
        this.drawLayer(g, tiledLayer, x, y, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
    }

    private void drawLayer(Graphics g, Layer tiledLayer, int x, int y, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        switch (tiledLayer.getLayerType()) {
            case IMAGE: {
                break;
            }
            case OBJECT: {
                this.drawTiledObjectGroup(g, (TiledObjectGroup)tiledLayer, x, y, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
                break;
            }
            case TILE: {
                this.drawTileLayer(g, (TileLayer)tiledLayer, x, y, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
                break;
            }
            case GROUP: {
                this.drawGroupLayer(g, (GroupLayer)tiledLayer, x, y, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
                break;
            }
        }
    }

    protected boolean preTileLayerRendered(Graphics g, TileLayer layer, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        return true;
    }

    protected void onTileLayerRendered(Graphics g, TileLayer layer, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
    }

    protected boolean preGroupLayerRendered(Graphics g, GroupLayer layer, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        return true;
    }

    protected void onGroupLayerRendered(Graphics g, GroupLayer layer, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
    }

    public void drawTileLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        if (!this.isTilesetTexturesLoaded(true)) {
            Mdx.log.error(TiledMap.class.getSimpleName(), "Attempting to render TiledMap without its tilesets loaded");
            return;
        }
        if (STRICT_LAYER_VISIBILITY && !layer.isVisible()) {
            return;
        }
        if (!this.preTileLayerRendered(g, layer, startTileX, startTileY, widthInTiles, heightInTiles)) {
            return;
        }
        this.tileLayerRenderer.drawLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
        this.onTileLayerRendered(g, layer, startTileX, startTileY, widthInTiles, heightInTiles);
    }

    private void drawTiledObjectGroup(Graphics g, TiledObjectGroup objectGroup, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        if (this.tiledObjectGroupRenderer == null) {
            return;
        }
        this.tiledObjectGroupRenderer.drawObjectGroup(g, objectGroup, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
    }

    public void drawGroupLayer(Graphics g, GroupLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        if (!this.isTilesetTexturesLoaded(true)) {
            Mdx.log.error(TiledMap.class.getSimpleName(), "Attempting to render TiledMap without its tilesets loaded");
            return;
        }
        if (STRICT_LAYER_VISIBILITY && !layer.isVisible()) {
            return;
        }
        if (!this.preGroupLayerRendered(g, layer, startTileX, startTileY, widthInTiles, heightInTiles)) {
            return;
        }
        for (Layer childLayer : layer.layers) {
            this.drawLayer(g, childLayer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
        }
        this.onGroupLayerRendered(g, layer, startTileX, startTileY, widthInTiles, heightInTiles);
    }

    public boolean containsProperty(String propertyName) {
        return this.tiledMapData.containsProperty(propertyName);
    }

    public String getProperty(String propertyName) {
        return this.tiledMapData.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        this.tiledMapData.setProperty(propertyName, value);
    }

    public TileLayer getTileLayer(String name) {
        return this.tiledMapData.getTileLayer(name);
    }

    public TileLayer getTileLayer(String name, boolean recursive) {
        return this.tiledMapData.getTileLayer(name, recursive);
    }

    public TileLayer getTileLayer(int index) {
        return this.tiledMapData.getTileLayer(index);
    }

    public GroupLayer getGroupLayer(String name) {
        return this.tiledMapData.getGroupLayer(name);
    }

    public GroupLayer getGroupLayer(String name, boolean recursive) {
        return this.tiledMapData.getGroupLayer(name, recursive);
    }

    public GroupLayer getGroupLayer(int index) {
        return this.tiledMapData.getGroupLayer(index);
    }

    public TiledObjectGroup getObjectGroup(String name) {
        return this.tiledMapData.getObjectGroup(name);
    }

    public TiledObjectGroup getObjectGroup(String name, boolean recursive) {
        return this.tiledMapData.getObjectGroup(name, recursive);
    }

    public Iterable<TiledObjectGroup> getObjectGroups() {
        return this.tiledMapData.getObjectGroups();
    }

    public int getLayerIndex(String name) {
        return this.tiledMapData.getLayerIndex(name);
    }

    public int getLayerIndexIgnoreCase(String name) {
        return this.tiledMapData.getLayerIndexIgnoreCase(name);
    }

    public Tile getTile(int tileId) {
        return this.tiledMapData.getTile(tileId);
    }

    public Tile getTile(int x, int y, int layer) {
        return this.tiledMapData.getTile(x, y, layer);
    }

    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean disposeTilesets) {
        if (this.tileLayerRenderer != null) {
            this.tileLayerRenderer.dispose();
        }
        this.tiledMapData.dispose(disposeTilesets);
    }

    public Orientation getOrientation() {
        return this.tiledMapData.getOrientation();
    }

    public StaggerAxis getStaggerAxis() {
        return this.tiledMapData.getStaggerAxis();
    }

    public StaggerIndex getStaggerIndex() {
        return this.tiledMapData.getStaggerIndex();
    }

    public int getSideLength() {
        return this.tiledMapData.getSideLength();
    }

    public int getWidth() {
        return this.tiledMapData.getWidth();
    }

    public int getHeight() {
        return this.tiledMapData.getHeight();
    }

    public int getTileWidth() {
        return this.tiledMapData.getTileWidth();
    }

    public int getTileHeight() {
        return this.tiledMapData.getTileHeight();
    }

    public int getPixelWidth() {
        return this.tiledMapData.getPixelWidth();
    }

    public int getPixelHeight() {
        return this.tiledMapData.getPixelHeight();
    }

    public Array<Tileset> getTilesets() {
        return this.tiledMapData.getTilesets();
    }

    public Array<Layer> getLayers() {
        return this.tiledMapData.getLayers();
    }

    public int getTotalObjectGroups() {
        return this.tiledMapData.getTotalObjectGroups();
    }

    public Color getBackgroundColor() {
        return this.tiledMapData.getBackgroundColor();
    }

    public void setTileLayerRenderer(TileLayerRenderer tileLayerRenderer) {
        this.tileLayerRenderer = tileLayerRenderer;
    }

    public void setTiledObjectGroupRenderer(TiledObjectGroupRenderer tiledObjectGroupRenderer) {
        this.tiledObjectGroupRenderer = tiledObjectGroupRenderer;
    }

    public boolean containsAnimatedTiles() {
        return this.tiledMapData.containsAnimatedTiles();
    }

    public TiledMapData getTiledMapData() {
        return this.tiledMapData;
    }
}

