/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.files.FileType;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.serialization.GameDataSerializable;
import org.mini2Dx.core.serialization.GameDataSerializableUtils;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntSet;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.utils.ObjectSet;
import org.mini2Dx.tiled.GroupLayer;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.Orientation;
import org.mini2Dx.tiled.StaggerAxis;
import org.mini2Dx.tiled.StaggerIndex;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.TiledObjectTemplate;
import org.mini2Dx.tiled.TiledParser;
import org.mini2Dx.tiled.TiledParserListener;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.exception.TiledParsingException;
import org.mini2Dx.tiled.renderer.AnimatedTileRenderer;

public class TiledMapData
implements TiledParserListener,
GameDataSerializable {
    public static long MAX_TILESET_LOAD_TIMESLICE_MILLIS = 2L;
    static final ObjectSet<String> OBJECT_TEMPLATE_TILESET_SOURCES = new ObjectSet();
    protected FileHandle fileHandle;
    protected final Array<Tileset> tilesets = new Array(true, 2, Tileset.class);
    protected final IntSet tilesetGids = new IntSet();
    protected final Array<Layer> layers = new Array(true, 2, Layer.class);
    protected final ObjectMap<String, TiledObjectGroup> objectGroups = new ObjectMap(8);
    private String orientationValue;
    private Orientation orientation;
    private StaggerAxis staggerAxis;
    private StaggerIndex staggerIndex;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int pixelWidth;
    private int pixelHeight;
    private int sideLength;
    private Color backgroundColor;
    private Array<Tile> animatedTiles;
    private ObjectMap<String, String> properties;

    public TiledMapData(FileHandle fileHandle) {
        this(new TiledParser(), fileHandle);
    }

    public TiledMapData(TiledParser tiledParser, FileHandle fileHandle) {
        this.fileHandle = fileHandle;
        tiledParser.setListener(this);
        try {
            tiledParser.parseTmx(fileHandle);
        }
        catch (IOException e) {
            tiledParser.setListener(null);
            throw new TiledParsingException(e);
        }
        tiledParser.setListener(null);
    }

    private TiledMapData(boolean load, FileHandle fileHandle) {
        this.fileHandle = fileHandle;
    }

    public static TiledMapData fromInputStream(DataInputStream inputStream) throws IOException {
        TiledMapData mapData;
        String path = inputStream.readUTF();
        FileType fileType = FileType.valueOf((String)inputStream.readUTF());
        switch (fileType) {
            default: {
                mapData = new TiledMapData(false, Mdx.files.internal(path));
                break;
            }
            case EXTERNAL: {
                mapData = new TiledMapData(false, Mdx.files.external(path));
                break;
            }
            case LOCAL: {
                mapData = new TiledMapData(false, Mdx.files.local(path));
            }
        }
        mapData.readData(inputStream);
        return mapData;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        int i;
        outputStream.writeUTF(this.fileHandle.path());
        outputStream.writeUTF(this.fileHandle.type().name());
        outputStream.writeInt(TiledMapData.OBJECT_TEMPLATE_TILESET_SOURCES.size);
        for (String objectTemplateTilesetSources : OBJECT_TEMPLATE_TILESET_SOURCES) {
            outputStream.writeUTF(objectTemplateTilesetSources);
        }
        GameDataSerializableUtils.writeString((String)this.orientationValue, (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeString((String)(this.orientation == null ? null : this.orientation.name()), (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeString((String)(this.staggerAxis == null ? null : this.staggerAxis.name()), (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeString((String)(this.staggerIndex == null ? null : this.staggerIndex.name()), (DataOutputStream)outputStream);
        outputStream.writeInt(this.width);
        outputStream.writeInt(this.height);
        outputStream.writeInt(this.tileWidth);
        outputStream.writeInt(this.tileHeight);
        outputStream.writeInt(this.pixelWidth);
        outputStream.writeInt(this.pixelHeight);
        outputStream.writeInt(this.sideLength);
        outputStream.writeBoolean(this.backgroundColor != null);
        if (this.backgroundColor != null) {
            outputStream.writeFloat(this.backgroundColor.rf());
            outputStream.writeFloat(this.backgroundColor.gf());
            outputStream.writeFloat(this.backgroundColor.bf());
            outputStream.writeFloat(this.backgroundColor.af());
        }
        outputStream.writeInt(this.properties == null ? 0 : this.properties.size);
        if (this.properties != null && this.properties.size > 0) {
            for (String key : this.properties.keys()) {
                outputStream.writeUTF(key);
                GameDataSerializableUtils.writeString((String)((String)this.properties.get((Object)key, null)), (DataOutputStream)outputStream);
            }
        }
        outputStream.writeInt(this.tilesets.size);
        for (i = 0; i < this.tilesets.size; ++i) {
            ((Tileset)this.tilesets.get(i)).writeData(outputStream);
        }
        outputStream.writeInt(this.layers.size);
        for (i = 0; i < this.layers.size; ++i) {
            ((Layer)this.layers.get(i)).writeData(outputStream);
        }
    }

    public void readData(DataInputStream inputStream) throws IOException {
        int totalProperties;
        String staggerIndex;
        String staggerAxis;
        int totalTemplateTilesetSources = inputStream.readInt();
        for (int i = 0; i < totalTemplateTilesetSources; ++i) {
            OBJECT_TEMPLATE_TILESET_SOURCES.add((Object)inputStream.readUTF());
        }
        this.orientationValue = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        String orientation = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        if (orientation != null) {
            this.orientation = Orientation.valueOf(orientation);
        }
        if ((staggerAxis = GameDataSerializableUtils.readString((DataInputStream)inputStream)) != null) {
            this.staggerAxis = StaggerAxis.valueOf(staggerAxis);
        }
        if ((staggerIndex = GameDataSerializableUtils.readString((DataInputStream)inputStream)) != null) {
            this.staggerIndex = StaggerIndex.valueOf(staggerIndex);
        }
        this.width = inputStream.readInt();
        this.height = inputStream.readInt();
        this.tileWidth = inputStream.readInt();
        this.tileHeight = inputStream.readInt();
        this.pixelWidth = inputStream.readInt();
        this.pixelHeight = inputStream.readInt();
        this.sideLength = inputStream.readInt();
        boolean backgroundColorExists = inputStream.readBoolean();
        if (backgroundColorExists) {
            float r = inputStream.readFloat();
            float g = inputStream.readFloat();
            float b = inputStream.readFloat();
            float a = inputStream.readFloat();
            this.backgroundColor = Mdx.graphics.newColor(r, g, b, a);
        }
        if ((totalProperties = inputStream.readInt()) > 0) {
            this.properties = new ObjectMap();
            for (int i = 0; i < totalProperties; ++i) {
                String key = inputStream.readUTF();
                String value = GameDataSerializableUtils.readString((DataInputStream)inputStream);
                this.properties.put((Object)key, (Object)value);
            }
        }
        int totalTilesets = inputStream.readInt();
        for (int i = 0; i < totalTilesets; ++i) {
            this.onTilesetParsed(Tileset.fromInputStream(this, inputStream));
        }
        int totalLayers = inputStream.readInt();
        block8: for (int i = 0; i < totalLayers; ++i) {
            Layer layer = Layer.fromInputStream(inputStream);
            switch (layer.getLayerType()) {
                default: {
                    this.onTileLayerParsed((TileLayer)layer);
                    continue block8;
                }
                case OBJECT: {
                    this.onObjectGroupParsed((TiledObjectGroup)layer);
                    continue block8;
                }
                case IMAGE: {
                    continue block8;
                }
                case GROUP: {
                    this.onGroupLayerParsed((GroupLayer)layer);
                }
            }
        }
        this.onEndParsing();
    }

    public Array<AssetDescriptor> getDependencies() {
        Array dependencies = new Array();
        for (int i = 0; i < this.tilesets.size; ++i) {
            dependencies.addAll(((Tileset)this.tilesets.get(i)).getDependencies(this.fileHandle));
        }
        return dependencies;
    }

    public boolean loadTilesetTextures() {
        return this.loadTilesetTextures(true);
    }

    public boolean loadTilesetTextures(AssetManager assetManager) {
        return this.loadTilesetTextures(assetManager, true);
    }

    public boolean loadTilesetTextures(TextureAtlas textureAtlas) {
        return this.loadTilesetTextures(textureAtlas, true);
    }

    public boolean loadTilesetTextures(boolean loadObjectTemplateTilesets) {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.tilesets.size; ++i) {
            Tileset tileset = (Tileset)this.tilesets.get(i);
            if (tileset.isTextureLoaded() || !loadObjectTemplateTilesets && OBJECT_TEMPLATE_TILESET_SOURCES.contains((Object)tileset.getSourceInternalUuid())) continue;
            tileset.loadTexture(this.fileHandle);
            if (System.currentTimeMillis() - startTime < MAX_TILESET_LOAD_TIMESLICE_MILLIS) continue;
            return false;
        }
        return true;
    }

    public boolean loadTilesetTextures(AssetManager assetManager, boolean loadObjectTemplateTilesets) {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.tilesets.size; ++i) {
            Tileset tileset = (Tileset)this.tilesets.get(i);
            if (tileset.isTextureLoaded() || !loadObjectTemplateTilesets && OBJECT_TEMPLATE_TILESET_SOURCES.contains((Object)tileset.getSourceInternalUuid())) continue;
            tileset.loadTexture(assetManager, this.fileHandle);
            if (System.currentTimeMillis() - startTime < MAX_TILESET_LOAD_TIMESLICE_MILLIS) continue;
            return false;
        }
        return true;
    }

    public boolean loadTilesetTextures(TextureAtlas textureAtlas, boolean loadObjectTemplateTilesets) {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.tilesets.size; ++i) {
            Tileset tileset = (Tileset)this.tilesets.get(i);
            if (tileset.isTextureLoaded() || !loadObjectTemplateTilesets && OBJECT_TEMPLATE_TILESET_SOURCES.contains((Object)tileset.getSourceInternalUuid())) continue;
            tileset.loadTexture(textureAtlas);
            if (System.currentTimeMillis() - startTime < MAX_TILESET_LOAD_TIMESLICE_MILLIS) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onBeginParsing(String orientation, String staggerAxis, String staggerIndex, Color backgroundColor, int width, int height, int tileWidth, int tileHeight, int sideLength) {
        this.orientationValue = orientation;
        try {
            this.orientation = Orientation.valueOf(orientation.toUpperCase());
        }
        catch (Exception e) {
            this.orientation = Orientation.UNKNOWN;
        }
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
        if (staggerAxis != null) {
            this.staggerAxis = StaggerAxis.valueOf(staggerAxis.toUpperCase());
            if (sideLength < 0) {
                switch (this.staggerAxis) {
                    case X: {
                        sideLength = tileWidth / 2;
                        break;
                    }
                    default: {
                        sideLength = tileHeight / 2;
                    }
                }
            }
        }
        if (staggerIndex != null) {
            this.staggerIndex = StaggerIndex.valueOf(staggerIndex.toUpperCase());
        }
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.sideLength = sideLength;
        block4 : switch (this.orientation) {
            case HEXAGONAL: {
                switch (this.staggerAxis) {
                    case X: {
                        this.pixelWidth = MathUtils.round((float)((float)tileWidth * 0.75f * (float)width + (float)tileWidth * 0.25f));
                        this.pixelHeight = MathUtils.round((float)((float)(tileHeight * height) + (float)tileHeight * 0.5f));
                        break block4;
                    }
                }
                this.pixelWidth = MathUtils.round((float)((float)(tileWidth * width) + (float)tileWidth * 0.5f));
                this.pixelHeight = MathUtils.round((float)((float)tileHeight * 0.75f * (float)height + (float)tileHeight * 0.25f));
                break;
            }
            case ISOMETRIC_STAGGERED: {
                break;
            }
            default: {
                this.pixelWidth = width * tileWidth;
                this.pixelHeight = height * tileHeight;
            }
        }
    }

    @Override
    public void onEndParsing() {
        if (!TiledMap.OPTIMISE_ANIMATED_TILES) {
            return;
        }
        if (this.animatedTiles == null) {
            return;
        }
        for (int i = this.animatedTiles.size - 1; i >= 0; --i) {
            Tile animatedTile = (Tile)this.animatedTiles.get(i);
            if (animatedTile == null || this.isTileUsed(animatedTile.getTileId(0))) continue;
            this.animatedTiles.removeIndex(i);
        }
    }

    public boolean isTileUsed(int tileId) {
        return this.isTileUsed(tileId, this.layers);
    }

    private boolean isTileUsed(int tileId, Array<Layer> layers) {
        block4: for (int layerIndex = 0; layerIndex < layers.size; ++layerIndex) {
            Layer layer = (Layer)layers.get(layerIndex);
            switch (layer.getLayerType()) {
                case GROUP: {
                    GroupLayer groupLayer = (GroupLayer)layer;
                    if (!this.isTileUsed(tileId, groupLayer.getLayers())) continue block4;
                    return true;
                }
                case TILE: {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            TileLayer tileLayer = (TileLayer)layer;
            if (!tileLayer.isTileUsed(tileId)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey((Object)propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new ObjectMap();
        }
        this.properties.put((Object)propertyName, (Object)value);
    }

    @Override
    public void onMapPropertyParsed(String propertyName, String value) {
        this.setProperty(propertyName, value);
    }

    @Override
    public void onTilePropertiesParsed(Tile tile) {
        if (tile.getTileRenderer() == null) {
            return;
        }
        if (tile.getTileRenderer() instanceof AnimatedTileRenderer) {
            if (this.animatedTiles == null) {
                this.animatedTiles = new Array(true, 8, Tile.class);
            }
            this.animatedTiles.add((Object)tile);
        }
    }

    @Override
    public void onTilesetParsed(Tileset parsedTileset) {
        if (this.tilesetGids.add(parsedTileset.getFirstGid())) {
            this.tilesets.add((Object)parsedTileset);
        }
    }

    @Override
    public void onTileLayerParsed(TileLayer parsedLayer) {
        parsedLayer.setIndex(this.layers.size);
        this.layers.add((Object)parsedLayer);
    }

    @Override
    public void onObjectGroupParsed(TiledObjectGroup parsedObjectGroup) {
        parsedObjectGroup.setIndex(this.layers.size);
        this.layers.add((Object)parsedObjectGroup);
        this.objectGroups.put((Object)parsedObjectGroup.getName(), (Object)parsedObjectGroup);
    }

    @Override
    public void onGroupLayerParsed(GroupLayer parsedLayer) {
        parsedLayer.setIndex(this.layers.size);
        this.layers.add((Object)parsedLayer);
    }

    @Override
    public void onObjectTemplateParsed(TiledObjectTemplate parsedObjectTemplate) {
        OBJECT_TEMPLATE_TILESET_SOURCES.add((Object)parsedObjectTemplate.getTileset().getSourceInternalUuid());
    }

    public TileLayer getTileLayer(String name) {
        return this.getTileLayer(name, true);
    }

    public TileLayer getTileLayer(String name, boolean recursive) {
        return TiledMapData.getTileLayer(this.layers, name, recursive);
    }

    public static TileLayer getTileLayer(Array<Layer> layers, String name, boolean recursive) {
        for (Layer layer : layers) {
            if (layer.getLayerType().equals((Object)LayerType.TILE)) {
                if (layer.getName().compareTo(name) != 0) continue;
                return (TileLayer)layer;
            }
            if (!recursive || !layer.getLayerType().equals((Object)LayerType.GROUP)) continue;
            GroupLayer groupLayer = (GroupLayer)layer;
            TileLayer result = TiledMapData.getTileLayer(groupLayer.layers, name, recursive);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TileLayer getTileLayer(int index) {
        if (index < 0 || index >= this.layers.size) {
            return null;
        }
        return (TileLayer)this.layers.get(index);
    }

    public TiledObjectGroup getObjectGroup(String name) {
        return this.getObjectGroup(name, true);
    }

    public TiledObjectGroup getObjectGroup(String name, boolean recursive) {
        return TiledMapData.getObjectGroup(this.layers, this.objectGroups, name, recursive);
    }

    public static TiledObjectGroup getObjectGroup(Array<Layer> layers, ObjectMap<String, TiledObjectGroup> objectGroups, String name, boolean recursive) {
        TiledObjectGroup result = (TiledObjectGroup)objectGroups.get((Object)name, null);
        if (result != null) {
            return result;
        }
        if (!recursive) {
            return null;
        }
        for (Layer layer : layers) {
            if (!layer.getLayerType().equals((Object)LayerType.GROUP)) continue;
            GroupLayer groupLayer = (GroupLayer)layer;
            result = TiledMapData.getObjectGroup(groupLayer.layers, groupLayer.objectGroups, name, recursive);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public GroupLayer getGroupLayer(String name) {
        return this.getGroupLayer(name, true);
    }

    public GroupLayer getGroupLayer(String name, boolean recursive) {
        return TiledMapData.getGroupLayer(this.layers, name, recursive);
    }

    public static GroupLayer getGroupLayer(Array<Layer> layers, String name, boolean recursive) {
        for (Layer layer : layers) {
            GroupLayer result;
            if (!layer.getLayerType().equals((Object)LayerType.GROUP)) continue;
            if (layer.getName().compareTo(name) == 0) {
                return (GroupLayer)layer;
            }
            if (!recursive || (result = TiledMapData.getGroupLayer(((GroupLayer)layer).layers, name, recursive)) == null) continue;
            return result;
        }
        return null;
    }

    public GroupLayer getGroupLayer(int index) {
        if (index < 0 || index >= this.layers.size) {
            return null;
        }
        return (GroupLayer)this.layers.get(index);
    }

    public Iterable<TiledObjectGroup> getObjectGroups() {
        if (this.objectGroups.size == 0) {
            return null;
        }
        return this.objectGroups.values();
    }

    public int getLayerIndex(String name) {
        for (int i = 0; i < this.layers.size; ++i) {
            Layer layer = (Layer)this.layers.get(i);
            if (layer.getName().compareTo(name) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getLayerIndexIgnoreCase(String name) {
        for (int i = 0; i < this.layers.size; ++i) {
            Layer layer = (Layer)this.layers.get(i);
            if (layer.getName().compareToIgnoreCase(name) != 0) continue;
            return i;
        }
        return -1;
    }

    public Tile getTile(int tileId) {
        for (int i = 0; i < this.tilesets.size; ++i) {
            if (!((Tileset)this.tilesets.get(i)).contains(tileId)) continue;
            return ((Tileset)this.tilesets.get(i)).getTile(tileId);
        }
        return null;
    }

    public Tile getTile(int x, int y, int layer) {
        Layer tiledLayer = (Layer)this.layers.get(layer);
        if (!tiledLayer.getLayerType().equals((Object)LayerType.TILE)) {
            return null;
        }
        return this.getTile(((TileLayer)tiledLayer).getTileId(x, y));
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public StaggerAxis getStaggerAxis() {
        return this.staggerAxis;
    }

    public StaggerIndex getStaggerIndex() {
        return this.staggerIndex;
    }

    public int getSideLength() {
        return this.sideLength;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public Array<Tileset> getTilesets() {
        return this.tilesets;
    }

    public Array<Layer> getLayers() {
        return this.layers;
    }

    public Array<Tile> getAnimatedTiles() {
        return this.animatedTiles;
    }

    public int getTotalObjectGroups() {
        return this.objectGroups.size;
    }

    public int getTotalLayers() {
        return this.layers.size;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean containsAnimatedTiles() {
        if (this.animatedTiles == null) {
            return false;
        }
        return this.animatedTiles.size > 0;
    }

    public boolean isTilesetTexturesLoaded() {
        return this.isTilesetTexturesLoaded(false);
    }

    public boolean isTilesetTexturesLoaded(boolean ignoreObjectTemplateTilesets) {
        for (int i = 0; i < this.tilesets.size; ++i) {
            Tileset tileset = (Tileset)this.tilesets.get(i);
            if (ignoreObjectTemplateTilesets && OBJECT_TEMPLATE_TILESET_SOURCES.contains((Object)tileset.getSourceInternalUuid()) || tileset.isTextureLoaded()) continue;
            return false;
        }
        return true;
    }

    public FileHandle getFileHandle() {
        return this.fileHandle;
    }

    public void setFileHandle(FileHandle fileHandle) {
        this.fileHandle = fileHandle;
    }

    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean disposeTilesets) {
        int i;
        if (!disposeTilesets) {
            return;
        }
        for (i = 0; i < this.tilesets.size; ++i) {
            ((Tileset)this.tilesets.get(i)).dispose();
        }
        this.tilesets.clear();
        for (i = 0; i < this.layers.size; ++i) {
            ((Layer)this.layers.get(i)).dispose();
        }
        this.layers.clear();
    }

    public static ObjectSet<String> getObjectTemplateTilesetSources() {
        return OBJECT_TEMPLATE_TILESET_SOURCES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiledMapData that = (TiledMapData)o;
        return this.width == that.width && this.height == that.height && this.tileWidth == that.tileWidth && this.tileHeight == that.tileHeight && this.pixelWidth == that.pixelWidth && this.pixelHeight == that.pixelHeight && this.sideLength == that.sideLength && Objects.equals(this.tilesets, that.tilesets) && Objects.equals(this.tilesetGids, that.tilesetGids) && Objects.equals(this.layers, that.layers) && Objects.equals(this.orientationValue, that.orientationValue) && this.orientation == that.orientation && this.staggerAxis == that.staggerAxis && this.staggerIndex == that.staggerIndex && Objects.equals(this.backgroundColor, that.backgroundColor) && Objects.equals(this.animatedTiles, that.animatedTiles) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tilesets, this.tilesetGids, this.layers, this.orientationValue, this.orientation, this.staggerAxis, this.staggerIndex, this.width, this.height, this.tileWidth, this.tileHeight, this.pixelWidth, this.pixelHeight, this.sideLength, this.backgroundColor, this.animatedTiles, this.properties});
    }

    public String toString() {
        return "TiledMapData{tilesets=" + this.tilesets + ", layers=" + this.layers + ", orientationValue='" + this.orientationValue + '\'' + ", orientation=" + (Object)((Object)this.orientation) + ", staggerAxis=" + (Object)((Object)this.staggerAxis) + ", staggerIndex=" + (Object)((Object)this.staggerIndex) + ", width=" + this.width + ", height=" + this.height + ", tileWidth=" + this.tileWidth + ", tileHeight=" + this.tileHeight + ", pixelWidth=" + this.pixelWidth + ", pixelHeight=" + this.pixelHeight + ", sideLength=" + this.sideLength + ", backgroundColor=" + this.backgroundColor + ", properties=" + this.properties + '}';
    }
}

