/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoaderResult;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.assets.AssetProperties;
import org.mini2Dx.core.assets.AsyncAssetLoader;
import org.mini2Dx.core.assets.AsyncLoadingCache;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.TiledMapData;
import org.mini2Dx.tiled.TiledParser;

public class TiledMapLoader
implements AsyncAssetLoader<TiledMap> {
    private static final String LOGGING_TAG = TiledMapLoader.class.getSimpleName();
    private static final String CACHE_TILED_MAP_DATA = "tiledMapData";
    private static final String CACHE_TILED_MAP = "tiledMap";
    private final TiledParser tiledParser = new TiledParser();

    public boolean loadOnGameThread(AssetManager assetManager, AssetDescriptor<TiledMap> assetDescriptor, AsyncLoadingCache asyncLoadingCache, AssetLoaderResult<TiledMap> resultHolder) {
        TiledMap result = (TiledMap)asyncLoadingCache.getCache(CACHE_TILED_MAP, TiledMap.class);
        TiledAssetProperties tiledAssetProperties = (TiledAssetProperties)assetDescriptor.getParameters();
        if (tiledAssetProperties != null) {
            if (tiledAssetProperties.loadTilesets) {
                if (result.loadTilesetTextures(assetManager)) {
                    resultHolder.setResult((Object)result);
                    return true;
                }
                return false;
            }
        } else {
            if (result.loadTilesetTextures(assetManager)) {
                resultHolder.setResult((Object)result);
                return true;
            }
            return false;
        }
        resultHolder.setResult((Object)result);
        return true;
    }

    public Array<AssetDescriptor> getDependencies(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        TiledMapData tiledMapData;
        if (!asyncLoadingCache.containsCache(CACHE_TILED_MAP_DATA)) {
            tiledMapData = new TiledMapData(this.tiledParser, assetDescriptor.getResolvedFileHandle());
            asyncLoadingCache.setCache(CACHE_TILED_MAP_DATA, (Object)tiledMapData);
        } else {
            tiledMapData = (TiledMapData)asyncLoadingCache.getCache(CACHE_TILED_MAP_DATA, TiledMapData.class);
        }
        return tiledMapData.getDependencies();
    }

    public void loadOnAsyncThread(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        if (asyncLoadingCache.containsCache(CACHE_TILED_MAP)) {
            return;
        }
        asyncLoadingCache.setCache(CACHE_TILED_MAP, (Object)new TiledMap((TiledMapData)asyncLoadingCache.getCache(CACHE_TILED_MAP_DATA, TiledMapData.class), false));
    }

    public static class TiledAssetProperties
    implements AssetProperties<TiledMap> {
        public boolean loadTilesets = true;
    }
}

