/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.serialization.GameDataSerializable;
import org.mini2Dx.core.serialization.GameDataSerializableUtils;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.TiledObjectShape;

public class TiledObject
implements GameDataSerializable {
    public static int DEFAULT_PROPERTY_MAP_SIZE = 16;
    private final int id;
    private final float x;
    private final float y;
    private final float width;
    private final float height;
    private final boolean builtFromTemplate;
    private TiledObjectShape objectShape = TiledObjectShape.RECTANGLE;
    private String name;
    private String type;
    private boolean visible;
    private int gid;
    private boolean gidFlipHorizontally;
    private boolean gidFlipVertically;
    private boolean gidFlipDiagonally;
    private ObjectMap<String, String> properties;
    private float[] vertices;
    private String text;
    private boolean wrapText;

    public TiledObject(int id, float x, float y, float width, float height) {
        this(id, x, y, width, height, false);
    }

    TiledObject(int id, float x, float y, float width, float height, boolean builtFromTemplate) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.builtFromTemplate = builtFromTemplate;
    }

    public static TiledObject fromInputStream(DataInputStream inputStream) throws IOException {
        int id = inputStream.readInt();
        float x = inputStream.readFloat();
        float y = inputStream.readFloat();
        float width = inputStream.readFloat();
        float height = inputStream.readFloat();
        boolean builtFromTemplate = inputStream.readBoolean();
        TiledObject result = new TiledObject(id, x, y, width, height, builtFromTemplate);
        result.readData(inputStream);
        return result;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.id);
        outputStream.writeFloat(this.x);
        outputStream.writeFloat(this.y);
        outputStream.writeFloat(this.width);
        outputStream.writeFloat(this.height);
        outputStream.writeBoolean(this.builtFromTemplate);
        outputStream.writeUTF(this.objectShape.name());
        GameDataSerializableUtils.writeString((String)this.name, (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeString((String)this.type, (DataOutputStream)outputStream);
        outputStream.writeBoolean(this.visible);
        outputStream.writeInt(this.gid);
        outputStream.writeBoolean(this.gidFlipHorizontally);
        outputStream.writeBoolean(this.gidFlipVertically);
        outputStream.writeBoolean(this.gidFlipDiagonally);
        outputStream.writeInt(this.properties == null ? 0 : this.properties.size);
        if (this.properties != null) {
            for (String key : this.properties.keys()) {
                outputStream.writeUTF(key);
                GameDataSerializableUtils.writeString((String)((String)this.properties.get((Object)key, null)), (DataOutputStream)outputStream);
            }
        }
        outputStream.writeInt(this.vertices == null ? -1 : this.vertices.length);
        if (this.vertices != null) {
            for (int i = 0; i < this.vertices.length; ++i) {
                outputStream.writeFloat(this.vertices[i]);
            }
        }
        GameDataSerializableUtils.writeString((String)this.text, (DataOutputStream)outputStream);
        outputStream.writeBoolean(this.wrapText);
    }

    public void readData(DataInputStream inputStream) throws IOException {
        int totalVertices;
        this.objectShape = TiledObjectShape.valueOf(inputStream.readUTF());
        this.name = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        this.type = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        this.visible = inputStream.readBoolean();
        this.gid = inputStream.readInt();
        this.gidFlipHorizontally = inputStream.readBoolean();
        this.gidFlipVertically = inputStream.readBoolean();
        this.gidFlipDiagonally = inputStream.readBoolean();
        int totalProperties = inputStream.readInt();
        if (totalProperties > 0) {
            this.properties = new ObjectMap(DEFAULT_PROPERTY_MAP_SIZE);
            for (int i = 0; i < totalProperties; ++i) {
                String key = inputStream.readUTF();
                String value = GameDataSerializableUtils.readString((DataInputStream)inputStream);
                if (this.builtFromTemplate) {
                    key = key.intern();
                    value = value.intern();
                }
                this.properties.put((Object)key, (Object)value);
            }
        }
        if ((totalVertices = inputStream.readInt()) > -1) {
            this.vertices = new float[totalVertices];
            for (int i = 0; i < this.vertices.length; ++i) {
                this.vertices[i] = inputStream.readFloat();
            }
        }
        this.text = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        this.wrapText = inputStream.readBoolean();
        if (this.builtFromTemplate) {
            this.name = this.name != null ? this.name.intern() : null;
            this.type = this.type != null ? this.type.intern() : null;
            this.text = this.text != null ? this.text.intern() : null;
        }
    }

    public ObjectMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey((Object)propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new ObjectMap(DEFAULT_PROPERTY_MAP_SIZE);
        }
        this.properties.put((Object)propertyName, (Object)value);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public boolean isGidFlipHorizontally() {
        return this.gidFlipHorizontally;
    }

    public void setGidFlipHorizontally(boolean gidFlipHorizontally) {
        this.gidFlipHorizontally = gidFlipHorizontally;
    }

    public boolean isGidFlipVertically() {
        return this.gidFlipVertically;
    }

    public void setGidFlipVertically(boolean gidFlipVertically) {
        this.gidFlipVertically = gidFlipVertically;
    }

    public boolean isGidFlipDiagonally() {
        return this.gidFlipDiagonally;
    }

    public void setGidFlipDiagonally(boolean gidFlipDiagonally) {
        this.gidFlipDiagonally = gidFlipDiagonally;
    }

    public TiledObjectShape getObjectShape() {
        return this.objectShape;
    }

    public void setAsEllipse() {
        this.objectShape = TiledObjectShape.ELLIPSE;
    }

    public void setAsPoint() {
        this.objectShape = TiledObjectShape.POINT;
    }

    public void setAsPolygon(String points) {
        this.objectShape = TiledObjectShape.POLYGON;
        String[] pointEntries = points.split(" ");
        this.vertices = new float[pointEntries.length * 2];
        for (int i = 0; i < pointEntries.length; ++i) {
            String[] xy = pointEntries[i].split(",");
            this.vertices[i * 2] = this.x + Float.parseFloat(xy[0]);
            this.vertices[i * 2 + 1] = this.y + Float.parseFloat(xy[1]);
        }
    }

    public void setAsPolygon(float[] vertices) {
        this.objectShape = TiledObjectShape.POLYGON;
        this.vertices = new float[vertices.length];
        for (int i = 0; i < vertices.length; i += 2) {
            this.vertices[i] = this.x + vertices[i];
            this.vertices[i + 1] = this.y + vertices[i + 1];
        }
    }

    public void setAsText(String text, boolean wrapText) {
        this.objectShape = TiledObjectShape.TEXT;
        this.text = text;
        this.wrapText = wrapText;
    }

    public void setAsPolyline(String points) {
        this.objectShape = TiledObjectShape.POLYLINE;
        String[] pointEntries = points.split(" ");
        this.vertices = new float[pointEntries.length * 2];
        for (int i = 0; i < pointEntries.length; ++i) {
            String[] xy = pointEntries[i].split(",");
            this.vertices[i * 2] = this.x + Float.parseFloat(xy[0]);
            this.vertices[i * 2 + 1] = this.y + Float.parseFloat(xy[1]);
        }
    }

    public void setAsPolyline(float[] vertices) {
        this.objectShape = TiledObjectShape.POLYLINE;
        this.vertices = new float[vertices.length];
        for (int i = 0; i < vertices.length; i += 2) {
            this.vertices[i] = this.x + vertices[i];
            this.vertices[i + 1] = this.y + vertices[i + 1];
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Point toPoint() {
        if (!this.objectShape.equals((Object)TiledObjectShape.POINT)) {
            throw new MdxException("TiledObject " + this.id + " is not a point");
        }
        return new Point(this.x, this.y);
    }

    public Circle toCircle() {
        if (!this.objectShape.equals((Object)TiledObjectShape.ELLIPSE)) {
            throw new MdxException("TiledObject " + this.id + " is not a circle");
        }
        if (!MathUtils.isEqual((float)this.width, (float)this.height)) {
            throw new MdxException("TiledObject " + this.id + " is an ellipse, not a circle");
        }
        return new Circle(this.x + this.width * 0.5f, this.y + this.height * 0.5f, this.width * 0.5f);
    }

    public Rectangle toRectangle() {
        if (!this.objectShape.equals((Object)TiledObjectShape.RECTANGLE)) {
            throw new MdxException("TiledObject " + this.id + " is not a rectangle");
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Polygon toPolygon() {
        if (!this.objectShape.equals((Object)TiledObjectShape.POLYGON)) {
            throw new MdxException("TiledObject " + this.id + " is not a polygon");
        }
        return new Polygon(this.vertices);
    }

    public Array<Point> toPolyline() {
        if (!this.objectShape.equals((Object)TiledObjectShape.POLYLINE)) {
            throw new MdxException("TiledObject " + this.id + " is not a polyline");
        }
        Array result = new Array();
        for (int i = 0; i < this.vertices.length; i += 2) {
            result.add((Object)new Point(this.vertices[i], this.vertices[i + 1]));
        }
        return result;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public String getText() {
        return this.text;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public boolean isBuiltFromTemplate() {
        return this.builtFromTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiledObject that = (TiledObject)o;
        return this.id == that.id && Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && Float.compare(that.width, this.width) == 0 && Float.compare(that.height, this.height) == 0 && this.builtFromTemplate == that.builtFromTemplate && this.visible == that.visible && this.gid == that.gid && this.gidFlipHorizontally == that.gidFlipHorizontally && this.gidFlipVertically == that.gidFlipVertically && this.gidFlipDiagonally == that.gidFlipDiagonally && this.wrapText == that.wrapText && this.objectShape == that.objectShape && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.properties, that.properties) && Arrays.equals(this.vertices, that.vertices) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.id, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height), this.builtFromTemplate, this.objectShape, this.name, this.type, this.visible, this.gid, this.gidFlipHorizontally, this.gidFlipVertically, this.gidFlipDiagonally, this.properties, this.text, this.wrapText});
        result = 31 * result + Arrays.hashCode(this.vertices);
        return result;
    }

    public String toString() {
        return "TiledObject{id=" + this.id + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", builtFromTemplate=" + this.builtFromTemplate + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", visible=" + this.visible + ", gid=" + this.gid + ", gidFlipHorizontally=" + this.gidFlipHorizontally + ", gidFlipVertically=" + this.gidFlipVertically + ", gidFlipDiagonally=" + this.gidFlipDiagonally + ", properties=" + this.properties + ", text='" + this.text + '\'' + ", wrapText=" + this.wrapText + '}';
    }
}

