/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Queue;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.TiledObject;

public class TiledObjectGroup
extends Layer {
    private static final int INITIAL_POOL_SIZE = 4096;
    private static final Queue<TiledObjectGroup> POOL = new Queue(4096);
    private int width;
    private int height;
    private final Array<TiledObject> objects = new Array(true, 2, TiledObject.class);

    private TiledObjectGroup() {
        super(LayerType.OBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiledObjectGroup create() {
        TiledObjectGroup result;
        Queue<TiledObjectGroup> queue = POOL;
        synchronized (queue) {
            result = TiledObjectGroup.POOL.size == 0 ? new TiledObjectGroup() : (TiledObjectGroup)POOL.removeFirst();
        }
        return result;
    }

    public static TiledObjectGroup fromInputStream(DataInputStream inputStream) throws IOException {
        TiledObjectGroup result = TiledObjectGroup.create();
        result.readData(inputStream);
        return result;
    }

    @Override
    public void writeData(DataOutputStream outputStream) throws IOException {
        super.writeData(outputStream);
        outputStream.writeInt(this.width);
        outputStream.writeInt(this.height);
        outputStream.writeInt(this.objects.size);
        for (int i = 0; i < this.objects.size; ++i) {
            ((TiledObject)this.objects.get(i)).writeData(outputStream);
        }
    }

    @Override
    public void readData(DataInputStream inputStream) throws IOException {
        super.readData(inputStream);
        this.width = inputStream.readInt();
        this.height = inputStream.readInt();
        int totalObjects = inputStream.readInt();
        for (int i = 0; i < totalObjects; ++i) {
            this.objects.add((Object)TiledObject.fromInputStream(inputStream));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Array<TiledObject> getObjects() {
        return this.objects;
    }

    public TiledObject getObjectById(int id) {
        for (int i = 0; i < this.objects.size; ++i) {
            TiledObject tiledObject = (TiledObject)this.objects.get(i);
            if (tiledObject.getId() < 0 || tiledObject.getId() != id) continue;
            return tiledObject;
        }
        return null;
    }

    public TiledObject getObjectByName(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.objects.size; ++i) {
            TiledObject tiledObject = (TiledObject)this.objects.get(i);
            if (tiledObject.getName() == null || !tiledObject.getName().equals(name)) continue;
            return tiledObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        this.objects.clear();
        Queue<TiledObjectGroup> queue = POOL;
        synchronized (queue) {
            POOL.addLast((Object)this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TiledObjectGroup that = (TiledObjectGroup)o;
        return this.width == that.width && this.height == that.height && Objects.equals(this.objects, that.objects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.width, this.height, this.objects);
    }

    @Override
    public String toString() {
        return "TiledObjectGroup{width=" + this.width + ", height=" + this.height + ", objects=" + this.objects + "} " + super.toString();
    }

    static {
        for (int i = 0; i < 4096; ++i) {
            POOL.addLast((Object)new TiledObjectGroup());
        }
    }
}

