/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.util.ZlibStream;
import org.mini2Dx.gdx.Base64Coder;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.xml.XmlReader;
import org.mini2Dx.tiled.GroupLayer;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledLayerParserListener;
import org.mini2Dx.tiled.TiledObject;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.TiledObjectShape;
import org.mini2Dx.tiled.TiledObjectTemplate;
import org.mini2Dx.tiled.TiledParserListener;
import org.mini2Dx.tiled.TiledParserNotifier;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.AnimatedTileRenderer;
import org.mini2Dx.tiled.renderer.StaticTileRenderer;
import org.mini2Dx.tiled.renderer.TileFrame;
import org.mini2Dx.tiled.tileset.ImageTilesetSource;
import org.mini2Dx.tiled.tileset.TilesetSource;
import org.mini2Dx.tiled.tileset.TsxTilesetSource;

public class TiledParser
implements TiledParserNotifier {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    private XmlReader xmlReader;
    private TiledParserListener listener;
    private final ObjectMap<String, TiledObjectTemplate> objectTemplates;

    public TiledParser() {
        this((ObjectMap<String, TiledObjectTemplate>)new ObjectMap());
    }

    public TiledParser(ObjectMap<String, TiledObjectTemplate> objectTemplates) {
        this.objectTemplates = objectTemplates;
        this.xmlReader = new XmlReader();
    }

    public void parseTmx(FileHandle tmxFileHandle) throws IOException {
        XmlReader.Element root = this.xmlReader.parse(tmxFileHandle.reader());
        String mapOrientation = root.getAttribute("orientation", null);
        int mapWidth = root.getIntAttribute("width", 0);
        int mapHeight = root.getIntAttribute("height", 0);
        int tileWidth = root.getIntAttribute("tilewidth", 0);
        int tileHeight = root.getIntAttribute("tileheight", 0);
        int sideLength = root.getInt("hexsidelength", -1);
        String staggerAxis = root.getAttribute("staggeraxis", null);
        String staggerIndex = root.getAttribute("staggerindex", null);
        String mapBackgroundColor = root.getAttribute("backgroundcolor", null);
        Color backgroundColor = null;
        if (mapBackgroundColor != null) {
            backgroundColor = this.convertHexColorToColor(mapBackgroundColor);
        }
        this.notifyBeginParsing(mapOrientation, staggerAxis, staggerIndex, backgroundColor, mapWidth, mapHeight, tileWidth, tileHeight, sideLength);
        XmlReader.Element properties = root.getChildByName("properties");
        if (properties != null) {
            this.loadMapProperties(properties);
        }
        Array tilesets = root.getChildrenByName("tileset");
        for (XmlReader.Element element : tilesets) {
            this.loadTileSet(element, tmxFileHandle);
            root.removeChild(element);
        }
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            XmlReader.Element element = root.getChild(i);
            String name = element.getName();
            if (name.equals("layer")) {
                this.loadTileLayer(this.listener, element);
                continue;
            }
            if (name.equals("objectgroup")) {
                this.loadObjectGroup(this.listener, element, tmxFileHandle);
                continue;
            }
            if (!name.equals("group")) continue;
            this.loadGroupLayer(this.listener, element, tmxFileHandle);
        }
    }

    public ImageTilesetSource parseTsx(FileHandle tsxFileHandle) throws IOException {
        XmlReader.Element element = this.xmlReader.parse(tsxFileHandle.reader());
        String name = element.get("name", null);
        int tileWidth = element.getIntAttribute("tilewidth", 0);
        int tileHeight = element.getIntAttribute("tileheight", 0);
        int spacing = element.getIntAttribute("spacing", 0);
        int margin = element.getIntAttribute("margin", 0);
        String imageSource = element.getChildByName("image").getAttribute("source");
        int imageWidth = element.getChildByName("image").getIntAttribute("width", 0);
        int imageHeight = element.getChildByName("image").getIntAttribute("height", 0);
        String transparentColor = element.getChildByName("image").get("trans", null);
        ImageTilesetSource result = new ImageTilesetSource(imageWidth, imageHeight, tileWidth, tileHeight, spacing, margin);
        result.setName(name);
        result.setTilesetImagePath(tsxFileHandle.sibling(imageSource).normalize());
        result.setTransparentColorValue(transparentColor);
        this.loadTileProperties(result, (Array<XmlReader.Element>)element.getChildrenByName("tile"));
        XmlReader.Element properties = element.getChildByName("properties");
        if (properties != null) {
            for (XmlReader.Element property : properties.getChildrenByName("property")) {
                String propertyName = property.getAttribute("name", null);
                String propertyValue = property.getAttribute("value", null);
                if (propertyValue == null) {
                    propertyValue = property.getText();
                }
                result.setProperty(propertyName, propertyValue);
            }
        }
        return result;
    }

    private void loadMapProperties(XmlReader.Element element) {
        if (element.getName().equals("properties")) {
            for (XmlReader.Element property : element.getChildrenByName("property")) {
                String name = property.getAttribute("name", null);
                String value = property.getAttribute("value", null);
                if (value == null) {
                    value = property.getText();
                }
                this.notifyMapPropertyParsed(name, value);
            }
        }
    }

    private Tileset loadTileSet(XmlReader.Element element, FileHandle tmxFile) {
        Tileset tileset = null;
        if (element.getName().equals("tileset")) {
            String source = element.getAttribute("source", null);
            int firstGid = element.getIntAttribute("firstgid", 1);
            if (source == null) {
                String name = element.get("name", null);
                int tileWidth = element.getIntAttribute("tilewidth", 0);
                int tileHeight = element.getIntAttribute("tileheight", 0);
                int spacing = element.getIntAttribute("spacing", 0);
                int margin = element.getIntAttribute("margin", 0);
                String transparentColor = null;
                String imageSource = "";
                int imageWidth = 0;
                int imageHeight = 0;
                imageSource = element.getChildByName("image").getAttribute("source");
                imageWidth = element.getChildByName("image").getIntAttribute("width", 0);
                imageHeight = element.getChildByName("image").getIntAttribute("height", 0);
                transparentColor = element.getChildByName("image").get("trans", null);
                ImageTilesetSource tilesetSource = new ImageTilesetSource(imageWidth, imageHeight, tileWidth, tileHeight, spacing, margin);
                tilesetSource.setName(name);
                tilesetSource.setTransparentColorValue(transparentColor);
                tilesetSource.setTilesetImagePath(tmxFile.sibling(imageSource).normalize());
                tileset = new Tileset(firstGid, tilesetSource);
                this.loadTileProperties(tilesetSource, (Array<XmlReader.Element>)element.getChildrenByName("tile"));
                XmlReader.Element properties = element.getChildByName("properties");
                if (properties != null) {
                    for (XmlReader.Element property : properties.getChildrenByName("property")) {
                        String propertyName = property.getAttribute("name", null);
                        String propertyValue = property.getAttribute("value", null);
                        if (propertyValue == null) {
                            propertyValue = property.getText();
                        }
                        tileset.setProperty(propertyName, propertyValue);
                    }
                }
            } else {
                TsxTilesetSource tilesetSource = new TsxTilesetSource(tmxFile, source);
                tileset = new Tileset(firstGid, tilesetSource);
                for (int x = 0; x < tilesetSource.getWidthInTiles(); ++x) {
                    for (int y = 0; y < tilesetSource.getHeightInTiles(); ++y) {
                        Tile tile = tilesetSource.getTileByPosition(x, y);
                        if (tile == null || tile.getTileRenderer() == null) continue;
                        if (tile.getTileRenderer() instanceof AnimatedTileRenderer) {
                            this.notifyTilePropertyParsed(tile);
                            continue;
                        }
                        if (tile.getProperties() == null) continue;
                        this.notifyTilePropertyParsed(tile);
                    }
                }
            }
            this.notifyTilesetParsed(tileset);
        }
        return tileset;
    }

    private void loadTileProperties(TilesetSource tilesetSource, Array<XmlReader.Element> tileElements) {
        for (XmlReader.Element tileElement : tileElements) {
            XmlReader.Element animation;
            XmlReader.Element properties;
            String probability;
            String terrain;
            int localtid = tileElement.getIntAttribute("id", 0);
            Tile tile = tilesetSource.getTile(localtid, 0);
            if (tile == null) continue;
            String type = tileElement.getAttribute("type", null);
            if (type != null) {
                tile.setProperty("type", type);
            }
            if ((terrain = tileElement.getAttribute("terrain", null)) != null) {
                tile.setProperty("terrain", terrain);
            }
            if ((probability = tileElement.getAttribute("probability", null)) != null) {
                tile.setProperty("probability", probability);
            }
            if ((properties = tileElement.getChildByName("properties")) != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    tile.setProperty(propertyName, propertyValue);
                }
            }
            if ((animation = tileElement.getChildByName("animation")) != null) {
                Array frameElements = animation.getChildrenByName("frame");
                TileFrame[] frames = new TileFrame[frameElements.size];
                for (int i = 0; i < frameElements.size; ++i) {
                    XmlReader.Element frameElement = (XmlReader.Element)frameElements.get(i);
                    int tileId = frameElement.getIntAttribute("tileid");
                    float duration = frameElement.getFloatAttribute("duration") / 1000.0f;
                    frames[i] = new TileFrame(duration, tileId);
                }
                tile.setTileRenderer(new AnimatedTileRenderer(tilesetSource, frames));
            }
            this.notifyTilePropertyParsed(tile);
        }
        for (int x = 0; x < tilesetSource.getWidthInTiles(); ++x) {
            for (int y = 0; y < tilesetSource.getHeightInTiles(); ++y) {
                Tile tile = tilesetSource.getTileByPosition(x, y);
                if (tile == null || tile.getTileRenderer() != null) continue;
                tile.setTileRenderer(StaticTileRenderer.create(tilesetSource));
            }
        }
    }

    protected GroupLayer loadGroupLayer(TiledLayerParserListener parserListener, XmlReader.Element layerElement, FileHandle tmxFileHandle) throws IOException {
        if (!layerElement.getName().equals("group")) {
            return null;
        }
        String groupName = layerElement.getAttribute("name", null);
        boolean visible = layerElement.getIntAttribute("visible", 1) == 1;
        GroupLayer groupLayer = GroupLayer.create();
        groupLayer.setName(groupName);
        groupLayer.setVisible(visible);
        XmlReader.Element properties = layerElement.getChildByName("properties");
        if (properties != null) {
            for (XmlReader.Element property : properties.getChildrenByName("property")) {
                String propertyName = property.getAttribute("name", null);
                String propertyValue = property.getAttribute("value", null);
                if (propertyValue == null) {
                    propertyValue = property.getText();
                }
                groupLayer.setProperty(propertyName, propertyValue);
            }
        }
        int j = layerElement.getChildCount();
        for (int i = 0; i < j; ++i) {
            XmlReader.Element element = layerElement.getChild(i);
            String name = element.getName();
            if (name.equals("layer")) {
                this.loadTileLayer(groupLayer, element);
                continue;
            }
            if (name.equals("objectgroup")) {
                this.loadObjectGroup(groupLayer, element, tmxFileHandle);
                continue;
            }
            if (!name.equals("group")) continue;
            this.loadGroupLayer(groupLayer, element, tmxFileHandle);
        }
        this.notifyGroupLayerParsed(parserListener, groupLayer);
        return groupLayer;
    }

    protected TileLayer loadTileLayer(TiledLayerParserListener parserListener, XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            String name = element.getAttribute("name", null);
            int width = element.getIntAttribute("width", 0);
            int height = element.getIntAttribute("height", 0);
            boolean visible = element.getIntAttribute("visible", 1) == 1;
            TileLayer layer = TileLayer.create(width, height);
            layer.setVisible(visible);
            layer.setName(name);
            XmlReader.Element data = element.getChildByName("data");
            String encoding = data.getAttribute("encoding", null);
            String compression = data.getAttribute("compression", null);
            if (encoding == null) {
                throw new MdxException("Unsupported encoding (XML) for TMX Layer Data");
            }
            if (encoding.equals("csv")) {
                String[] array = data.getText().split(",");
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int id = (int)Long.parseLong(array[y * width + x].trim());
                        layer.setTileId(x, y, id &= 0x1FFFFFFF);
                    }
                }
            } else if (encoding.equals("base64")) {
                boolean flipDiagonally;
                boolean flipVertically;
                boolean flipHorizontally;
                int id;
                int x;
                int y;
                byte[] bytes = Base64Coder.decode((String)data.getText());
                if (compression == null) {
                    int read = 0;
                    for (int y2 = 0; y2 < height; ++y2) {
                        for (int x2 = 0; x2 < width; ++x2) {
                            int id2;
                            boolean flipHorizontally2 = ((id2 = TiledParser.unsignedByteToInt(bytes[read++]) | TiledParser.unsignedByteToInt(bytes[read++]) << 8 | TiledParser.unsignedByteToInt(bytes[read++]) << 16 | TiledParser.unsignedByteToInt(bytes[read++]) << 24) & Integer.MIN_VALUE) != 0;
                            boolean flipVertically2 = (id2 & 0x40000000) != 0;
                            boolean flipDiagonally2 = (id2 & 0x20000000) != 0;
                            layer.setTileId(x2, y2, id2 &= 0x1FFFFFFF, flipHorizontally2, flipVertically2, flipDiagonally2);
                        }
                    }
                } else if (compression.equals("gzip")) {
                    GZIPInputStream GZIS = null;
                    try {
                        GZIS = new GZIPInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    }
                    catch (IOException e) {
                        throw new MdxException("Error Reading TMX Layer Data - IOException: " + e.getMessage());
                    }
                    byte[] temp = new byte[4];
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            try {
                                GZIS.read(temp, 0, 4);
                                id = TiledParser.unsignedByteToInt(temp[0]) | TiledParser.unsignedByteToInt(temp[1]) << 8 | TiledParser.unsignedByteToInt(temp[2]) << 16 | TiledParser.unsignedByteToInt(temp[3]) << 24;
                                flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                                flipVertically = (id & 0x40000000) != 0;
                                flipDiagonally = (id & 0x20000000) != 0;
                                layer.setTileId(x, y, id &= 0x1FFFFFFF, flipHorizontally, flipVertically, flipDiagonally);
                                continue;
                            }
                            catch (IOException e) {
                                throw new MdxException("Error Reading TMX Layer Data.", (Throwable)e);
                            }
                        }
                    }
                } else if (compression.equals("zlib")) {
                    ZlibStream zlibStream = Mdx.platformUtils.decompress(bytes);
                    byte[] temp = new byte[4];
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            try {
                                zlibStream.read(temp);
                                id = TiledParser.unsignedByteToInt(temp[0]) | TiledParser.unsignedByteToInt(temp[1]) << 8 | TiledParser.unsignedByteToInt(temp[2]) << 16 | TiledParser.unsignedByteToInt(temp[3]) << 24;
                                flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                                flipVertically = (id & 0x40000000) != 0;
                                flipDiagonally = (id & 0x20000000) != 0;
                                layer.setTileId(x, y, id &= 0x1FFFFFFF, flipHorizontally, flipVertically, flipDiagonally);
                                continue;
                            }
                            catch (Exception e) {
                                zlibStream.dispose();
                                throw new MdxException("Error Reading TMX Layer Data.", (Throwable)e);
                            }
                        }
                    }
                    zlibStream.dispose();
                }
            } else {
                throw new MdxException("Unrecognised encoding (" + encoding + ") for TMX Layer Data");
            }
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    layer.setProperty(propertyName, propertyValue);
                }
            }
            this.notifyTileLayerParsed(parserListener, layer);
            return layer;
        }
        return null;
    }

    protected TiledObjectGroup loadObjectGroup(TiledLayerParserListener parserListener, XmlReader.Element element, FileHandle tmxFile) throws IOException {
        if (element.getName().equals("objectgroup")) {
            String name = element.getAttribute("name", null);
            TiledObjectGroup tiledObjectGroup = TiledObjectGroup.create();
            tiledObjectGroup.setName(name);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    tiledObjectGroup.setProperty(propertyName, propertyValue);
                }
            }
            for (XmlReader.Element objectElement : element.getChildrenByName("object")) {
                TiledObject tiledObject = this.loadObject(objectElement, tmxFile);
                if (tiledObject == null) continue;
                tiledObjectGroup.getObjects().add((Object)tiledObject);
            }
            this.notifyObjectGroupParsed(parserListener, tiledObjectGroup);
            return tiledObjectGroup;
        }
        return null;
    }

    protected TiledObject loadObject(XmlReader.Element element, FileHandle tmxFile) throws IOException {
        if (element.getName().equals("object")) {
            XmlReader.Element point;
            TiledObject objectTemplate;
            int id = element.getIntAttribute("id", -1);
            float x = element.getFloatAttribute("x", 0.0f);
            float y = element.getFloatAttribute("y", 0.0f);
            String template = element.getAttribute("template", null);
            boolean yAdjusted = false;
            if (template != null) {
                TiledObjectTemplate tiledObjectTemplate = !this.objectTemplates.containsKey((Object)template) ? this.loadObjectTemplate(template, tmxFile) : (TiledObjectTemplate)this.objectTemplates.get((Object)template, null);
                if (tiledObjectTemplate == null) {
                    objectTemplate = null;
                } else if (tiledObjectTemplate.getTiledObject() != null) {
                    objectTemplate = tiledObjectTemplate.getTiledObject();
                    if (tiledObjectTemplate.getTileset() != null) {
                        y -= objectTemplate.getHeight();
                        yAdjusted = true;
                    }
                } else {
                    objectTemplate = null;
                }
            } else {
                objectTemplate = null;
            }
            float width = element.getFloatAttribute("width", objectTemplate != null ? objectTemplate.getWidth() : 0.0f);
            float height = element.getFloatAttribute("height", objectTemplate != null ? objectTemplate.getHeight() : 0.0f);
            long rawGid = Long.parseLong(element.getAttribute("gid", "-1"));
            if (rawGid != -1L && !yAdjusted) {
                y -= height;
                yAdjusted = true;
            }
            TiledObject object = new TiledObject(id, x, y, width, height, objectTemplate != null);
            object.setName(element.getAttribute("name", objectTemplate != null ? objectTemplate.getName() : null));
            String type = element.getAttribute("type", objectTemplate != null ? objectTemplate.getType() : null);
            if (type != null) {
                object.setType(type);
            }
            if (rawGid != -1L) {
                boolean gidFlipHorizontally = (rawGid & Integer.MIN_VALUE) != 0L;
                boolean gidFlipVertically = (rawGid & 0x40000000L) != 0L;
                boolean gidFlipDiagonally = (rawGid & 0x20000000L) != 0L;
                int gid = (int)(rawGid & 0x1FFFFFFFL);
                object.setGid(gid);
                object.setGidFlipDiagonally(gidFlipDiagonally);
                object.setGidFlipHorizontally(gidFlipHorizontally);
                object.setGidFlipVertically(gidFlipVertically);
            } else if (objectTemplate != null) {
                object.setGid(objectTemplate.getGid());
                object.setGidFlipDiagonally(objectTemplate.isGidFlipDiagonally());
                object.setGidFlipHorizontally(objectTemplate.isGidFlipHorizontally());
                object.setGidFlipVertically(objectTemplate.isGidFlipVertically());
            }
            object.setVisible(element.getIntAttribute("visible", 1) == 1);
            XmlReader.Element properties = element.getChildByName("properties");
            if (objectTemplate != null && objectTemplate.getProperties() != null) {
                for (String key : objectTemplate.getProperties().keys()) {
                    object.setProperty(key, (String)objectTemplate.getProperties().get((Object)key));
                }
            }
            if (properties != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    object.setProperty(propertyName, propertyValue);
                }
            }
            if ((point = element.getChildByName("point")) != null) {
                object.setAsPoint();
            } else if (objectTemplate != null && objectTemplate.getObjectShape().equals((Object)TiledObjectShape.POINT)) {
                object.setAsPoint();
            }
            XmlReader.Element ellipse = element.getChildByName("ellipse");
            if (ellipse != null) {
                object.setAsEllipse();
            } else if (objectTemplate != null && objectTemplate.getObjectShape().equals((Object)TiledObjectShape.ELLIPSE)) {
                object.setAsEllipse();
            }
            XmlReader.Element polygon = element.getChildByName("polygon");
            if (polygon != null) {
                object.setAsPolygon(polygon.getAttribute("points", ""));
            } else if (objectTemplate != null && objectTemplate.getObjectShape().equals((Object)TiledObjectShape.POLYGON)) {
                object.setAsPolygon(objectTemplate.getVertices());
            }
            XmlReader.Element polyline = element.getChildByName("polyline");
            if (polyline != null) {
                object.setAsPolyline(polyline.getAttribute("points", ""));
            } else if (objectTemplate != null && objectTemplate.getObjectShape().equals((Object)TiledObjectShape.POLYGON)) {
                object.setAsPolyline(objectTemplate.getVertices());
            }
            XmlReader.Element text = element.getChildByName("text");
            if (text != null) {
                object.setAsText(text.getText(), text.getIntAttribute("wrap", 1) == 1);
            } else if (objectTemplate != null && objectTemplate.getObjectShape().equals((Object)TiledObjectShape.TEXT)) {
                object.setAsText(objectTemplate.getText(), objectTemplate.isWrapText());
            }
            return object;
        }
        return null;
    }

    private TiledObjectTemplate loadObjectTemplate(String path, FileHandle tmxFile) throws IOException {
        FileHandle txFile = tmxFile.sibling(path).normalizedHandle();
        XmlReader.Element root = this.xmlReader.parse(txFile.reader());
        XmlReader.Element tilesetElement = root.getChildByName("tileset");
        XmlReader.Element objectElement = root.getChildByName("object");
        Tileset tileset = tilesetElement != null ? this.loadTileSet(tilesetElement, txFile) : null;
        TiledObject tiledObject = objectElement != null ? this.loadObject(objectElement, txFile) : null;
        TiledObjectTemplate objectTemplate = new TiledObjectTemplate(path, tileset, tiledObject);
        this.objectTemplates.put((Object)path, (Object)objectTemplate);
        this.notifyObjectTemplateParsed(objectTemplate);
        return objectTemplate;
    }

    static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    @Override
    public void setListener(TiledParserListener tiledParserListener) {
        this.listener = tiledParserListener;
    }

    @Override
    public void notifyBeginParsing(String orientation, String staggerAxis, String staggerIndex, Color backgroundColor, int width, int height, int tileWidth, int tileHeight, int sideLength) {
        if (this.listener == null) {
            return;
        }
        this.listener.onBeginParsing(orientation, staggerAxis, staggerIndex, backgroundColor, width, height, tileWidth, tileHeight, sideLength);
    }

    @Override
    public void notifyEndParsing() {
        if (this.listener == null) {
            return;
        }
        this.listener.onEndParsing();
    }

    @Override
    public void notifyMapPropertyParsed(String propertyName, String value) {
        if (this.listener == null) {
            return;
        }
        this.listener.onMapPropertyParsed(propertyName, value);
    }

    @Override
    public void notifyTilePropertyParsed(Tile tile) {
        if (this.listener == null) {
            return;
        }
        this.listener.onTilePropertiesParsed(tile);
    }

    @Override
    public void notifyTilesetParsed(Tileset parsedTileset) {
        if (this.listener == null) {
            return;
        }
        this.listener.onTilesetParsed(parsedTileset);
    }

    public void notifyTileLayerParsed(TiledLayerParserListener listener, TileLayer parsedLayer) {
        if (listener == null) {
            return;
        }
        listener.onTileLayerParsed(parsedLayer);
    }

    @Override
    public void notifyTileLayerParsed(TileLayer parsedLayer) {
        if (this.listener == null) {
            return;
        }
        this.listener.onTileLayerParsed(parsedLayer);
    }

    public void notifyObjectGroupParsed(TiledLayerParserListener listener, TiledObjectGroup parsedObjectGroup) {
        if (listener == null) {
            return;
        }
        listener.onObjectGroupParsed(parsedObjectGroup);
    }

    @Override
    public void notifyObjectGroupParsed(TiledObjectGroup parsedObjectGroup) {
        if (this.listener == null) {
            return;
        }
        this.listener.onObjectGroupParsed(parsedObjectGroup);
    }

    public void notifyGroupLayerParsed(TiledLayerParserListener listener, GroupLayer parsedGroupLayer) {
        if (listener == null) {
            return;
        }
        listener.onGroupLayerParsed(parsedGroupLayer);
    }

    @Override
    public void notifyGroupLayerParsed(GroupLayer parsedGroupLayer) {
        if (this.listener == null) {
            return;
        }
        this.listener.onGroupLayerParsed(parsedGroupLayer);
    }

    @Override
    public void notifyObjectTemplateParsed(TiledObjectTemplate parsedObjectTemplate) {
        if (this.listener == null) {
            return;
        }
        this.listener.onObjectTemplateParsed(parsedObjectTemplate);
    }

    private Color convertHexColorToColor(String hexColor) {
        return Mdx.graphics.newColor((float)Integer.valueOf(hexColor.substring(1, 3), 16).intValue() / 255.0f, (float)Integer.valueOf(hexColor.substring(3, 5), 16).intValue() / 255.0f, (float)Integer.valueOf(hexColor.substring(5, 7), 16).intValue() / 255.0f, 0.0f);
    }
}

