/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.serialization.GameDataSerializable;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TiledMapData;
import org.mini2Dx.tiled.tileset.ImageTilesetSource;
import org.mini2Dx.tiled.tileset.TilesetSource;
import org.mini2Dx.tiled.tileset.TsxTilesetSource;

public class Tileset
implements GameDataSerializable,
Disposable {
    private TilesetSource tilesetSource;
    private int firstGid;
    private int lastGid = Integer.MAX_VALUE;

    public Tileset(int firstGid, TilesetSource tilesetSource) {
        this.tilesetSource = tilesetSource;
        this.firstGid = firstGid;
        this.calculateLastGid();
    }

    private Tileset() {
    }

    public static Tileset fromInputStream(TiledMapData mapData, DataInputStream inputStream) throws IOException {
        Tileset result = new Tileset();
        result.readData(inputStream);
        int tilesetSourceType = inputStream.readInt();
        switch (tilesetSourceType) {
            case 1: {
                result.tilesetSource = TsxTilesetSource.fromInputStream(mapData, inputStream);
                break;
            }
            default: {
                result.tilesetSource = ImageTilesetSource.fromInputStream(inputStream);
            }
        }
        result.calculateLastGid();
        for (int x = 0; x < result.getWidthInTiles(); ++x) {
            for (int y = 0; y < result.getHeightInTiles(); ++y) {
                mapData.onTilePropertiesParsed(result.getTile(x, y));
            }
        }
        return result;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.firstGid);
        outputStream.writeInt(this.tilesetSource.getTilesetSourceType());
        this.tilesetSource.writeData(outputStream);
    }

    public void readData(DataInputStream inputStream) throws IOException {
        this.firstGid = inputStream.readInt();
    }

    public boolean containsProperty(String propertyName) {
        return this.tilesetSource.containsProperty(propertyName);
    }

    public String getProperty(String propertyName) {
        return this.tilesetSource.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        this.tilesetSource.setProperty(propertyName, value);
    }

    public ObjectMap<String, String> getProperties() {
        return this.tilesetSource.getProperties();
    }

    public void drawTile(Graphics g, int tileId, int renderX, int renderY) {
        this.tilesetSource.drawTile(g, tileId, this.firstGid, renderX, renderY, 1.0f);
    }

    public void drawTile(Graphics g, int tileId, int renderX, int renderY, float alpha) {
        this.tilesetSource.drawTile(g, tileId, this.firstGid, renderX, renderY, alpha);
    }

    public void drawTileset(Graphics g, int renderX, int renderY) {
        this.tilesetSource.drawTileset(g, renderX, renderY, 1.0f);
    }

    public void drawTileset(Graphics g, int renderX, int renderY, float alpha) {
        this.tilesetSource.drawTileset(g, renderX, renderY, alpha);
    }

    public Tile getTile(int tileId) {
        return this.tilesetSource.getTile(tileId, this.firstGid);
    }

    public Tile getTile(int x, int y) {
        return this.getTile(this.tilesetSource.getTileId(x, y, this.firstGid));
    }

    public Array<AssetDescriptor> getDependencies(FileHandle tmxPath) {
        return this.tilesetSource.getDependencies(tmxPath);
    }

    public boolean isTextureLoaded() {
        return this.tilesetSource.isTextureLoaded();
    }

    public void loadTexture(FileHandle tmxPath) {
        this.tilesetSource.loadTexture(tmxPath);
    }

    public void loadTexture(AssetManager assetManager, FileHandle tmxPath) {
        this.tilesetSource.loadTexture(tmxPath);
    }

    public void loadTexture(TextureAtlas textureAtlas) {
        this.tilesetSource.loadTexture(textureAtlas);
    }

    public void dispose() {
        this.tilesetSource.dispose();
    }

    private void calculateLastGid() {
        this.lastGid = this.getWidthInTiles() * this.getHeightInTiles() + this.firstGid - 1;
    }

    public boolean contains(int tileId) {
        return this.tilesetSource.contains(tileId, this.firstGid, this.lastGid);
    }

    public int getTileId(int x, int y) {
        return this.tilesetSource.getTileId(x, y, this.firstGid);
    }

    public int getTileX(int tileId) {
        return this.tilesetSource.getTileX(tileId, this.firstGid);
    }

    public int getTileY(int tileId) {
        return this.tilesetSource.getTileY(tileId, this.firstGid);
    }

    public int getWidthInTiles() {
        return this.tilesetSource.getWidthInTiles();
    }

    public int getHeightInTiles() {
        return this.tilesetSource.getHeightInTiles();
    }

    public int getWidth() {
        return this.tilesetSource.getWidth();
    }

    public int getHeight() {
        return this.tilesetSource.getHeight();
    }

    public int getTileWidth() {
        return this.tilesetSource.getTileWidth();
    }

    public int getTileHeight() {
        return this.tilesetSource.getTileHeight();
    }

    public int getSpacing() {
        return this.tilesetSource.getSpacing();
    }

    public int getMargin() {
        return this.tilesetSource.getMargin();
    }

    public int getFirstGid() {
        return this.firstGid;
    }

    public TilesetSource getTilesetSource() {
        return this.tilesetSource;
    }

    public String getSourceInternalUuid() {
        return this.tilesetSource.getInternalUuid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tileset tileset = (Tileset)o;
        return this.firstGid == tileset.firstGid && Objects.equals(this.tilesetSource, tileset.tilesetSource);
    }

    public int hashCode() {
        return Objects.hash(this.tilesetSource, this.firstGid);
    }

    public String toString() {
        return "Tileset{tilesetSource=" + this.tilesetSource + ", firstGid=" + this.firstGid + '}';
    }
}

