/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.collisions;

import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.collisions.TiledCollisionFactory;
import org.mini2Dx.tiled.collisions.TiledCollisionMerger;

public enum TileMergeMode {
    Y_THEN_X{

        @Override
        public <T extends Positionable> T merge(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger, int startX, int startY, int maxColumns, int maxRows, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
            int x;
            Tile startTile = tiledMap.getTile(layer.getTileId(startX, startY));
            int maxXTiles = 0;
            int maxYTiles = 0;
            if (maxRows > 1) {
                int y = 1;
                while (y < layer.getHeight() - startY && collisions[startX][startY + y] != 0 && collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX, startY + y) && (maxYTiles = y++) < maxRows - 1) {
                }
            }
            if (maxColumns > 1) {
                x = 1;
                while (x < layer.getWidth() - startX) {
                    boolean mergeable = true;
                    for (int y = 0; y <= maxYTiles; ++y) {
                        if (collisions[startX + x][startY + y] == 0) {
                            mergeable = false;
                            break;
                        }
                        if (collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + x, startY + y)) continue;
                        mergeable = false;
                        break;
                    }
                    if (!mergeable || (maxXTiles = x++) >= maxColumns - 1) break;
                }
            }
            for (x = 0; x <= maxXTiles; ++x) {
                for (int y = 0; y <= maxYTiles; ++y) {
                    collisions[startX + x][startY + y] = 0;
                }
            }
            return collisionFactory.createCollision(tiledMap, startTile, startX * tiledMap.getTileWidth(), startY * tiledMap.getTileHeight(), tiledMap.getTileWidth() + maxXTiles * tiledMap.getTileWidth(), tiledMap.getTileHeight() + maxYTiles * tiledMap.getTileHeight());
        }
    }
    ,
    X_THEN_Y{

        @Override
        public <T extends Positionable> T merge(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger, int startX, int startY, int maxColumns, int maxRows, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
            int x;
            Tile startTile = tiledMap.getTile(layer.getTileId(startX, startY));
            int maxXTiles = 0;
            int maxYTiles = 0;
            if (maxColumns > 1) {
                x = 1;
                while (x < layer.getWidth() - startX && collisions[startX + x][startY] != 0 && collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + x, startY) && (maxXTiles = x++) < maxColumns - 1) {
                }
            }
            if (maxRows > 1) {
                int y = 1;
                while (y < layer.getHeight() - startY) {
                    boolean mergeable = true;
                    for (int x2 = 0; x2 <= maxXTiles; ++x2) {
                        if (collisions[startX + x2][startY + y] == 0) {
                            mergeable = false;
                            break;
                        }
                        if (collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + x2, startY + y)) continue;
                        mergeable = false;
                        break;
                    }
                    if (!mergeable || (maxYTiles = y++) >= maxRows - 1) break;
                }
            }
            for (x = 0; x <= maxXTiles; ++x) {
                for (int y = 0; y <= maxYTiles; ++y) {
                    collisions[startX + x][startY + y] = 0;
                }
            }
            return collisionFactory.createCollision(tiledMap, startTile, startX * tiledMap.getTileWidth(), startY * tiledMap.getTileHeight(), tiledMap.getTileWidth() + maxXTiles * tiledMap.getTileWidth(), tiledMap.getTileHeight() + maxYTiles * tiledMap.getTileHeight());
        }
    }
    ,
    X_THEN_Y_ALTERNATING{

        @Override
        public <T extends Positionable> T merge(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger, int startX, int startY, int maxColumns, int maxRows, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
            int y;
            int x;
            Tile startTile = tiledMap.getTile(layer.getTileId(startX, startY));
            int maxXTiles = 0;
            int maxYTiles = 0;
            if (maxColumns > 1 && maxRows > 1) {
                x = 1;
                y = 0;
                while (x < layer.getWidth() - startX && y < layer.getHeight() - startY) {
                    boolean mismatch = false;
                    for (int tx = 0; tx <= x; ++tx) {
                        for (int ty = 0; ty <= y; ++ty) {
                            if (collisions[startX + tx][startY + ty] == 0) {
                                mismatch = true;
                                break;
                            }
                            if (collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + tx, startY + ty)) continue;
                            mismatch = true;
                            break;
                        }
                        if (mismatch) break;
                    }
                    if (mismatch) break;
                    maxXTiles = x;
                    maxYTiles = y;
                    if (x > y) {
                        ++y;
                    } else {
                        ++x;
                    }
                    if (maxXTiles < maxColumns - 1 && maxYTiles < maxRows - 1) continue;
                    break;
                }
            }
            for (x = 0; x <= maxXTiles; ++x) {
                for (y = 0; y <= maxYTiles; ++y) {
                    collisions[startX + x][startY + y] = 0;
                }
            }
            return collisionFactory.createCollision(tiledMap, startTile, startX * tiledMap.getTileWidth(), startY * tiledMap.getTileHeight(), tiledMap.getTileWidth() + maxXTiles * tiledMap.getTileWidth(), tiledMap.getTileHeight() + maxYTiles * tiledMap.getTileHeight());
        }
    }
    ,
    Y_THEN_X_ALTERNATING{

        @Override
        public <T extends Positionable> T merge(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger, int startX, int startY, int maxColumns, int maxRows, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
            int y;
            int x;
            Tile startTile = tiledMap.getTile(layer.getTileId(startX, startY));
            int maxXTiles = 0;
            int maxYTiles = 0;
            if (maxColumns > 1 && maxRows > 1) {
                x = 0;
                y = 1;
                while (x < layer.getWidth() - startX && y < layer.getHeight() - startY) {
                    boolean mismatch = false;
                    for (int tx = 0; tx <= x; ++tx) {
                        for (int ty = 0; ty <= y; ++ty) {
                            if (collisions[startX + tx][startY + ty] == 0) {
                                mismatch = true;
                                break;
                            }
                            if (collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + tx, startY + ty)) continue;
                            mismatch = true;
                            break;
                        }
                        if (mismatch) break;
                    }
                    if (mismatch) break;
                    maxXTiles = x;
                    maxYTiles = y;
                    if (y > x) {
                        ++x;
                    } else {
                        ++y;
                    }
                    if (maxXTiles < maxColumns - 1 && maxYTiles < maxRows - 1) continue;
                    break;
                }
            }
            for (x = 0; x <= maxXTiles; ++x) {
                for (y = 0; y <= maxYTiles; ++y) {
                    collisions[startX + x][startY + y] = 0;
                }
            }
            return collisionFactory.createCollision(tiledMap, startTile, startX * tiledMap.getTileWidth(), startY * tiledMap.getTileHeight(), tiledMap.getTileWidth() + maxXTiles * tiledMap.getTileWidth(), tiledMap.getTileHeight() + maxYTiles * tiledMap.getTileHeight());
        }
    }
    ,
    SQUARE{

        @Override
        public <T extends Positionable> T merge(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger, int startX, int startY, int maxColumns, int maxRows, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
            Tile startTile = tiledMap.getTile(layer.getTileId(startX, startY));
            int maxXTiles = 0;
            int maxYTiles = 0;
            if (maxColumns > 1 && maxRows > 1) {
                int xy = 1;
                while (xy < layer.getWidth() - startX && xy < layer.getHeight() - startY) {
                    boolean mergable = true;
                    for (int x = 0; x <= xy; ++x) {
                        if (collisions[startX + x][startY + xy] == 0) {
                            mergable = false;
                            break;
                        }
                        if (collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + x, startY + xy)) continue;
                        mergable = false;
                        break;
                    }
                    if (mergable) {
                        for (int y = 0; y <= xy; ++y) {
                            if (collisions[startX + xy][startY + y] == 0) {
                                mergable = false;
                                break;
                            }
                            if (collisionMerger.isMergable(tiledMap, layer, startTile, startX, startY, startX + xy, startY + y)) continue;
                            mergable = false;
                            break;
                        }
                    }
                    if (!mergable) break;
                    maxXTiles = xy;
                    maxYTiles = xy++;
                    if (maxXTiles >= maxColumns - 1 || maxYTiles >= maxRows - 1) break;
                }
            }
            for (int x = 0; x <= maxXTiles; ++x) {
                for (int y = 0; y <= maxYTiles; ++y) {
                    collisions[startX + x][startY + y] = 0;
                }
            }
            return collisionFactory.createCollision(tiledMap, startTile, startX * tiledMap.getTileWidth(), startY * tiledMap.getTileHeight(), tiledMap.getTileWidth() + maxXTiles * tiledMap.getTileWidth(), tiledMap.getTileHeight() + maxYTiles * tiledMap.getTileHeight());
        }
    };


    public abstract <T extends Positionable> T merge(TiledCollisionFactory<T> var1, TiledCollisionMerger var2, int var3, int var4, int var5, int var6, byte[][] var7, TileLayer var8, TiledMap var9);
}

