/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.collisions;

import org.mini2Dx.core.collision.QuadTree;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.TiledObject;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.collisions.TileMergeMode;
import org.mini2Dx.tiled.collisions.TiledCollisionFactory;
import org.mini2Dx.tiled.collisions.TiledCollisionMerger;
import org.mini2Dx.tiled.collisions.merger.TileIdCollisionMerger;

public class TiledCollisionMapper<T extends Positionable> {
    private final TileMergeMode mergeMode;
    private final TiledCollisionFactory<T> collisionFactory;
    private final TiledCollisionMerger collisionMerger;

    public TiledCollisionMapper(TiledCollisionFactory<T> collisionFactory) {
        this(collisionFactory, new TileIdCollisionMerger());
    }

    public TiledCollisionMapper(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger) {
        this(collisionFactory, collisionMerger, TileMergeMode.SQUARE);
    }

    public TiledCollisionMapper(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger, TileMergeMode mergeMode) {
        this.collisionFactory = collisionFactory;
        this.collisionMerger = collisionMerger;
        this.mergeMode = mergeMode;
    }

    public static byte[][] mapCollisionsByLayer(TiledMap tiledMap, String layerName) {
        return TiledCollisionMapper.mapCollisionsByLayer(tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public static byte[][] mapCollisionsByLayer(TiledMap tiledMap, int layerIndex) {
        return TiledCollisionMapper.mapCollisionsByLayer(tiledMap, tiledMap.getTileLayer(layerIndex));
    }

    public static byte[][] mapCollisionsByLayer(TiledMap tiledMap, TileLayer layer) {
        byte[][] result = new byte[layer.getWidth()][layer.getHeight()];
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (layer.getTileId(x, y) <= 0) continue;
                result[x][y] = 1;
            }
        }
        return result;
    }

    public static byte[][] mapEmptySpacesByLayer(TiledMap tiledMap, String layerName) {
        return TiledCollisionMapper.mapEmptySpacesByLayer(tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public static byte[][] mapEmptySpacesByLayer(TiledMap tiledMap, int layerIndex) {
        return TiledCollisionMapper.mapEmptySpacesByLayer(tiledMap, tiledMap.getTileLayer(layerIndex));
    }

    private static byte[][] mapEmptySpacesByLayer(TiledMap tiledMap, TileLayer layer) {
        byte[][] result = new byte[layer.getWidth()][layer.getHeight()];
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (layer.getTileId(x, y) != 0) continue;
                result[x][y] = 1;
            }
        }
        return result;
    }

    public void mapCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (layer.getTileId(x, y) <= 0 || (collision = this.collisionFactory.createCollision(tiledMap, tiledMap.getTile(layer.getTileId(x, y)), x * tiledMap.getTileWidth(), y * tiledMap.getTileHeight(), tiledMap.getTileWidth(), tiledMap.getTileHeight())) == null) continue;
                quadTree.add(collision);
            }
        }
    }

    public void mapEmptySpacesByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (layer.getTileId(x, y) != 0 || (collision = this.collisionFactory.createCollision(tiledMap, tiledMap.getTile(layer.getTileId(x, y)), x * tiledMap.getTileWidth(), y * tiledMap.getTileHeight(), tiledMap.getTileWidth(), tiledMap.getTileHeight())) == null) continue;
                quadTree.add(collision);
            }
        }
    }

    public void mapCollisionsByLayer(Array<T> results, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (layer.getTileId(x, y) <= 0 || (collision = this.collisionFactory.createCollision(tiledMap, tiledMap.getTile(layer.getTileId(x, y)), x * tiledMap.getTileWidth(), y * tiledMap.getTileHeight(), tiledMap.getTileWidth(), tiledMap.getTileHeight())) == null) continue;
                results.add(collision);
            }
        }
    }

    public void mapEmptySpacesByLayer(Array<T> results, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (layer.getTileId(x, y) != 0 || (collision = this.collisionFactory.createCollision(tiledMap, tiledMap.getTile(layer.getTileId(x, y)), x * tiledMap.getTileWidth(), y * tiledMap.getTileHeight(), tiledMap.getTileWidth(), tiledMap.getTileHeight())) == null) continue;
                results.add(collision);
            }
        }
    }

    public void mapCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, String layerName) {
        this.mapCollisionsByLayer(quadTree, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapCollisionsByLayer(Array<T> results, TiledMap tiledMap, String layerName) {
        this.mapCollisionsByLayer(results, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapEmptySpacesByLayer(QuadTree<T> quadTree, TiledMap tiledMap, String layerName) {
        this.mapEmptySpacesByLayer(quadTree, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapEmptySpacesByLayer(Array<T> results, TiledMap tiledMap, String layerName) {
        this.mapEmptySpacesByLayer(results, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapCollisionsByObjectGroup(QuadTree<T> quadTree, TiledMap tiledMap, String groupName) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            T collision = this.collisionFactory.createCollision(tiledMap, tiledObject);
            if (collision == null) continue;
            quadTree.add(collision);
        }
    }

    public void mapCollisionsByObjectGroup(QuadTree<T> quadTree, TiledMap tiledMap, String groupName, String objectType) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            T collision;
            if (tiledObject.getType() == null || !tiledObject.getType().equalsIgnoreCase(objectType) || (collision = this.collisionFactory.createCollision(tiledMap, tiledObject)) == null) continue;
            quadTree.add(collision);
        }
    }

    public void mapCollisionsByObjectGroup(Array<T> results, TiledMap tiledMap, String groupName) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            T collision = this.collisionFactory.createCollision(tiledMap, tiledObject);
            if (collision == null) continue;
            results.add(collision);
        }
    }

    public void mapCollisionsByObjectGroup(Array<T> results, TiledMap tiledMap, String groupName, String objectType) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            T collision;
            if (tiledObject.getType() == null || !tiledObject.getType().equalsIgnoreCase(objectType) || (collision = this.collisionFactory.createCollision(tiledMap, tiledObject)) == null) continue;
            results.add(collision);
        }
    }

    public void mapAndMergeCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, String layerName) {
        this.mapAndMergeCollisionsByLayer(quadTree, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapAndMergeCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex) {
        this.mapAndMergeCollisionsByLayer(quadTree, tiledMap, layerIndex, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void mapAndMergeCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex, int maxColumns, int maxRows) {
        if (layerIndex < 0) {
            return;
        }
        if (maxColumns < 0) {
            throw new MdxException("maxColumns cannot be less than 1");
        }
        if (maxRows < 0) {
            throw new MdxException("maxRows cannot be less than 1");
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        byte[][] collisions = TiledCollisionMapper.mapCollisionsByLayer(tiledMap, layer);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (collisions[x][y] == 0 || (collision = this.mergeCollisions(x, y, maxColumns, maxRows, collisions, layer, tiledMap)) == null) continue;
                quadTree.add(collision);
            }
        }
    }

    public void mapAndMergeEmptySpacesByLayer(QuadTree<T> quadTree, TiledMap tiledMap, String layerName) {
        this.mapAndMergeEmptySpacesByLayer(quadTree, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapAndMergeEmptySpacesByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex) {
        this.mapAndMergeEmptySpacesByLayer(quadTree, tiledMap, layerIndex, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void mapAndMergeEmptySpacesByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex, int maxColumns, int maxRows) {
        if (layerIndex < 0) {
            return;
        }
        if (maxColumns < 0) {
            throw new MdxException("maxColumns cannot be less than 1");
        }
        if (maxRows < 0) {
            throw new MdxException("maxRows cannot be less than 1");
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        byte[][] emptySpaces = TiledCollisionMapper.mapEmptySpacesByLayer(tiledMap, layer);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (emptySpaces[x][y] == 0 || (collision = this.mergeCollisions(x, y, maxColumns, maxRows, emptySpaces, layer, tiledMap)) == null) continue;
                quadTree.add(collision);
            }
        }
    }

    public void mapAndMergeCollisionsByLayer(Array<T> results, TiledMap tiledMap, String layerName) {
        this.mapAndMergeCollisionsByLayer(results, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapAndMergeCollisionsByLayer(Array<T> results, TiledMap tiledMap, int layerIndex) {
        this.mapAndMergeCollisionsByLayer(results, tiledMap, layerIndex, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void mapAndMergeCollisionsByLayer(Array<T> results, TiledMap tiledMap, int layerIndex, int maxColumns, int maxRows) {
        if (layerIndex < 0) {
            return;
        }
        if (maxColumns < 0) {
            throw new MdxException("maxColumns cannot be less than 1");
        }
        if (maxRows < 0) {
            throw new MdxException("maxRows cannot be less than 1");
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        byte[][] collisions = TiledCollisionMapper.mapCollisionsByLayer(tiledMap, layer);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (collisions[x][y] == 0 || (collision = this.mergeCollisions(x, y, maxColumns, maxRows, collisions, layer, tiledMap)) == null) continue;
                results.add(collision);
            }
        }
    }

    public void mapAndMergeEmptySpacesByLayer(Array<T> results, TiledMap tiledMap, String layerName) {
        this.mapAndMergeEmptySpacesByLayer(results, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapAndMergeEmptySpacesByLayer(Array<T> results, TiledMap tiledMap, int layerIndex) {
        this.mapAndMergeEmptySpacesByLayer(results, tiledMap, layerIndex, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void mapAndMergeEmptySpacesByLayer(Array<T> results, TiledMap tiledMap, int layerIndex, int maxColumns, int maxRows) {
        if (layerIndex < 0) {
            return;
        }
        if (maxColumns < 0) {
            throw new MdxException("maxColumns cannot be less than 1");
        }
        if (maxRows < 0) {
            throw new MdxException("maxRows cannot be less than 1");
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        byte[][] emptySpaces = TiledCollisionMapper.mapEmptySpacesByLayer(tiledMap, layer);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                T collision;
                if (emptySpaces[x][y] == 0 || (collision = this.mergeCollisions(x, y, maxColumns, maxRows, emptySpaces, layer, tiledMap)) == null) continue;
                results.add(collision);
            }
        }
    }

    protected T mergeCollisions(int startX, int startY, int maxColumns, int maxRows, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
        return this.mergeMode.merge(this.collisionFactory, this.collisionMerger, startX, startY, maxColumns, maxRows, collisions, layer, tiledMap);
    }
}

